function FulfillmentDashboardController ($scope, $rootScope, $http, $timeout) {

    const CHART_FULFILLMENT = 'chart-fulfillment';
    const CHART_FULFILLMENT_PIE = 'chart-fulfillment-pie';

    $scope.fulfillment_orderListEndpoint = '/admin/orders';

    this.init = () => {

        if (!document.getElementById(CHART_FULFILLMENT)) {
            return;
        }

        return new Promise (function (resolve) 
        {
            $timeout(function () {

                $scope.chartFulfillmentLine = Highcharts.chart(CHART_FULFILLMENT, {
                    chart: {
                        type: 'line'
                    },
                    title: {
                        text: null
                    },
                    subtitle: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: []
                    },
                    yAxis: {
                        // min: 0,
                        title: {
                            text: 'Vấn đề'
                        },
                        labels: {
                            enabled: false
                        },
                    },
                    tooltip: {
                        pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.y}</b><br/>',
                        shared: true
                    },
                    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: []
                });

                /* $scope.chartFulfillmentPie =  Highcharts.chart(CHART_FULFILLMENT_PIE, {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        type: 'pie'
                    },
                    credits: {
                        enabled: false
                    },
                    title: {
                        text: null
                    },
                    tooltip: {
                        pointFormat: '<b>{point.y} | {point.percentage:.1f}%</b>'
                    },
                    accessibility: {
                        point: {
                            valueSuffix: '%'
                        }
                    },
                    plotOptions: {
                        pie: {
                            allowPointSelect: true,
                            cursor: 'pointer',
                            dataLabels: {
                                enabled: true,
                                format: '<b>{point.name}</b>: {point.value:.1f} {point.percentage:.1f} %'
                            }
                        }
                    },
                    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: []
                }); */

                resolve();

            }, 100);
        });
    }

    this.renderChart = function () 
    {
        if (!document.getElementById(CHART_FULFILLMENT)) {
            return;
        }

        $scope.chartFulfillmentLine.showLoading();
        // $scope.chartFulfillmentPie.showLoading();

        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();

        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);

        const localizationParams = {
            dateFrom: dateFrom.getTime() / 1000,
            dateTo: dateTo.getTime() / 1000,
            locale: $scope.currentLocale.locale
        };

        let endPoint = '/dashboard/fulfillment/order-problems';
        if ($scope.currentLocale.locale != 'us') {
            endPoint = '/' + $scope.currentLocale.locale + endPoint;
            $scope.fulfillment_orderListEndpoint = '/' + $scope.currentLocale.locale + $scope.fulfillment_orderListEndpoint;
        }

        $http.get(endPoint, { params: localizationParams }).then(function (response) {
            if (response.data.status == "successful") {

                while ($scope.chartFulfillmentLine.series.length) {
                    $scope.chartFulfillmentLine.series[0].remove();
                }

                /* while ($scope.chartFulfillmentPie.series.length) {
                    $scope.chartFulfillmentPie.series[0].remove();
                } */

                $scope.chartFulfillmentLine.xAxis[0].setCategories(response.data.xAxis);

               /*  const groupByType = {
                    colorByPoint: true,
                    data: []
                }; */

                for (const key in response.data.yAxis) {
                    if (Object.hasOwnProperty.call(response.data.yAxis, key)) {
                        const yAxis = response.data.yAxis[key];
                        $scope.chartFulfillmentLine.addSeries({
                            name: mapKeyTitle(key),
                            data: Object.values(yAxis)
                        });
                    }
                }

                $scope.fulfillmentPieData = response.data.pieData;

                /* for (const key in response.data.pieData) {
                    if (Object.hasOwnProperty.call(response.data.pieData, key)) {
                        const piePart = response.data.pieData[key];
                        groupByType.data.push({
                            name: key.charAt(0).toUpperCase() + key.slice(1),
                            y: piePart
                        });
                    }
                } */

                /* groupByType.data.sort((a, b) => b.y - a.y);
                $scope.chartFulfillmentPie.addSeries(groupByType); */

                $scope.chartFulfillmentLine.hideLoading();
                // $scope.chartFulfillmentPie.hideLoading();

            }
        });

    }

    function mapKeyTitle(keyTitle) {

        const map = {
            issue: 'Đơn đi rồi có vấn đề',
            delay: 'Đơn hàng tồn',
            fulfill: 'Đơn fulfill muộn',
            ship: 'Đơn giao không đúng hẹn'
        }

        for (const key in map) {
            if (Object.hasOwnProperty.call(map, key)) {
                const title = map[key];
                if (keyTitle == key) return title;
            }
        }

        return keyTitle.charAt(0).toUpperCase() + keyTitle.slice(1);
    }

    $scope.fulfillment_mapKeyTitle = mapKeyTitle;
}