system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

system.controller("ReportSaleChangeController", function ($scope, $rootScope, $http) {
    $scope.filter = {};

    $scope.reportItems = [];

    $scope.initialize = function () {
        $scope.initDatePicker();
        $scope.find();
    }

    $scope.clear = function () {
        $scope.filter = {};
        $scope.reportItems = [];
        $scope.initDatePicker();
        $scope.find();
    }

    $scope.find = function () {
        $scope.reportItems = [];

        $http.post('/dashboard/get-report-product-sale-change', $scope.filter)
            .then (res => {
                if (res.data.status == 'successful') {
                    $scope.reportItems = res.data.result;
                }
            })
    }

    $scope.padZero = function (num) {
        return num > 9 ? num : `0${num}`;
    }

    $scope.formatDate = function (date) {
        return $scope.padZero(date.getDate()) + '/' + $scope.padZero(date.getMonth() + 1) + '/' + date.getFullYear();
    }

    $scope.initDatePicker = function () {
        var now = (new Date()).getTime();
        let dayLength = 86400 * 1000;
        var period = 7 * dayLength;

        var lastPeriodTo = (new Date()).setTime(now - period - dayLength);
        var lastPeriodFrom = (new Date()).setTime(now - 2 * period - dayLength);

        $scope.filter.date_from = $scope.formatDate(new Date(now - period));
        $scope.filter.date_to = $scope.formatDate(new Date());

        $scope.filter.last_period_date_from = $scope.formatDate(new Date(lastPeriodFrom));
        $scope.filter.last_period_date_to = $scope.formatDate(new Date(lastPeriodTo));
    }

    $scope.buildUrl = function (url) {
        if (typeof localePrefix != "undefined" && localePrefix != "us") {
            return `/${localePrefix}${url}`;
        }

        return url;
    }

    $scope.initialize();
});