system.controller("StatisticController", function ($scope, $rootScope, $http, $timeout) {
    $scope.statisticValue = {
        product: {
            type: 'number',
            value: 0,
        },
        product_template: {
            type: 'number',
            value: 0,
        },
        auto_fullfill: {
            type: 'number',
            value: 0,
        },
        order: {
            type: 'time',
            value: 0,
        },
        design: {
            type: 'time',
            value: 0,
        },
        ticket: {
            type: 'time',
            value: 0,
        },
    };

    $scope.initialize = () => {
        $scope.fetchValues();
    }

    $scope.numberToTime = (value) => {
        value = Math.floor(value);

        let timeComponents = [
            {
                field: 'Ngày',
                duration: 86400,
                value: 0,
            },
            {
                field: 'Giờ',
                duration: 3600,
                value: 0,
            },
            {
                field: 'Phút',
                duration: 60,
                value: 0,
            },
            {
                field: 'Giây',
                duration: 1,
                value: 0,
            },
        ];
        let showIndex = timeComponents.length;
        for (let key in timeComponents) {
            let component = timeComponents[key];
            component.value = Math.floor(value / component.duration);
            value = value % component.duration;
            timeComponents[key] = component;
            if (component.value > 0 && key < showIndex) {
                showIndex = key;
            }
        }

        return timeComponents.map(item => `${item.value} ${item.field}`).filter((item, index) => index >= showIndex).join(', ');
    }

    $scope.fetchValues = () => {
        $http.get('/dashboard/get-statistic')
            .then(res => {
                if (res.data.status == 'successful') {
                    let result = res.data.result;
                    for (let key of Object.keys($scope.statisticValue)) {
                        if (result[key]) {
                            if ($scope.statisticValue[key].type == 'number') {
                                $scope.statisticValue[key].value = result[key];
                            } else if ($scope.statisticValue[key].type == 'time') {
                                $scope.statisticValue[key].value = $scope.numberToTime(result[key]);
                            }
                        }
                    }
                }
            })
    }

    $scope.initialize();
});