@extends('system.layout.main', [])

@section('title')
    <title>{{ __('Event Dashboard') }}</title>
@endsection

@section('content')

<style type="text/css">
    #dashboard-container .box-title {
        font-weight: normal;
    }

    .mh-200 {
        max-height: 200px;
        overflow: scroll;
    }

    #dashboard-container .input-group-addon {
        background-color: #eee;
    }

</style>
<div class="content" ng-controller="EventDashboardController" id="dashboard-container" ng-cloak>
    <div class="row">
        <div class="col-md-12 text-left" style="margin-bottom: 20px">
            <form class="form-inline">

                <div class="input-group">
                    <span class="input-group-addon">Từ ngày</span>
                    <input type="text" class="form-control" placeholder="Username" id="date-from" placeholder="yyyy-mm-dd" autocomplete="off">
                </div>

                <div class="input-group">
                    <span class="input-group-addon">Đến</span> 
                    <input type="text" class="form-control" placeholder="Username" id="date-to" placeholder="yyyy-mm-dd" autocomplete="off">
                </div>

                <div class="input-group">
                    <span class="input-group-addon">Thị trường</span> 
                    <select class="form-control" ng-model="currentLocale" ng-change="changeCurrentLocale()" ng-options="item.locale as item.name for item in localization">
                    </select>
                </div>

                <div style="margin: 10px"></div>

                <div class="input-group">
                    <span class="input-group-addon">Sự kiện</span>
                    <select class="form-control" ng-model="currentEvent" ng-change="find()" style="min-width: 250px">
                        <option value="@{{ event.id }}" ng-repeat="event in seasonEvents">@{{ event.name }}</option>
                        <option value="">-- Tất cả --</option>
                    </select>
                </div>
                
                <div class="form-group text-center">
                    <button type="button" class="btn btn-primary" ng-click="find()">
                        <strong>Xem thống kê</strong>
                    </button>
                </div>

                <small class="text-muted">(chọn thời gian và thị trường để tải sự kiện phù hợp)</small>

            </form>
        </div>
    </div>
    @if (hasPermission('view_dashboard'))
        {{-- <div class="row">
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Đơn hàng theo các quốc gia</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            </div>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="chart-by-order-localization"></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Doanh thu <small>(USD)</small></h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            </div>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="chart-by-revenue-localization"></div>
                    </div>
                </div>
            </div>
        </div> --}}
        <div class="row">
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Đơn hàng theo từng ngày <small>(USD)</small></h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" style="min-height: 500px">
                        <div id="chart-by-day"></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-3">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Đơn hàng theo danh mục</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            </div>
                    </div>
                    <div class="box-body" style="min-height: 500px">
                        <div id="chart-by-category"></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-3">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Đơn hàng theo nguồn</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            </div>
                    </div>
                    <div class="box-body" style="min-height: 500px">
                        <div id="chart-by-source"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Sản phẩm bán chạy</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            </div>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="chart-by-product" style="width:100%"></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Đơn hàng theo danh mục & nguồn</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="chart-by-category-source"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            @if (hasPermission('view_dashboard'))
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Order/Cart, Order/View và Giá trị trung bình 1 đơn hàng</h4>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="chart-order-by-conversion-timeline" style="width:100%"></div>
                    </div>
                </div>
            </div>
        @endif
        </div>
    @endif

</div>    
@endsection

@section('script')
<script type="text/javascript">
    @php
        $locales = array_values(array_filter(getModuleLocale(), function($config) {
            return $config['enable'] && $config['locale'] != 'glob';
        }));
    @endphp
    var configAds = '<?= json_encode(config('ads')) ?>';
    var configAdsObj = null;
    if (configAds) {
        configAds = JSON.parse(configAds);
        if (configAds && typeof configAds['summary_params'] != 'undefined') {
            configAdsObj = configAds['summary_params'];
        }
    }
    var dashboardLocalization = {!! json_encode($locales) !!};
    var currentLocale = "{{ (!empty(env('APP_LOCALE'))) ? env('APP_LOCALE') : 'us' }}";
    var siteName = "{{strtolower(config('app.name'))}}";
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/highcharts/10.3.3/highcharts.js"></script>
<script src="@asset('dashboard/js/event-dashboard-controller.js')?v={{ config('sa.version') }}" charset="utf-8"></script>
@endsection