
<style type="text/css">
    #dashboard-container .box-title {
        font-weight: normal;
    }

    .mh-200 {
        max-height: 200px;
        overflow: scroll;
    }
</style>
<div class="content" ng-controller="DashboardController" id="dashboard-container" ng-cloak>
    <div class="row">
        <div class="col-md-12 text-left" style="margin-bottom: 20px">
            <form class="form-inline">
                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-addon">Từ <span class="hidden-xs">ngày</span></span>
                        <input type="text" class="form-control" id="date-from" placeholder="yyyy-mm-dd" autocomplete="off" />
                        <span class="input-group-addon">đến <span class="hidden-xs">ngày</span></span>
                        <input type="text" class="form-control" id="date-to" placeholder="yyyy-mm-dd" autocomplete="off" />
                    </div>
                </div>
                
                <div class="form-group text-center">
                    <button type="button" class="btn btn-primary" ng-click="find()">Xem thống kê</button>
                </div>
            </form>
        </div>
    </div>
    @if (hasPermission('view_dashboard'))
        <div class="row">
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Đơn hàng theo các quốc gia</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            </div>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="chart-by-order-localization"></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Doanh thu và chi phí quảng cáo <small>(USD)</small></h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            </div>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="chart-by-revenue-localization"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
           <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Đơn hàng theo từng ngày <small>(USD)</small></h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" style="min-height: 500px">
                        <div class="form-group">
                            <select class="form-control" ng-model="currentLocale.locale" ng-change="changeCurrentLocale()" ng-options="item.locale as item.name for item in localization">
                            </select>
                        </div>
                        <div id="chart-by-order"></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Biểu đồ theo giờ</small></h4>
                        <div class="box-tools pull-right">
                            <div class="form-group">
                                <select class="form-control" ng-model="currentLocale.locale" ng-change="changeCurrentLocale()" ng-options="item.locale as item.name for item in localization">
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <select class="form-control" ng-change="changeHourReportType()"  ng-model="hourReportType.key"  ng-options="item.key as item.value for item in hourReportTypes">
                                </select>
                                <div class="form-group">
                                    <div style="padding: 6px; 10px; font-size: 17px; background-color: rgb(80, 180, 50); color: white" ng-show="totalCompareDay[1]" ng-bind="totalCompareDay[1]" class="bg-success color-palette">1</div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <input type="text" class="form-control" id="date-compare" placeholder="yyyy-mm-dd" autocomplete="off" />
                                <div class="form-group">
                                    <div style="padding: 6px; 10px; font-size: 17px" ng-show="totalCompareDay[0]"  ng-bind="totalCompareDay[0]" class="bg-gray color-palette">1</div>
                                </div>
                            </div>
                        </div>
                        <div id="chart-by-hour"></div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if (hasPermission('statistics.report_order_by_attributes'))
        <div class="row">
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Sản phẩm bán chạy</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            </div>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="chart-by-product" style="width:100%"></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-3">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Đơn hàng theo danh mục</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" style="min-height: 500px">
                        <div id="chart-by-category"></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-3">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Đơn hàng theo nguồn</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" style="min-height: 500px">
                        <div id="chart-by-source"></div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="row">
        @if (hasPermission('statistics.report_order_by_attributes'))
        <div class="col-xs-12 col-sm-6">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h4 class="box-title">Đơn hàng theo thiết bị</h4>
                    <select class="form-control pull-right" 
                        style="width: auto"
                        ng-model="currentLocale.locale" 
                        ng-change="changeCurrentLocale()" 
                        ng-options="item.locale as item.name for item in localization">
                    </select>
                </div>

                <div class="box-body" style="min-height: 400px">
                    <div id="chart-order-by-device-timline" stylse="width:100%"></div>
                </div>
            </div>
        </div>

        @endif 
        @if (hasPermission('statistics.report_conversion'))
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Order/Cart, Order/View và Giá trị trung bình 1 đơn hàng</h4>
                        <select class="form-control pull-right" 
                            style="width: auto"
                            ng-model="currentLocale.locale" 
                            ng-change="changeCurrentLocale()" 
                            ng-options="item.locale as item.name for item in localization">
                        </select>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="chart-order-by-conversion-timeline" style="width:100%"></div>
                    </div>
                </div>
            </div>
        @endif
    </div>

    @if (hasPermission('statistics.customer_behavior'))
    <div class="row">
        <div class="col-xs-12 col-sm-12">
        <div class="box box-default">
            <div class="box-header with-border">
                <h4 class="box-title">Biểu đồ tương tác khách hàng</h4>
                <select class="form-control pull-right"
                    style="width: auto"
                    ng-model="currentLocale.locale"
                    ng-change="changeCurrentLocale()"
                    ng-options="item.locale as item.name for item in localization">
                </select>
                <div class="box-body" style="min-height: 400px">
                    <div class="row">
                        <div class="col-xs-12 col-sm-4">
                            <div id="chart-customer" style="width:100%;"></div>
                        </div>
                        <div class="col-xs-12 col-sm-4">

                            <div id="chart-ticket" style="width:100%;height: 200px"></div>

                            <div id="chart-ticket-pie" style="width:100%;height: 200px"></div>
                        </div>
                        <div class="col-xs-12 col-sm-4">
                            <div id="chart-ticket-scores"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>
    @endif

    @if (hasPermission('view_dashboard'))
    <div class="row">
        <div class="col-xs-12 col-sm-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h4 class="box-title">Vấn đề Fulfillment</h4>
                    <select class="form-control pull-right"
                        style="width: auto"
                        ng-model="currentLocale.locale"
                        ng-change="changeCurrentLocale()"
                        ng-options="item.locale as item.name for item in localization">
                    </select>
                    <div class="box-body" style="min-height: 400px">
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div id="chart-fulfillment"></div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                {{-- <div id="chart-fulfillment-pie"></div> --}}
                                <style>
                                    #fulfillment_orderProblemTable td a { 
                                        display: block; 
                                        /* padding: 16px; */
                                    }
                                </style>
                                <table id="fulfillment_orderProblemTable" class="table table-hover bordered" ng-show="fulfillmentPieData" style="margin-top: 8px">
                                    <tr>
                                        <th>Vấn đề (Tính đến thời điểm hiện tại)</th>
                                        <th>Số đơn</th>
                                    </tr>
                                    <tr ng-repeat="(key, count) in fulfillmentPieData">
                                        <td ng-show="!key.includes('has_ticket')">
                                            <a target="_blank" href="@{{ fulfillment_orderListEndpoint }}?order_problem=@{{ key }}">@{{ fulfillment_mapKeyTitle(key) }}@{{ key == 'fulfill' ? '(' + fulfillmentPieData['fulfill_has_ticket'] + ' đơn có ticket)' : (key == 'delay' ? '(' + fulfillmentPieData['delay_has_ticket'] + ' đơn có ticket)' : '') }}</a>
                                        </td>
                                        <td style="text-center" ng-show="!key.includes('has_ticket')">@{{ count }}</td>
                                    </tr>
                                </table>

                                <p class="text-muted" style="padding: 0 8px" ng-show="!fulfillmentPieData"><strong>Loading...</strong></p>

                                <p style="padding: 0 8px">
                                    <strong>Đơn hàng tồn:</strong> tính theo hình thức ship và tính theo trạng thái đơn hàng (Đơn hàng đã ở 1 trạng thái nào đó lâu) <br>

                                    <strong>Đơn hàng đi rồi có vấn đề:</strong> Do bên ff tích chọn lại <br>

                                    <strong>Đơn giao không đúng hẹn:</strong> đơn express > 9 ngày, đơn premium > 12 ngày, đơn standard > 19 ngày <br>

                                    <strong>Đơn fulfill muộn:</strong> Đơn express(2h), premium(4h), standard(2 ngày) chưa chuyển trạng thái “In production” <br>
                                    
                                    <strong>Các đơn này có thể chậm do đợi ticket confirm khách</strong>
                                </p>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
          </div>
    </div>
    @endif

    @if (hasPermission('statistics.google_bot_request'))
    <div class="row">
      <div class="col-xs-12 col-sm-12">
        <div class="box box-default">
          <div class="box-header with-border">
            <h4 class="box-title">Googlebot Request</h4>
          </div>
          <div class="box-body">
            <div class="row">
              <div class="col-xs-12 col-sm-6">
                <select class="form-control" ng-model="trafficReport.date" ng-change="fetchBotRequest()"
                        ng-options="item.code as item.name for item in dateReports">
                </select>
              </div>
            </div>
            <div id="chart-google-bot-request"></div>
          </div>
        </div>
      </div>
    </div>
    @endif
    @if (hasPermission('view_error_daily'))
    <div class="box box-default">
        <div class="box-header with-border">
            <h4 class="box-title">Link lỗi nhiều trong ngày</h4>
        </div>
        <div class="box-body">
            <div class="sorters">
                <div class="sort-error" ng-class="{active: sortErrorType == 'count'}" ng-click="sortErrorByCount()">
                    <span>Nhiều nhất</span>
                </div>
                <div class="sort-error" ng-class="{active: sortErrorType == 'latest'}" ng-click="sortErrorByLatest()">
                    <span>Mới nhất</span>
                </div>
            </div>
            <div id="chart-error-daily" style="max-height: 700px; overflow: auto">
                <table class="table">
                    <tr>
                        <th style="width: 20px">Locale</th>
                        <th class="col-md-5">Link</th>
                        <th class="col-md-1">Total Count</th>
                        <th class="col-md-6">Message</th>
                    </tr>
                    <tr ng-repeat="item in dailyErrorLinks">
                        <th>
                           @{{ item.locale | uppercase }}
                        </th>
                        <td>
                            <p style="word-break: break-all">@{{ item.url }}</p>
                        </td>
                        <td>@{{ item.count }}</td>
                        <td>
                            <div class="mh-200" style="word-break: break-all">
                                <table class="table">
                                    <tr>
                                        <th>Message</th>
                                        <th style="width: 100px">Occur</th>
                                        <th style="width: 80px">Count</th>
                                    </tr>
                                    <tr ng-repeat="message in item.messages">
                                        <td>@{{ message.message }}</td>
                                        <td>@{{ message.latest_occur }}</td>
                                        <td>@{{ message.count }}</td>
                                    </tr>
                                </table>
                            </div>
                        </td>
                    </tr>
                    <tr ng-if="!dailyErrorLinks.length">
                        <td colspan="4">Chưa có dữ liệu</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    @endif

    <div ng-controller="StatisticController"> 
        @if (hasPermission('view_statistic'))
            <div class="row">
                @if (hasPermission('/admin/orders'))
                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-yellow"><i class="ion ion-ios-cart-outline"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Thời gian xử lý đơn hàng trung bình</span>
                                <span class="info-box-number">@{{ statisticValue.order.value }}</span>
                            </div>
                        </div>
                    </div>
                @endif
                @if (hasPermission('module/pod'))
                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-yellow"><i class="fa fa-file-picture-o"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Thời gian xử lý Design trung bình</span>
                                <span class="info-box-number">@{{ statisticValue.design.value }}</span>
                            </div>
                        </div>
                    </div>
                @endif
                @if (hasPermission('tickets'))
                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-yellow"><i class="ion ion-ios-people-outline"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Thời gian xử lý Ticket trung bình</span>
                                <span class="info-box-number">@{{ statisticValue.ticket.value }}</span>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
            <div class="row">
                @if (hasPermission('module/pod') || hasPermission('/admin/products'))
                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-yellow"><i class="fa fa-tags"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Sp gen trong ngày</span>
                                <span class="info-box-number">@{{ statisticValue.product.value }}</span>
                            </div>
                        </div>
                    </div>
                @endif

                @if (hasPermission('module/pod') || hasPermission('/admin/products'))
                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-yellow"><i class="fa fa-tags"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Sp template gen trong ngày</span>
                                <span class="info-box-number">@{{ statisticValue.product_template.value }}</span>
                            </div>
                        </div>
                    </div>
                @endif

                @if (hasPermission('/admin/orders'))
                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-yellow"><i class="ion ion-ios-gear-outline"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Tỉ lệ auto fullfil</span>
                                <span class="info-box-number">@{{ statisticValue.auto_fullfill.value }}%</span>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        @endif
    </div>
    
    @if (hasPermission('view_statistic'))
        <div class="row">
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Sản phẩm crawl theo nguồn</h4>
                        <select class="form-control pull-right" 
                            style="width: auto"
                            ng-model="currentLocale.locale" 
                            ng-change="changeCurrentLocale()" 
                            ng-options="item.locale as item.name for item in localization">
                        </select>
                    </div>
                    <div class="box-body">
                        <table class="table table-responsive">
                            <tr>
                                <th>Site</th>
                                <th>SL sản phẩm</th>
                            </tr>
                            <tr ng-repeat="item in productCountBySource">
                                <td>@{{ item.site }}</td>
                                <td>@{{ item.count }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
