@extends('system.layout.main')
@section('title')
    <title>Sản phẩm tăng/giảm doanh số</title>
@endsection

@section('css')

@endsection

@section('script')
    <script>
        $('#filter > button').on('click', function(event) {
            $(this).parent().toggleClass('open');
        });
        $('body').on('click', function(e) {
            if (!$('#filter').is(e.target) &&
                $('#filter').has(e.target).length === 0 &&
                $('.open').has(e.target).length === 0
            ) {
                $('#filter').removeClass('open');
            }
        });
    </script>
    <script type="text/javascript" src="{{ Module::asset('dashboard/js/report-sale-change-controller.js') }}?v=<?= time() ?>"></script>
@endsection

@section('content')
<div class="content-wrapper">
    <div class="content" ng-controller="ReportSaleChangeController" id="ReportSaleChangeController">
        <div class="header">
            <div class="pull-left">
                <h3 class="">Báo cáo sản phẩm tăng/giảm doanh số</h3>
            </div>
            <div class="clearfix">
            </div>
        </div>
        <div class="body">
            <div class="box no-border">
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs hide-xs" style="border-bottom: 0px;">
                        <li class="all-item">
                            <a href="javascript:void(0)" style="cursor: pointer">
                                Tìm kiếm sản phẩm
                            </a>
                        </li>
                        <li class="float-right">
                            <a class="command-link" href="javascript:void(0)" ng-click="switchMode('narrow')" ng-show="modeShowFilter == 'expand'"><i class="fa fa-angle-up"></i> Thu hẹp</a>
                            <a class="command-link" href="javascript:void(0)" ng-click="switchMode('expand')" ng-show="modeShowFilter == 'narrow'"><i class="fa fa-angle-down"></i> Mở rộng</a>
                        </li>
                    </ul>
                </div>
                <div class="box-body" style="margin-bottom: 10px;">
                    <div class="row">
                        <div class="col-md-1">
                            <label for="">Kỳ trước</label>
                        </div>
                        <div class="col-md-2">
                            <input my-date-picker type="text" ng-model="filter.last_period_date_from" class="form-control" placeholder="Cập nhật từ ngày"/>
                        </div>
                        <div class="col-md-2">
                            <input my-date-picker type="text" ng-model="filter.last_period_date_to" class="form-control" placeholder="Cập nhật đến ngày"/>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-1">
                            <label for="">Kỳ này</label>
                        </div>
                        <div class="col-md-2">
                            <input my-date-picker type="text" ng-model="filter.date_from" class="form-control" placeholder="Cập nhật từ ngày"/>
                        </div>
                        <div class="col-md-2">
                            <input my-date-picker type="text" ng-model="filter.date_to" class="form-control" placeholder="Cập nhật đến ngày"/>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-4">
                            <button type="button" class="btn btn-primary " ng-click="find()">
                                <i class="fa fa-search"></i>
                                Tìm kiếm
                            </button>
                            <button type="button" class="btn btn-default ml-3 " ng-click="clear()">
                                <i class="fa fa-refresh"></i>
                                Xóa form
                            </button>
                        </div>
                    </div>
   
                    <div class="row mt-5">
                        <div class="col-md-12">
                            <table class="table table-responsive">
                                <thead>
                                    <tr>
                                        <th style="width: 20px">STT</th>
                                        <th>Sản phẩm</th>
                                        <th>Sale kỳ trước</th>
                                        <th>Sale kỳ này</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="item in reportItems">
                                        <td>@{{ $index + 1 }}</td>
                                        <td>
                                            <a target="_blank" href="@{{ buildUrl(item.slug + '-p' + item.product_id) }}">@{{ item.name }}</a>
                                        </td>
                                        <td>@{{ item.last_period_sale }}</td>
                                        <td>@{{ item.sale }} 
                                            <span ng-if="item.percent">(@{{  item.percent }}%)</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
