<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */


Route::group(['prefix' => 'dashboard', 'middleware' => Config::get('app.system_auth_middleware') ], function () {
    Route::get('/index', ['as' => 'dashboard::home', 'uses' => 'HomeController@index']);
    Route::get('/report-by-order', ['as' => 'dashboard::report-by-order', 'uses' => 'ReportController@reportByOrder']);
    Route::get('/report-by-category-source', ['as' => 'dashboard::report-by-category-source', 'uses' => 'ReportController@reportByCategorySource']);
    Route::get('/get-report-order-with-device', 'ReportController@getOrderWithDevices');
    Route::get('/get-report-order-by-conversion', 'Report\ReportByConversionController@getOrderByConversion');
    Route::get('/get-report-error-daily', 'Report\ReportErrorController@reportErrorDaily');
    Route::get('/get-report-product-count-by-source', 'Report\ReportProductController@productCountBySource');
    Route::get('/get-statistic', 'Report\StatisticController@statisticAvg');

    Route::get('/report-product-sale-change', 'Report\ReportProductSaleChangeController@index');
    Route::post('/get-report-product-sale-change', 'Report\ReportProductSaleChangeController@report');
    Route::get('/get-report-product-sale-change', 'Report\ReportProductSaleChangeController@report');
    Route::get('/report-by-product', ['as' => 'dashboard::report-by-product', 'uses' => 'ReportController@reportByProduct']);
    Route::get('/report-by-source', ['as' => 'dashboard::report-by-source', 'uses' => 'ReportController@reportBySource']);
    Route::get('/report-by-category', ['as' => 'dashboard::report-by-category', 'uses' => 'ReportController@reportByCategory']);
    Route::get('/get-google-bot-request', 'Report\StatisticController@fetchCloudflareData');
    
    Route::get('/get-report-customer', 'ReportController@getCustomerReport');
    Route::get('/get-report-ticket', 'ReportController@getTicketReport');

});

Route::group(['prefix' => 'dashboard'], function () {
    Route::get('/report-by-order-localization', ['as' => 'dashboard::report-by-order-localization', 'uses' => 'ReportController@reportByOrder']); 
    Route::get('/report-by-cost-localization', ['as' => 'dashboard::report-by-cost-localization', 'uses' => 'ReportController@reportByCost']);
    Route::get('/report-by-cost-estimate-localization', ['as' => 'dashboard::report-by-cost-estimate-localization', 'uses' => 'ReportController@reportByCostEstimate']);
    
    Route::group(['prefix' => 'seller'], function () {
        Route::get('/report-by-product', ['as' => 'dashboard::report-by-product-for-seller', 'uses' => 'ReportController@reportByProductForSeller']);
        Route::get('/report-by-source', ['as' => 'dashboard::report-by-source-for-seller', 'uses' => 'ReportController@reportBySourceForSeller']);
        Route::get('/report-by-category', ['as' => 'dashboard::report-by-category-for-seller', 'uses' => 'ReportController@reportByCategoryForSeller']);
        Route::get('/report-by-order-localization', ['as' => 'dashboard::report-by-order-localization-for-seller', 'uses' => 'ReportController@reportByOrderForSeller']); 
        Route::get('/report-by-cost-localization', ['as' => 'dashboard::report-by-cost-localization-for-seller', 'uses' => 'ReportController@reportByCostForSeller']);
        Route::get('/report-by-cost-estimate-localization', ['as' => 'dashboard::report-by-cost-estimate-localization-for-seller', 'uses' => 'ReportController@reportByCostEstimateForSeller']);
    });
});
