(function () {
    let module = angular.module('design-generator', [])
    module.directive('designGenerator', function () {
        return {
            scope: {
                examplePrompts: "@",
                exampleDesigns: "@",
                aiCentralUrl: "@",
                transTexts: "@",
                limit: "@",
                isPushEvent: "@"
            },
            link: (scope, element, attributes) => {
            },
            controller: ['$scope', '$http', function($scope, $http) {
                $scope.examplePromptsConfig = JSON.parse($scope.examplePrompts)
                $scope.transTextsConfig = JSON.parse($scope.transTexts)
                $scope.designs = $scope.exampleDesigns.split(",")
                $scope.examplePromptIndex = 1;
                $scope.prompt = "";
                $scope.loading = false;
                $scope.errorMessage = "";
                $scope.isAuth = true;

                $scope.initialize = function () {
                    $scope.designs = $scope.designs.slice(0, $scope.limit);

                    setInterval(() => {
                        $scope.$apply(function () {
                            $scope.changeExamplePrompt();
                        })
                    }, 5000);

                    document.querySelector('#js-design-generator-prompt-input').addEventListener("keyup", function(event) {
                        if (event.keyCode == 13) {
                            $scope.genDesign();
                        }
                    });
                }

                $scope.changeExamplePrompt = function () {
                    if ($scope.examplePromptIndex < $scope.examplePromptsConfig.length - 1) {
                        $scope.examplePromptIndex++;
                    } else {
                        $scope.examplePromptIndex = 1;
                    }
                }

                $scope.genDesign = function () {
                    if ($scope.prompt.length < 3) {
                        return;
                    }
                    $scope.errorMessage = "";
                    $scope.loading = true;
                    $http.get($scope.aiCentralUrl + '/openai', {
                        params: {
                            n: $scope.limit,
                            prompt: $scope.prompt
                        }
                    }).then(function(response) {
                        if (response.data.status === 'successful') {
                            $scope.designs = response.data.reuslt.map(item => item.url);
                            localStorage.setItem("design-creator-recent-design", JSON.stringify($scope.recentDesigns));
                        } else {
                            $scope.errorMessage = $scope.transTextsConfig.violate_prompt
                        }
                        $scope.loading = false;
                    }).catch(function(err) {
                        console.log(err);
                        $scope.errorMessage = $scope.transTextsConfig.threshold;
                        $scope.loading = false;
                    });
                }

                $scope.printDesign = function(url) {
                    var locale = '';
                    if (localePrefix && localePrefix !== '') {
                        locale = '/' + localePrefix;
                    }
                    let designUrl = url;
                    if (url.indexOf("?") > 0) {
                        designUrl = $scope.aiCentralUrl + '/cors-proxy?url=' + btoa(encodeURIComponent(url));

                    }
                    if (parseInt($scope.isPushEvent)) {
                        window.dispatchEvent(new CustomEvent('add_design', {detail: designUrl}));
                        return;
                    }

                    window.open(locale + '/create-your-own?utm_source=design-generator&design_url=' + designUrl + '&template=' + designGeneratorCategoryName, '_blank').focus();
                }

                $scope.getImageCdn = function ($url, $width = 0, $height = 0, $fitIn = true) {
                    if (!$url) return "";
                    if (typeof DGCdnIgnoreUrl !== 'undefined') {
                        for (let item of DGCdnIgnoreUrl) {
                            if ($url.includes(item)) {
                                return $url;
                            }
                        }
                    }
                    if (typeof DGCdnAllowUrl !== 'undefined') {
                        let check = false;
                        for (let item of DGCdnAllowUrl) {
                            if ($url.includes(item)) {
                                check = true;
                                break;
                            }
                        }
                        if (!check) {
                            return $url;
                        }
                    }
                    let retval;
                    let originUrl = $url;
                    if (originUrl.substr(0, 4) == 'http') {
                        $url = $url.replace('https://', '');
                        $url = $url.replace('http://', '');
                    }
                    if ($url.includes('?')) {
                        $url = encodeURIComponent($url);
                    }
                    // return $url;
                    retval =  baseCdnUrl + "/" + $url;
            
                    if ($width == 0 && $height == 0) {
                        retval =  baseCdnUrl + "/" + $url;
                    } else if ($width == 0 || $height == 0) {
                        retval = baseCdnUrl + "/" + $width + "x" + $height + "/" + $url;
                    } else {
                        retval = baseCdnUrl + ($fitIn ? "/fit-in/" : '/') + $width + "x" + $height + '/' + $url;
                    }
                    return retval.replace('//pod', '/pod');
                }

                window.addEventListener('checkAuthDone', function (e) {
                    if (window.customerInfo) {
                        $scope.$apply(() => {
                            $scope.isAuth = true;
                        })
                    }
                })

                setTimeout(() => {
                    if (window.customerInfo) {
                        $scope.$apply(() => {
                            $scope.isAuth = true;
                        })
                    }
                }, 1000);

                setTimeout(() => {
                    if (window.customerInfo && !$scope.isAuth) {
                        $scope.$apply(() => {
                            $scope.isAuth = true;
                        })
                    }
                }, 5000);

                $scope.initialize();
            }],
            template: `
                <div class="design-generator-wrapper" ng-show="isAuth">
                    <div class="design-generator-item design-generator-header">
                        <div class="design-generator-heading">
                            {{ transTextsConfig.title }}
                        </div>
                        <div>
                            {{ transTextsConfig.description }}
                        </div>
                        <div>
                            <div>{{ transTextsConfig.example }}:</div>
                            <div class="generator-example-prompt-wrapper">
                                <span ng-repeat="examplePrompt in examplePromptsConfig track by $index" class="generator-strong generator-example-prompt {{ $index ==  examplePromptIndex ? 'out' : ($index == examplePromptIndex - 1 ? 'in' : '') }}">{{ examplePrompt }}</span>
                            </div>
                        </div>
                        <div class="design-generator-searchbox">
                            <div class="gradient-border">
                                <input 
                                    class="form-control design-generator-search-text" 
                                    autocomplete="off" 
                                    type="text" 
                                    ng-model="prompt"
                                    placeholder="{{ transTextsConfig.placeholder }}"
                                    id="js-design-generator-prompt-input"
                                />
                            </div>
                            <button class="button design-generator-search-button" type="submit" ng-click="genDesign()" ng-disabled="prompt.length < 3">
                                <span ng-if="!loading">{{ transTextsConfig.try }}</span>
                                <span ng-if="loading" class="loading-search"></span>
                            </button>
                        </div>
                        <p class="text-error">{{ errorMessage }}</p>    
                    </div>
                    <div class="design-generator-item" ng-repeat="img in designs">
                        <button ng-click="printDesign(img)" class="design-generator-item-conent">
                            <div class="design-generator-item-link">
                                <span>{{ transTextsConfig.customize_now }}</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"> <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z"></path> </svg>
                            </div>
                        </button>
                        <div class="design-generator-item-image {{ loading ? 'design-loading' : ''}}">
                            <img src="{{ getImageCdn(img, 540, 540) }}" alt="Copyright @Printerval.com" loading="lazy" width="188" height="160">
                        </div>
                    </div>
                </div>
            `
        }
    })
}).call(this)