@php
    $examplePrompts = [
        "3D render of a cute tropical fish in an aquarium on a dark blue background, digital art",
        "A cat submarine chimera, digital art",
        "An oil painting by Matisse of a humanoid robot playing chess",
        "An armchair in the shape of an avocado",
        "A hand drawn sketch of a Porsche 911",
        "A photo of a teddy bear on a skateboard in Times Square",
        "An abstract painting of artificial intelligence",
        "A van Gogh style painting of an American football player",
        "A comic book cover of a superhero wearing headphones",
        "A Shiba Inu dog wearing a beret and black turtleneck",
        "A centered explosion of colorful powder on a black background",
    ];
@endphp

@mobile
    @php
        $genLimit = 4;
        $exampleImages = [
            url("/modules/design-generator/images/mobile/3d-render-of-a-cute-tropical-fish.png"),
            url("/modules/design-generator/images/mobile/an-armchair-in-the-shape.png"),
            url("/modules/design-generator/images/mobile/a-centered-explosion-of-colorful.png"),
            url("/modules/design-generator/images/mobile/a-comic-book-cover.png"),
            url("/modules/design-generator/images/mobile/an-oil-painting-by-matisse.png"),
        ];
    @endphp
@elsemobile
    @php
        $genLimit = 5;
        $exampleImages = [
            url("/modules/design-generator/images/3d-render-of-a-cute-tropical-fish.png"),
            url("/modules/design-generator/images/an-armchair-in-the-shape.png"),
            url("/modules/design-generator/images/a-centered-explosion-of-colorful.png"),
            url("/modules/design-generator/images/a-comic-book-cover.png"),
            url("/modules/design-generator/images/an-oil-painting-by-matisse.png"),
        ];
    @endphp
@endmobile

<design-generator 
    example-prompts="{{ json_encode($examplePrompts) }}",
    example-designs="{{ implode(",", $exampleImages) }}"
    limit="{{ $genLimit }}"
    ai-central-url="{{ config('sa.ai_central_url') }}",
    trans-texts="{{ json_encode([
        "title" => __('AI-Powered Design Generator'),
        "description" => __('Create original, realistic images and art from a text description. It can combine concepts, attributes, and styles'),
        "example" => __('For example'),
        "try" => __('Try now'),
        "customize_now" => __('Customize Now'),
        "violate_prompt" => __("The system detected potentially unsafe content. Please try again or adjust the prompt."),
        "placeholder" => __("Start with a detailed description"),
        "threshold" => __("Sorry! You have reached the threshold of generation")
    ]) }}"
    is-push-event="{{ isset($isPushEvent) ? $isPushEvent : false }}"
></design-generator>