<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbDiscountTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('discount')) {
            Schema::create('discount', function (Blueprint $table) {
                $table->increments('id');
                $table->string('title', 255)->nullable();
                $table->string('slug', 255)->nullable();
                $table->string('code', 32)->nullable();
                $table->enum('status', ['active', 'inactive'])->nullable();
                $table->enum('type', ['percent', 'fixed_amount', 'customer_get'])->nullable();
                $table->decimal('value', 15, 2)->nullable();
                $table->enum('minimum_require_type', ['none', 'amount', 'quantity'])->nullable();
                $table->decimal('minimum_require_value', 15, 2)->nullable();
                $table->integer('usage_limit')->nullable();
                $table->tinyInteger('once_per_customer')->nullable()->default(0);
                $table->enum('apply_type', ['all', 'category', 'product'])->nullable();
                $table->tinyInteger('quantity_item_customer_get')->nullable();
                $table->tinyInteger('is_customer_get_item_free')->nullable()->default(0);
                $table->tinyInteger('percent_item_customer_get')->nullable();
                $table->dateTime('start_time')->nullable();
                $table->dateTime('end_time')->nullable();
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();

                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('discount');
    }
}
