<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbDiscountItemTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('discount_item')) {
            Schema::create('discount_item', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('discount_id')->nullable();
                $table->integer('reference_id')->nullable();
                $table->integer('get_id')->nullable();
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->unique(['discount_id', 'reference_id', 'get_id'], 'discount_id');
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('discount_item');
    }
}
