<?php

namespace Modules\Discount\Models;

use Illuminate\Database\Eloquent\Model;

class Discount extends Model
{
    protected $table = 'discount';
    protected $guarded = ['id'];
    protected $fillable = ['title', 'code', 'status', 'is_show_on_site', 'type', 'value', 'minimum_require_type', 'minimun_require_value', 
                            'apply_type', 'limited_number_uses', 'number_uses', 'max_discount_value', 'start_time', 'end_time', "is_limit_by_user"];
    protected $casts = ["limited_number_uses" => "integer", "number_uses" => "integer"];
    public function items() {
        return $this->hasMany(DiscountItem::class, 'discount_id');
    }                      
    
}
