system.controller("DiscountController", DiscountController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function DiscountController($rootScope, $scope, $http, $window) {
    
    $scope.filters = {};
    $scope.items = [];
    $scope.ajaxFindRequest = null;
    $scope.isChangeData = false;
    $scope.showForm = false;
    $scope.mode = 'create';
    $scope.isSaving = false;
    $scope.statuses = [
        {code: 'active', 'text': 'Hoạt Động'},
        {code: 'inactive', 'text': 'Dừng Hoạt Động'}
    ];

    $scope.showOnSites = [
        {code: 0, 'text': 'Ẩn text trên site'},
        {code: 1, 'text': 'Hiện text trên site'}
    ];

    $scope.discount_types = [
        {code: 'percent', text: 'Giảm phần trăm'}, 
        {code: 'fixed_amount', text: 'Giảm số tiền cố định'},
        {code: 'freeship', text: 'Freeship'}
    ];
    $scope.applies_type = [
        {code: 'all', text: 'Tất cả sản phẩm'},
        {code: 'category', text: 'Danh mục'},
        {code: 'product', text: 'Sản phẩm'}
    ];
    $scope.minimum_require_types = [
        {code: 'none', text: 'Không yêu cầu'},
        {code: 'amount', text: 'Số tiền thanh toán'},
        {code: 'quantity', text: 'Số lượng sản phẩm'}
    ];
    $scope.buy_get_minimum_require_types = [
        {code: 'quantity', text: 'Số lượng sản phẩm'},
        {code: 'amount', text: 'Số tiền thanh toán'}
    ];
    $scope.customer_get_values = [
        {code: 'percent', text: 'Phần trăm giảm'},
        {code: 'free', text: 'Miễn phí'}
    ];
    $scope.chooseProductTypes = [
        {code: "category", text: "Sản phẩm từ danh mục"},
        {code: "product", text: "Chọn chi tiết sản phẩm"}
    ];

    $scope.tabFilters = [
        {key: 'percent', filter: 1, label: 'Giảm giá phần trăm'},
        {key: 'fixed_amount', filter: 0, label: 'Giảm giá số tiền'},
        {key: 'freeship', filter: 0, label: 'Mã freeship'},
        {key: 'referral', filter: 0, label: 'Affiliate referral'},
    ];

    $scope.isShowOnSiteByUser = [
        {code: 0, 'text': 'Không theo người dùng'},
        {code: 1, 'text': 'Theo từng người dùng'}
    ];
    $scope.isShowOnPromoPage = [
        {code: 0, 'text': 'Không hiển thị'},
        {code: 1, 'text': 'Hiển thị'}
    ];

    $scope.itemSuggestions = [];
    $scope.showSuggestion = false;
    $scope.itemGetSuggestions = [];
    $scope.showGetSuggestion = false;
    $scope.currencyUnit = currencyUnit;

    this.initialize = function() {
        resetFilter();
    }

    resetFilter = function() {
        $scope.filters.page_id = 0;
        $scope.filters.keyword = '';
        // $scope.filters.sort = null;
        
        // initDatePicker();
        $scope.find(true);
    }

    $scope.clearRequire = function() {
        $scope.validateTitle = null;
        $scope.isSaving = false;
    }

    $scope.chooseType = function(type) {
        $scope.discount.type = type.code;
    }

    $scope.chooseApplyType = function(type) {
        $scope.discount.apply_type = type.code;
        $scope.itemSuggestions = [];
        $scope.showSuggestion = false;
    }

    $scope.chooseMinimumRequireType = function(type) {
        $scope.discount.minimum_require_type = type.code;
    }

    $scope.chooseBuyGetMinimumRequireType = function(type) {
        $scope.discount.buy_get_minimum_require_type = type.code;
    }

    $scope.chooseCustomerGetValue = function(type) {
        $scope.discount.customer_get_value = type.code;
    }

    $scope.save = function() {
        $scope.isSaving = true;
        if (typeof $scope.discount.title == 'undefined' 
            || (typeof $scope.discount.title != 'undefined' && $scope.discount.title == '')
            || (typeof $scope.discount.title != 'undefined' && $scope.discount.title == null)
            ) {
            // $scope.validateTitle = '(*) Bạn phải nhập tên cho chương trình';
            toastr.error('Bạn phải nhập tên cho chương trình');
            $scope.isSaving = false;
            return false;
        }
        
        if ((typeof $scope.discount.code == 'undefined' || $scope.discount.code == '' || typeof $scope.discount.code == null) && $scope.discount.apply_type == 'all' ) {
            toastr.error('Để áp dụng cho toàn bộ sản phẩm, vui lòng nhập mã giảm giá.');
            $scope.isSaving = false;
            return false;
        }
        var data = buildData();
        if (typeof user != 'undefined') {
            data.email = user.email;
        }
        if (data.id) {
            $http.put("discount/" + data.id, data).then(function (response) {
                if (response.data.status === "successful") {
                    $scope.isShowHideLoading(false);
                    $scope.find();
                    $scope.pagesCount = response.data.pagesCount;
                    $scope.showForm = false;
                    $window.scrollTo(0, 0);
                    toastr.success('Đã lưu thành công');
                } else {
                    toastr.error(response.data.message);
                }
                $scope.isSaving = false;
            });
        } else {
            $http.post("discount", data).then(function (response) {
                if (response.data.status === "successful") {
                    $scope.isShowHideLoading(false);
                    $scope.find();
                    $scope.pagesCount = response.data.pagesCount;
                    $scope.showForm = false;
                    $window.scrollTo(0, 0);
                    toastr.success('Đã lưu thành công');
                } else {
                    toastr.error(response.data.message);
                }
                $scope.isSaving = false;
            });
        }
        
    }

    function buildData() {
        var retVal = {
            title: $scope.discount.title,
            code: $scope.discount.code,
            status: $scope.discount.status,
            is_show_on_site: parseInt($scope.discount.is_show_on_site),
            is_limit_by_user: parseInt($scope.discount.is_limit_by_user),
            is_show_promo_code: parseInt($scope.discount.is_show_promo_code),
            type: $scope.discount.type,
            value: $scope.discount.value,
            minimum_require_type: $scope.discount.minimum_require_type,
            minimum_require_value: $scope.discount.minimum_require_value,
            apply_type: $scope.discount.apply_type,
            apply_items: [],
            max_discount_value: $scope.discount.max_discount_value,
            limited_number_uses: $scope.discount.limited_number_uses,
            end_time: $scope.discount.end_time
        }
        if (typeof $scope.discount.id != 'undefined') {
            retVal.id = $scope.discount.id;
        }
        if (retVal.apply_type == 'category') {
            retVal.apply_items = $scope.discount.apply_category_items;
        } else if (retVal.apply_type == 'product') {
            retVal.apply_items = $scope.discount.apply_product_items;
        }
        return retVal;
    }

    $scope.openForm = function(mode, item) {
        $scope.showForm = true;
        $scope.mode = mode;
        if(mode == 'update') {
            var copy = angular.copy(item);
            if (copy.minimum_require_type == 'quantity') {
                copy.minimum_require_value = $scope.convertToInt(copy.minimum_require_value);
            } else if (copy.minimum_require_type == 'amount') {
                copy.minimum_require_value = $scope.convertToFloat(copy.minimum_require_value);
            }
            
            $scope.discount = {
                id: copy.id,
                title: copy.title,
                code: copy.code,
                type: copy.type,
                status: copy.status,
                is_show_on_site: parseInt(copy.is_show_on_site),
                is_limit_by_user: parseInt(copy.is_limit_by_user),
                is_show_promo_code: parseInt(copy.is_show_promo_code),
                value: $scope.convertToFloat(copy.value),
                apply_type: copy.apply_type,
                minimum_require_type: copy.minimum_require_type,
                minimum_require_value: copy.minimum_require_value,
                apply_category_items: [],
                apply_product_items: [],
                limited_number_uses: copy.limited_number_uses,
                number_uses: copy.number_uses,
                max_discount_value: $scope.convertToFloat(copy.max_discount_value),
                end_time: moment(copy.end_time).format('DD/MM/YYYY')
            };
            if (copy.apply_type == 'category') {
                item.items.forEach(function(it){
                    var newItem = {
                        id: it.category_id,
                        name: it.name,
                        tree_name: it.tree_name
                    };
                    $scope.discount.apply_category_items.push(newItem);
                });
            }
            if (copy.apply_type == 'product') {
                item.items.forEach(function(it){
                    var newItem = {
                        id: it.product_id,
                        name: it.name,
                        image_url: it.image_url
                    };
                    $scope.discount.apply_product_items.push(newItem);
                });
            }
        } else {
            $scope.discount = {
                status: 'active',
                is_show_on_site: 0,
                is_limit_by_user: 0,
                is_show_promo_code: 0,
                type: 'percent',
                apply_type: 'product',
                minimum_require_type: 'none',
                buy_get_minimum_require_type: 'quantity',
                buy_product_type: 'product',
                get_product_type: 'product',
                customer_get_value: 'percent',
                apply_product_items: [],
                apply_category_items: [],
                customer_get_product_items: [],
                customer_get_category_items: []
            };
        }
    }

    $scope.cancel = function() {
        $scope.showForm = false;
        $window.scrollTo(0, 0);
    }


    $scope.reset = function() {
        resetFilter();
    }

    $scope.exportExcel = function() {
        var url = "/payment-stats/export-excel";
        var filter = buildFilter();
        var params = getParams(filter);
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        url += '&is_export=1';
        window.open(url, '_blank');
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.find = function (isChangePageData, sort = null) {
        if ($scope.ajaxFindRequest === null) {
            if (isChangePageData) {
                $scope.filters.page_id = 0;
            }
            var filter = buildFilter();
            var params = getParams(filter);
            var url = 'discount/find';
            if (params.length > 0) {
                url += '?' + params.join('&');
            }
            // $scope.isShowHideLoading(true);
            $http.get(url).then(function (response) {
                $scope.ajaxFindRequest = null;
                if (response.data.status === "successful") {
                    $scope.items = response.data.result;
                    // $scope.isShowHideLoading(false);
                    $scope.pagesCount = response.data.pagesCount;
                }
            });
        }
    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.keyword != '') {
            retVal.keyword = $scope.filters.keyword;
        }
        $scope.tabFilters.forEach(function (item) {
            if (item.filter == 1 && (item.key == 'percent' || item.key == 'fixed_amount' || item.key == 'freeship')) {
                retVal.type = item.key;
                retVal.ignore = 'Discount Referral';
            }
            if (item.filter == 1 && item.key == 'referral') {
                retVal.keyword1 = 'Discount Referral';
            }
        });
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }

    var findFlag;
    $scope.suggestion = function(type) {
        var keyword = $scope.discount.keyword;
        if ($scope.discount.type == 'buy_get') {
            if (type == 'get') {
                keyword = $scope.discount.keywordGet;
            } else if (type == 'buy') {
                keyword = $scope.discount.keywordBuy;
            }
            
        }
        $scope.itemSuggestions = [];
        $scope.showSuggestion = false;
        clearTimeout(findFlag);
        findFlag = setTimeout(function(){
            findSuggestion(type);
        },300);
    }

    function findSuggestion(type) {
        var keyword = $scope.discount.keyword;
        if ($scope.discount.type == 'buy_get') {
            if (type == 'buy') {
                keyword = $scope.discount.keywordBuy;
            } else if (type == 'get') {
                keyword = $scope.discount.keywordGet;
            }
            
        }
        var url = "/discount/product?keyword=" + keyword;
        if ((($scope.discount.type == 'percent' || $scope.discount.type == 'fixed_amount') && $scope.discount.apply_type == 'category') 
            || ($scope.discount.type == 'buy_get' && $scope.discount.get_product_type == 'category')
            ) {
            url = "/discount/category?keyword=" + keyword;
        }
        $http.get(url).then(function (response) {
            if (response.data.status === "successful" && response.data.result.length > 0) {
                if ($scope.discount.type == 'buy_get' && (type == 'get' || type == 'buy')) {
                    $scope.showGetSuggestion = true;
                    $scope.itemGetSuggestions = response.data.result;
                } else {
                    $scope.showSuggestion = true;
                    $scope.itemSuggestions = response.data.result;
                }
            }
        });
    }

    $scope.applyItem = function(type) {
        if (type == 'apply_product' || type == 'apply_category') {
            var productIds = [];
            $scope.discount.apply_product_items.forEach(function(item) {
                productIds.push(item.id);
            });
            var categoryIds = [];
            $scope.discount.apply_category_items.forEach(function(item) {
                categoryIds.push(item.id);
            });
            $scope.itemSuggestions.forEach(function(item) {
                if (item.is_checked) {
                    if (type == 'apply_product' && productIds.indexOf(item.id) < 0) {
                        $scope.discount.apply_product_items.push(item);
                    } 
                    if (type == 'apply_category' && categoryIds.indexOf(item.id) < 0) {
                        $scope.discount.apply_category_items.push(item);
                    }
                    
                }
            });
            $scope.showSuggestion = false;
        }


        if (type == 'customer_get_product' || type == 'customer_get_category') {
            $scope.itemGetSuggestions.forEach(function(item) {
                if (item.is_checked) {
                    if (type == 'customer_get_product') {
                        $scope.discount.customer_get_product_items.push(item);
                    } else if (type == 'customer_get_category') {
                        $scope.discount.customer_get_category_items.push(item);
                    }
                    
                }
            });
            $scope.showGetSuggestion = false;
        }
    }

    $scope.cancelSuggestion = function() {
        $scope.showSuggestion = false;
        $scope.showGetSuggestion = false;
    }

    $scope.deleteApplyItem = function(index, type) {
        if (type == 'apply_product') {
            $scope.discount.apply_product_items.splice(index,1);
        } else if (type == 'apply_category') {
            $scope.discount.apply_category_items.splice(index,1);
        } else if (type == 'customer_get_product') {
            $scope.discount.customer_get_product_items.splice(index,1);
        } else if (type == 'customer_get_category') {
            $scope.discount.customer_get_category_items.splice(index,1);
        }
        
    }

    $scope.convertToFloat = function(value) {
        if (value != null && value != '') {
            return parseFloat(value);
        }
        return value;
    }

    $scope.convertToInt = function(value) {
        if (value != null && value != '') {
            return parseInt(value);
        }
        return value;
    }

    $scope.convertUpperCase = function(value) {
        if (value != null && value != '') {
            return value.toUpperCase();
        }
        return value;
    }

    $scope.changeTab = function(tab) {
        $scope.tabFilters.forEach(function(item) {
            item.filter = 0;
            if (tab.key == item.key) {
                item.filter = 1;
            }
        });
        $scope.find(true);
    }

    this.initialize();
}