$(document).ready(function() {
    var showDiscountInPage = "<?= config('discount::sa.show_discount_product_detail', true) ?>";
    var productStatus = $("#product-status").val();
    $(document).on("click", ".js-product-buy-now", function (event) {
        buyNowProduct(event);
        return false;
    });
    $(document).on("click", ".js-copy-and-product-buy-now", function (event) {
        var code = $(this).parent().parent().data("code");
        copyToClipboard(code);
        buyNowProduct(event);
        return false;
    });
    function buyNowProduct(selector) {
        if (selector.currentTarget) selector = $(selector.currentTarget);
        if (window.dataLayer) {
            window.dataLayer.push({'event': 'add_to_cart'});
        }
        $(this).attr("disabled", "disabled");
        $(this).toggleClass("is-loading");
        let quantity = selector.find(".quantity-buy-now").val();
        let productId = $("#productId").val();
        let skuId = $("#productSkuId").val();
        var addCartReqParams = {
            url: '/cart/add-to-cart',
            method: 'POST',
            data: {
                productId: productId,
                productSkuId: skuId,
                quantity: quantity,
                _token: $('meta[name="csrf-token"]').attr('content'),
            }
        };
        $.ajax(addCartReqParams).done(function(result) {
            var locale = '';
            if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
                locale = '/' + localePrefix;
            }
            if (result.status == "successful") {
                window.location.href = `${locale}/cart`
            } else {
                alert("Fail. Try again later");
            }
        });
    };
    function getDiscountInfo() {
        let productId = $("#productId").val();
        $.ajax({
            url: '/discount/info?product_id=' + productId
        }).done(function(response) {
            if (response.status == 'successful') {
                const type = response.type;
                const items = response.result;
                let html = "";

                for (const [key, value] of Object.entries(items)) {
                    html += `<div class="discount-box">
                        <div class="discount-text">
                            ${value.message}
                        </div>`;
                    if (value.code && value.code != "") {
                        html +=`
                            <span class="discount-icon" data-code="${value.code}">
                            `
                        if (type == 'quantity') {
                            html += `<div class="flex-b flex-e align-c"><button class="button product-buy-now js-copy-and-product-buy-now">${discountModuleMessageCopyAndBuyNow}
                            <input class="hidden quantity-buy-now" hidden value="${value.value}"></input>
                            </button></div>`;
                        } else {
                            html += `
                                <svg width="24" height="24" viewBox="0 0 24 24" role="presentation">
                                    <g fill="currentColor">
                                        <path d="M10 19h8V8h-8v11zM8 7.992C8 6.892 8.902 6 10.009 6h7.982C19.101 6 20 6.893 20 7.992v11.016c0 1.1-.902 1.992-2.009 1.992H10.01A2.001 2.001 0 018 19.008V7.992z"></path>
                                        <path d="M5 16V4.992C5 3.892 5.902 3 7.009 3H15v13H5zm2 0h8V5H7v11z"></path>
                                    </g>
                                </svg>
                                <span class="copy-text">
                                    <small class="copy-action">
                                        ${discountModuleMessageCopy}
                                    </small>
                                    <small class="copy-done">
                                        ${discountModuleMessageCopied}
                                    </small>
                                </span>`;
                        }
                        html += `
                            </span>
                        `;
                    } else {
                        if (type == 'quantity') {
                            html += `<div class="flex-b flex-e align-c"><button class="button product-buy-now js-product-buy-now">${discountModuleMessageBuyNow}
                            <input class="hidden quantity-buy-now" hidden value="${value.value}"></input>
                            </button></div>`;
                        }
                    }
                    html += `</div>`;
                }
                $(".buy-more-discount").html(html);
            }
        })
    }

    function copyToClipboard(code) {
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val(code).select();
        document.execCommand("copy");
        $temp.remove();
    }

    $(document).on('click', '.discount-icon', function () {
        var code = $(this).data("code");
        copyToClipboard(code);
        $(this).children().find('.copy-action').hide();
        $(this).children().find('.copy-done').show();
    })

    $(document).on('mouseleave', '.discount-icon', function () {
        setTimeout(function(){
            $('.copy-action').show();
            $('.copy-done').hide();
        }, 800);
    });
    if (showDiscountInPage && productStatus == "ACTIVE") {
        getDiscountInfo();
    }
});