system.controller("FlashSaleController", FlashSaleController);

function FlashSaleController($rootScope, $scope, $http, $window, Upload) {
    $scope.baseController = this.__proto__ = new BaseController($scope, Upload);

    $scope.filters = {
        page_size: 50
    };
    $scope.flash_sale = {
        id: '',
        name: '',
        title: '',
        status: 'ACTIVE',
        sale_percent: 0,
        start_at: '',
        end_at: ''
    };
    $scope.items = [];
    $scope.showForm = false;
    $scope.currentLocale = currentLocale;
    $scope.ajaxFindRequest = null;
    $scope.mode = 'create';
    $scope.tabs = [
        {
            name: "Danh sách",
            type: 'list',
            active: true
        },
        {
            name: "Import",
            type: 'import',
            active: false
        },
    ];

    $scope.openForm = function (mode, item) {
        $(".designer-off-time").datetimepicker({
            format: "d/m/Y H:i",
        });
        $scope.showForm = true;
        $scope.mode = mode;
        if (mode == 'update') {
            $scope.flash_sale = {
                id: item.id,
                name: item.name,
                title: item.title,
                status: item.status,
                sale_percent: item.sale_percent,
                start_at: $scope.formatDate(item.start_at),
                end_at: $scope.formatDate(item.end_at)
            };
        } else {
            $scope.flash_sale = {
                id: '',
                name: '',
                title: '',
                status: 'ACTIVE',
                sale_percent: 0,
                start_at: '',
                end_at: ''
            };
        }
    }

    $scope.cancel = function () {
        $scope.showForm = false;
        $window.scrollTo(0, 0);
    }

    this.initialize = function () {
        resetFilter();
    }

    function resetFilter() {
        $scope.filters.page_id = 0;
        $scope.filters.keyword = '';
        $scope.find(true);
    }

    $scope.reset = function () {
        resetFilter();
    }

    $scope.handleUploadData = function (excelFile) {
        if (excelFile) {
            Upload.upload({
                url: '/discount/classify-data',
                data: {csv_file: excelFile}
            }).then(function (response) {
                if (response.data.status == "successful") {
                    $scope.find(true);
                    toastr.success('Import thành công ' + response.data.affectedRow + ' chương trình.');
                } else {
                    toastr.error('Có lỗi xảy ra. ' + response.data.message);
                }
            }, function (err) {
                toastr.error('Có lỗi xảy ra trong quá trình Import Shipment. Xin vui lòng thử lại.');
            });
        }
    }

    $scope.find = function (isChangePageData, sort = null) {
        if ($scope.ajaxFindRequest === null) {
            if (isChangePageData) {
                $scope.filters.page_id = 0;
            }
            var filter = buildFilter();
            var params = getParams(filter);
            var url = base_api_url + '/flash_sale?page_id=' + $scope.filters.page_id
                + '&page_size=' + $scope.filters.page_size + '&sorts=-id'
                + '&filters=' + params.join(',');

            $http.get(url).then(function (response) {
                $scope.ajaxFindRequest = null;
                if (response.data.status === "successful") {
                    $scope.items = response.data.result;
                    $scope.pagesCount = response.data.meta.page_count;
                }
            });
        }
    }

    $scope.save = function () {
        $scope.isSaving = true;
        if (typeof $scope.flash_sale.name == 'undefined'
            || (typeof $scope.flash_sale.name != 'undefined' && $scope.flash_sale.name == '')
            || (typeof $scope.flash_sale.name != 'undefined' && $scope.flash_sale.name == null)
        ) {
            toastr.error('Bạn phải nhập tên cho chương trình');
            $scope.isSaving = false;
            return false;
        }

        if (typeof $scope.flash_sale.title == 'undefined'
            || (typeof $scope.flash_sale.title != 'undefined' && $scope.flash_sale.title == '')
            || (typeof $scope.flash_sale.title != 'undefined' && $scope.flash_sale.title == null)
        ) {
            toastr.error('Bạn phải nhập tiêu đề cho chương trình');
            $scope.isSaving = false;
            return false;
        }

        if ((typeof $scope.flash_sale.sale_percent == 'undefined' || $scope.flash_sale.sale_percent == '')) {
            toastr.error('Bạn phải nhập % giảm giá của chương trình.');
            $scope.isSaving = false;
            return false;
        }

        // Validate start_at and end_at
        if (
            typeof $scope.flash_sale.start_at === 'undefined' || $scope.flash_sale.start_at === '' ||
            typeof $scope.flash_sale.end_at === 'undefined' || $scope.flash_sale.end_at === ''
        ) {
            toastr.error('Bạn phải nhập cả ngày bắt đầu và kết thúc cho chương trình.');
            $scope.isSaving = false;
            return false;
        }

        // Check if start_at is less than end_at
        if (new Date($scope.flash_sale.start_at) >= new Date($scope.flash_sale.end_at)) {
            toastr.error('Ngày bắt đầu phải trước ngày kết thúc.');
            $scope.isSaving = false;
            return false;
        }

        $scope.flash_sale.start_at = $scope.formatDateServer($scope.flash_sale.start_at);
        $scope.flash_sale.end_at = $scope.formatDateServer($scope.flash_sale.end_at);

        if ($scope.flash_sale.id) {
            $http.put(base_api_url + '/flash_sale/' + $scope.flash_sale.id, $scope.flash_sale).then(function (response) {
                handleResponse(response);
            });
        } else {
            $http.post(base_api_url + '/flash_sale', $scope.flash_sale).then(function (response) {
                handleResponse(response);
            });
        }
    }

    $scope.changeStatus = function (item, status) {
        $scope.flash_sale = {
            id: item.id,
            name: item.name,
            status: status,
            sale_percent: item.sale_percent,
            start_at: new Date(item.start_at),
            end_at: new Date(item.end_at)
        };

        var param = {
            title: 'Update Status Item',
            customText: 'Confirm to update status this item!',
            confirmButtonText: 'Ok',
            cancelButtonText: 'No'
        };
        $scope.callConfirmModal(param, function () {
            $scope.save()
        });

    }

    $scope.deleteItem = function (item) {
        var param = {
            title: 'Delete Item',
            customText: 'Confirm to delete this item!',
            confirmButtonText: 'Ok',
            cancelButtonText: 'No',
            arg: {id: item.id}
        };

        $scope.callConfirmModal(param, function (arg) {
            $http({
                method: 'delete',
                url: base_api_url + '/flash_sale/' + arg.id,
            }).then(function success(response) {
                if (response.data.status == 'successful') {
                    toastr.success('Deleted!');
                    $scope.find(true);
                } else {
                    toastr.error('Error delete flash sale strategy!');
                }
            });
        });
    }

    function handleResponse(response) {
        if (response.data.status === "successful") {
            $scope.isShowHideLoading(false);
            $scope.find();
            $scope.pagesCount = response.data.pagesCount;
            $scope.showForm = false;
            $window.scrollTo(0, 0);
            toastr.success('Đã lưu thành công');
        } else {
            toastr.error(response.data.message);
        }
        $scope.isSaving = false;
    }

    $scope.isShowHideLoading = function (val) {
        $scope.isShowLoading = val;
    }

    function getParams(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                switch (key) {
                    case 'name': 
                        param = key + '~' + filterValue; 
                        break;
                    case 'start_at': 
                        param = key + ">=" + convertToYMD(filterValue) + ' 00:00:00';
                        break;
                    case 'end_at':
                        param = key + '<=' + convertToYMD(filterValue) + ' 23:59:59';  
                        break;
                    default:    
                        param = key + '=' + filterValue;
                        break;
                }
            }
            if (param) {
                params.push(param);
            }
        }
        return params;
    }

    $scope.formatDateServer = function (inputDate) {
        var parts = inputDate.split(/[/ :]/);
        // Month is 0-based, so subtract 1
        var jsDate = new Date(parts[2], parts[1] - 1, parts[0], parts[3], parts[4]);

        var formattedDateString =
            jsDate.getFullYear() + "-" +
            ("0" + (jsDate.getMonth() + 1)).slice(-2) + "-" +
            ("0" + jsDate.getDate()).slice(-2) + " " +
            ("0" + jsDate.getHours()).slice(-2) + ":" +
            ("0" + jsDate.getMinutes()).slice(-2) + ":00";

        return formattedDateString;
    }

    $scope.formatDate = function (date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        minutes = minutes < 10 ? '0' + minutes : minutes;
        var strTime = hours + ':' + minutes;
        var day = (date.getDate() > 9) ? date.getDate() : '0' + date.getDate();
        var month = ((date.getMonth() + 1) > 9) ? date.getMonth() + 1 : '0' + (date.getMonth() + 1);
        var year = date.getFullYear();
        if (formatString == 'dd/mm/yyyy') {
            return `${day}/${month}/${year}`;
        }
        return `${day}/${month}/${year} ${strTime}`;
    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.keyword != '') {
            retVal.name = $scope.filters.keyword;
        }
        if ($scope.filters.status) {
            retVal.status = $scope.filters.status;
        }
        if ($scope.filters.start_at) {
            retVal.start_at = $scope.filters.start_at;
        }
        if ($scope.filters.end_at) {
            retVal.end_at = $scope.filters.end_at;
        }
        return retVal;
    }

    function convertToYMD(inputDate) {
        // Split the inputDate into day, month, and year
        var parts = inputDate.split('/');

        // Create a new Date object using the parts
        var dateObject = new Date(parts[2], parts[1] - 1, parts[0]);

        // Get the year, month, and day components
        var year = dateObject.getFullYear();
        var month = (dateObject.getMonth() + 1).toString().padStart(2, '0'); // Adding 1 because months are zero-based
        var day = dateObject.getDate().toString().padStart(2, '0');

        // Combine the components in the "YYYY-MM-DD" format
        return year + '-' + month + '-' + day;
    }

    this.initialize();
}