<div id="product-form" ng-show="showForm">
    <div class="content">
        <div class="row product-form-header">
            <div class="col-lg-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin:0" ng-show="mode == 'create'">Thêm giảm giá</h3>
                    <h3 style="margin:0" ng-show="mode == 'update'">Sửa giảm giá</h3>
                </div>
                <div class="pull-right">
                    <button type="button" class="btn btn-primary" ng-disabled="isSaving" ng-click="save()" id="btn-save-2"><i class="fa fa-save"></i> Lưu</button>
                    <button type="button" class="btn btn-default" ng-disabled="isSaving" ng-click="cancel()" id="btn-cancel"><i class="fa fa-times"></i> Hủy</button>
                </div>
            </div>
        </div>
        <div class="row row-discount-form">
            <div class="col-md-7">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title">Thông tin cài đặt giảm giá</h3>
                    </div>
                    <div class="box-body">
                        <div class="form-group">
                            <label for="title">Tên (*)</label>
                            <input ng-keyUp="clearRequire()" type="text" class="form-control" ng-model="discount.title" id="title" placeholder="Nhập tên">
                                <!-- <p class="help-block" style="color: red;">@{{validateTitle}}</p> -->
                        </div>
                        <div class="form-group">
                            <label for="code">Mã giảm giá</label>
                            <!-- <span class="pull-right">
                                <a href="#">Sinh mã tự động</a>
                            </span> -->
                            <input type="text" class="form-control" ng-model="discount.code" id="code" placeholder="Nhập mã giảm giá">
                            <p class="help-block">Khách hàng sẽ nhập mã giảm giá khi thanh toán</p>
                        </div>
                        <div class="form-group">
                            <label for="title">Trạng thái</label>
                            <select ng-options="item.code as item.text for item in statuses"
                                    class="form-control input-qty"
                                    ng-model="discount.status"
                                >
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="title">Hiển thị text giảm giá trên site</label>
                            <select ng-options="item.code as item.text for item in showOnSites"
                                    class="form-control input-qty"
                                    ng-model="discount.is_show_on_site"
                                >
                            </select>
                        </div>
                    </div>
                </div>
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Loại giảm giá</h3>
                    </div>
                    <div class="box-body">
                        <div class="form-group">
                            <div class="radio" ng-repeat="type in discount_types">
                                <label>
                                    <input type="radio" name="discount_type" ng-model="discount.type" ng-value="type.code" ng-click="chooseType(type)">
                                        @{{type.text}}
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div ng-if="discount.type == 'percent' || discount.type == 'fixed_amount' || discount.type == 'freeship'">
                    <div class="box box-primary" ng-if="discount.type != 'freeship'">
                        <div class="box-header with-border">
                            <h3 class="box-title">Giá trị giảm</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group" ng-if="discount.type == 'percent'">
                                <div class="input-group input-qty">
                                    <input type="number" ng-model="discount.value" class="form-control" placeholder="0">
                                    <span class="input-group-addon">%</span>
                                </div>
                            </div>
                            <div class="form-group" ng-if="discount.type == 'percent'">
                                <label for="title">Tối đa</label>
                                <div class="input-group input-qty">
                                    <span class="input-group-addon">@{{currencyUnit}}</span>
                                    <input type="number" ng-model="discount.max_discount_value" class="form-control" placeholder="0">
                                </div>
                                <p class="help-block">Không cấu hình giảm tối đa thì vui lòng để trống trường này</p>
                            </div>
                            <div class="form-group" ng-if="discount.type == 'fixed_amount'">
                                <div class="input-group input-qty">
                                    <span class="input-group-addon">@{{currencyUnit}}</span>
                                    <input type="number" ng-model="discount.value" class="form-control" placeholder="0">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Áp dụng cho</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group">
                                <div class="radio" ng-repeat="type in applies_type">
                                    <label>
                                        <input type="radio" name="apply_type" ng-model="discount.apply_type" ng-value="type.code" ng-click="chooseApplyType(type)">
                                            @{{type.text}}
                                    </label>
                                </div>
                            </div>
                            <div class="form-group" ng-show="discount.apply_type == 'product'">
                                <span class="select2-container select2-container--default select2-container--open" style="width: 100%;">
                                    <span class="select2-dropdown" dir="ltr" style="width: 100%; position: initial; top: auto; border-radius: 2px;">
                                        <span class="select2-search select2-search--dropdown">
                                            <input class="select2-search__field" 
                                                    style="padding: 4px;" 
                                                    type="search" 
                                                    autocomplete="off" 
                                                    autocorrect="off" 
                                                    autocapitalize="none" 
                                                    spellcheck="false" 
                                                    role="textbox" 
                                                    placeholder="Tìm sản phẩm cần áp dụng"
                                                    ng-model="discount.keyword"
                                                    ng-keyup="suggestion('buy')"
                                                    \>
                                        </span>
                                    </span>
                                    <span class="select2-results" ng-show="showSuggestion" style="position: absolute; top: 100%; width: 100%; background: #fff; box-shadow: 0 0 3px rgba(11, 11, 11, 0.5); border-radius: 0 0 4px 4px; z-index: 9999;">
                                        <div class="box-body table-responsive no-padding" style="max-height: 400px;">
                                            <table class="table table-hover">
                                                    <tbody>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Ảnh</th>
                                                            <th>Tên sản phẩm</th>
                                                        </tr>
                                                        <tr ng-repeat="item in itemSuggestions">
                                                            <td style="width: 10px;"><input type="checkbox" ng-model="item.is_checked" ng-true-value="1" ng-false-value="0"/></td>
                                                            <td>
                                                                <img src="@{{item.image_url}}" style="height: 30px;"/>
                                                            </td>
                                                            <td>@{{item.name}}</td>
                                                        </tr>
                                                    </tbody>
                                            </table>
                                                <div class="pull-right" style="margin: 6px;">
                                                    <button type="button" class="btn btn-primary" ng-click="applyItem('apply_product')" id="btn-save-2"><i class="fa fa-save"></i> Áp dụng</button>
                                                    <button type="button" class="btn btn-default" ng-click="cancelSuggestion()" id="btn-cancel"><i class="fa fa-times"></i> Hủy</button>
                                                </div>
                                            </div>
                                        </span>
                                </span>

                                <div class="box-body table-responsive no-padding" ng-show="discount.apply_product_items.length > 0">
                                    <table class="table table-hover">
                                        <tbody>
                                            <tr>
                                                <th>#</th>
                                                <th>Ảnh</th>
                                                <th>Tên sản phẩm</th>
                                                <th></th> 
                                            </tr>
                                            <tr ng-repeat="item in discount.apply_product_items">
                                                <td>@{{$index + 1 }}</td>
                                                <td>
                                                    <img src="@{{item.image_url}}" style="height: 30px;"/>
                                                </td>
                                                <td>@{{item.name}}</td>
                                                <td>
                                                    <button type="button" class="btn btn-danger btn-sm" title="Xóa sản phẩm" ng-click="deleteApplyItem($index, 'apply_product');">
                                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="form-group" ng-show="discount.apply_type == 'category'">
                                <span class="select2-container select2-container--default select2-container--open" style="width: 100%;">
                                    <span class="select2-dropdown" dir="ltr" style="width: 100%; position: initial; top: auto; border-radius: 2px;">
                                        <span class="select2-search select2-search--dropdown">
                                            <input class="select2-search__field" 
                                                    style="padding: 4px;" 
                                                    type="search" 
                                                    tabindex="0" 
                                                    autocomplete="off" 
                                                    autocorrect="off" 
                                                    autocapitalize="none" 
                                                    spellcheck="false" 
                                                    role="textbox" 
                                                    placeholder="Tìm danh mục cần áp dụng"
                                                    ng-model="discount.keyword"
                                                    ng-keyup="suggestion('buy')"
                                                    />
                                        </span>
                                    </span>
                                    <span class="select2-results" ng-show="showSuggestion" style="position: absolute; top: 100%; width: 100%; background: #fff; box-shadow: 0 0 3px rgba(11, 11, 11, 0.5); border-radius: 0 0 4px 4px; z-index: 9999;">
                                            <div class="box-body table-responsive no-padding">
                                                <table class="table table-hover">
                                                    <tbody>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Tên danh mục </th>
                                                        </tr>
                                                        <tr ng-repeat="item in itemSuggestions">
                                                            <td style="width: 10px;">
                                                                <input type="checkbox" ng-model="item.is_checked" ng-true-value="1" ng-false-value="0"/>
                                                            </td>
                                                            <td>@{{item.tree_name}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <div class="pull-right" style="margin: 6px;">
                                                    <button type="button" class="btn btn-primary" ng-click="applyItem('apply_category')" id="btn-save-2"><i class="fa fa-save"></i> Lưu</button>
                                                    <button type="button" class="btn btn-default" ng-click="cancelSuggestion()" id="btn-cancel"><i class="fa fa-times"></i> Hủy</button>
                                                </div>
                                            </div>
                                        </span>
                                </span>

                                <div class="box-body table-responsive no-padding" ng-show="discount.apply_category_items.length > 0">
                                    <table class="table table-hover">
                                        <tbody>
                                            <tr>
                                                <th>#</th>
                                                <th>Tên danh mục</th>
                                                <th></th> 
                                            </tr>
                                            <tr ng-repeat="item in discount.apply_category_items">
                                                <td>@{{$index + 1 }}</td>
                                                <td>@{{item.tree_name}}</td>
                                                <td>
                                                    <button type="button" class="btn btn-danger btn-sm" title="Xóa danh mục" ng-click="deleteApplyItem($index, 'apply_category');">
                                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Yêu cầu tối thiểu khách mua để được áp dụng</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group">
                                <div class="radio" ng-repeat="type in minimum_require_types">
                                    <label>
                                        <input type="radio" name="minimum_require_type" ng-model="discount.minimum_require_type" ng-value="type.code" ng-click="chooseMinimumRequireType(type)">
                                            @{{type.text}}
                                    </label>
                                </div>
                                <div ng-if="discount.minimum_require_type == 'amount'">
                                    <div class="input-group input-qty">
                                        <span class="input-group-addon">@{{currencyUnit}}</span>
                                        <input type="number" ng-model="discount.minimum_require_value" class="form-control input-qty" placeholder="Nhập số tiền">
                                    </div>
                                </div>
                                <div ng-if="discount.minimum_require_type == 'quantity'">
                                    <input type="number" ng-model="discount.minimum_require_value" class="form-control input-qty" placeholder="Nhập số lượng">
                                </div>
                                <p class="help-block" ng-if="discount.minimum_require_type == 'quantity' || discount.minimum_require_type == 'amount'">Áp dụng cho tất cả sản phẩm</p>
                            </div>
                        </div>
                    </div>

                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Giới hạn số lần sử dụng</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group">
                                <input type="text" ng-model="discount.limited_number_uses" class="form-control input-qty" placeholder="Nhập số lần sử dụng">
                                <p class="help-block">Chỉ áp dụng cho các chương trình có mã giảm giá, không giới hạn thì vui lòng để trống trường này</p>
                            </div>
                            <div class="form-group">
                                <label for="title">Giới hạn sử dụng theo</label>
                                <select ng-options="item.code as item.text for item in isShowOnSiteByUser"
                                        class="form-control input-qty"
                                        ng-model="discount.is_limit_by_user"
                                    >
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="title">Hiển thị trên trang promo code</label>
                                <select ng-options="item.code as item.text for item in isShowOnPromoPage"
                                        class="form-control input-qty"
                                        ng-model="discount.is_show_promo_code"
                                    >
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Ngày hết hạn</label>
                                <input type="text" my-date-picker ng-model="discount.end_time" class="form-control input-qty" placeholder="Nhập ngày hết hạn">
                            </div>
                        </div>
                    </div>
                </div>


                <div ng-if="discount.type == 'buy_get'">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Khách hàng mua</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group">
                                <div class="radio" ng-repeat="type in buy_get_minimum_require_types">
                                    <label>
                                        <input type="radio" name="buy_get_minimum_require_type" ng-model="discount.buy_get_minimum_require_type" ng-value="type.code" ng-click="chooseBuyGetMinimumRequireType(type)">
                                            @{{type.text}}
                                    </label>
                                </div>
                                <div ng-if="discount.buy_get_minimum_require_type == 'quantity'">
                                    <input type="number" ng-model="discount.minimum" class="form-control input-qty" id="code" placeholder="Nhập số lượng">
                                </div>
                                <div ng-if="discount.buy_get_minimum_require_type == 'amount'">
                                    <input type="number" ng-model="discount.minimum" class="form-control input-qty" id="code" placeholder="Nhập số tiền">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Sản phẩm áp dụng</label>
                                <select ng-options="item.code as item.text for item in chooseProductTypes"
                                    class="form-control input-qty"
                                    ng-model="discount.buy_product_type"
                                >
                                </select>
                            </div>
                            <div class="form-group" ng-show="discount.buy_product_type == 'product'">
                                <span class="select2-container select2-container--default select2-container--open" style="width: 100%;">
                                    <span class="select2-dropdown" dir="ltr" style="width: 100%; position: initial; top: auto; border-radius: 2px;">
                                        <span class="select2-search select2-search--dropdown">
                                            <input class="select2-search__field" 
                                                    style="padding: 4px;" 
                                                    type="search" 
                                                    autocomplete="off" 
                                                    autocorrect="off" 
                                                    autocapitalize="none" 
                                                    spellcheck="false" 
                                                    role="textbox" 
                                                    placeholder="Tìm sản phẩm cần áp dụng"
                                                    ng-model="discount.keywordBuy"
                                                    ng-keyup="suggestion('buy')"
                                                    \>
                                        </span>
                                    </span>
                                </span>
                                <span class="select2-results" ng-show="showSuggestion" style="top: 100%; width: 100%; background: #fff; box-shadow: 0 0 3px rgba(11, 11, 11, 0.5); border-radius: 0 0 4px 4px">
                                    <div class="box-body table-responsive no-padding">
                                        <table class="table table-hover">
                                            <tbody>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Ảnh</th>
                                                    <th>Tên sản phẩm</th>
                                                </tr>
                                                <tr ng-repeat="item in itemSuggestions">
                                                    <td style="width: 10px;">
                                                        <input type="checkbox" ng-model="item.is_checked" ng-true-value="1" ng-false-value="0"/>
                                                    </td>
                                                    <td>
                                                        <img src="@{{item.image_url}}" style="height: 30px;"/>
                                                    </td>
                                                    <td>@{{item.name}}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <div class="pull-right" style="margin: 6px;">
                                            <button type="button" class="btn btn-primary" ng-click="applyItem('apply_product')" id="btn-save-2"><i class="fa fa-save"></i> Áp dụng</button>
                                            <button type="button" class="btn btn-default" ng-click="cancelSuggestion()" id="btn-cancel"><i class="fa fa-times"></i> Hủy</button>
                                        </div>
                                    </div>
                                </span>

                                <div class="box-body table-responsive no-padding" ng-show="discount.apply_product_items.length > 0">
                                    <table class="table table-hover">
                                        <tbody>
                                            <tr>
                                                <th>#</th>
                                                <th>Ảnh</th>
                                                <th>Tên sản phẩm</th>
                                                <th></th> 
                                            </tr>
                                            <tr ng-repeat="item in discount.apply_product_items">
                                                <td>@{{$index + 1 }}</td>
                                                <td>
                                                    <img src="@{{item.image_url}}" style="height: 30px;"/>
                                                </td>
                                                <td>@{{item.name}}</td>
                                                <td>
                                                    <button type="button" class="btn btn-danger btn-sm" title="Xóa sản phẩm" ng-click="deleteApplyItem($index, 'apply_product');">
                                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="form-group" ng-show="discount.buy_product_type == 'category'">
                                <span class="select2-container select2-container--default select2-container--open" style="width: 100%;">
                                    <span class="select2-dropdown" dir="ltr" style="width: 100%; position: initial; top: auto; border-radius: 2px;">
                                        <span class="select2-search select2-search--dropdown">
                                            <input class="select2-search__field" 
                                                    style="padding: 4px;" 
                                                    type="search" 
                                                    tabindex="0" 
                                                    autocomplete="off" 
                                                    autocorrect="off" 
                                                    autocapitalize="none" 
                                                    spellcheck="false" 
                                                    role="textbox" 
                                                    placeholder="Tìm danh mục cần áp dụng"
                                                    ng-model="discount.keywordBuy"
                                                    ng-keyup="suggestion('buy')"
                                                    />
                                        </span>
                                    </span>
                                </span>
                                <span class="select2-results" ng-show="showSuggestion" style="top: 100%; width: 100%; background: #fff; box-shadow: 0 0 3px rgba(11, 11, 11, 0.5); border-radius: 0 0 4px 4px">
                                    <div class="box-body table-responsive no-padding">
                                        <table class="table table-hover">
                                            <tbody>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Tên danh mục </th>
                                                </tr>
                                                <tr ng-repeat="item in itemSuggestions">
                                                    <td style="width: 10px;">
                                                        <input type="checkbox" ng-model="item.is_checked" ng-true-value="1" ng-false-value="0"/>
                                                    </td>
                                                    <td>@{{item.tree_name}}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <div class="pull-right" style="margin: 6px;">
                                            <button type="button" class="btn btn-primary" ng-click="applyItem('apply_category')" id="btn-save-2"><i class="fa fa-save"></i> Lưu</button>
                                            <button type="button" class="btn btn-default" ng-click="cancelSuggestion()" id="btn-cancel"><i class="fa fa-times"></i> Hủy</button>
                                        </div>
                                    </div>
                                </span>

                                <div class="box-body table-responsive no-padding" ng-show="discount.apply_category_items.length > 0">
                                    <table class="table table-hover">
                                        <tbody>
                                            <tr>
                                                <th>#</th>
                                                <th>Tên danh mục</th>
                                                <th></th> 
                                            </tr>
                                            <tr ng-repeat="item in discount.apply_category_items">
                                                <td>@{{$index + 1 }}</td>
                                                <td>@{{item.tree_name}}</td>
                                                <td>
                                                    <button type="button" class="btn btn-danger btn-sm" title="Xóa danh mục" ng-click="deleteApplyItem($index, 'apply_category');">
                                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Khách hàng được</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group">
                                <p class="help-block">Khách hàng phải thêm sản phẩm chỉ định bên dưới vào giỏ hàng</p>
                            </div>
                            <div class="form-group">
                                <label>Số lượng</label>
                                <input type="text" ng-model="discount.quantity_get" class="form-control input-qty" placeholder="Nhập số lượng">
                            </div>
                            <!-- <div class="form-group">
                                
                                <select ng-options="item.code as item.text for item in chooseProductTypes"
                                    class="form-control input-qty"
                                    ng-model="discount.get_product_type"
                                >
                                </select>
                            </div> -->
                            <div class="form-group" ng-show="discount.get_product_type == 'product'">
                                <label>Chọn sản phẩm áp dụng</label>
                                <span class="select2-container select2-container--default select2-container--open" style="width: 100%;">
                                    <span class="select2-dropdown" dir="ltr" style="width: 100%; position: static; top: auto; border-radius: 2px;">
                                        <span class="select2-search select2-search--dropdown">
                                            <input class="select2-search__field" 
                                                    style="padding: 4px;" 
                                                    type="search" 
                                                    autocomplete="off" 
                                                    autocorrect="off" 
                                                    autocapitalize="none" 
                                                    spellcheck="false" 
                                                    role="textbox" 
                                                    placeholder="Tìm sản phẩm cần áp dụng"
                                                    ng-model="discount.keywordGet"
                                                    ng-keyup="suggestion('get')"
                                                    \>
                                        </span>
                                    </span>
                                </span>
                                <span class="select2-results" ng-show="showGetSuggestion" style="top: 100%; width: 100%; background: #fff; box-shadow: 0 0 3px rgba(11, 11, 11, 0.5); border-radius: 0 0 4px 4px">
                                    <div class="box-body table-responsive no-padding">
                                        <table class="table table-hover">
                                            <tbody>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Ảnh</th>
                                                    <th>Tên sản phẩm</th>
                                                </tr>
                                                <tr ng-repeat="item in itemGetSuggestions">
                                                    <td style="width: 10px;"><input type="checkbox" ng-model="item.is_checked" ng-true-value="1" ng-false-value="0"/></td>
                                                    <td>
                                                        <img src="@{{item.image_url}}" style="height: 30px;"/>
                                                    </td>
                                                    <td>@{{item.name}}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <div class="pull-right" style="margin: 6px;">
                                            <button type="button" class="btn btn-primary" ng-click="applyItem('customer_get_product')" id="btn-save-2"><i class="fa fa-save"></i> Áp dụng</button>
                                            <button type="button" class="btn btn-default" ng-click="cancelSuggestion()" id="btn-cancel"><i class="fa fa-times"></i> Hủy</button>
                                        </div>
                                    </div>
                                </span>

                                <div class="box-body table-responsive no-padding" ng-show="discount.customer_get_product_items.length > 0">
                                    <table class="table table-hover">
                                        <tbody>
                                            <tr>
                                                <th>#</th>
                                                <th>Ảnh</th>
                                                <th>Tên sản phẩm</th>
                                                <th></th> 
                                            </tr>
                                            <tr ng-repeat="item in discount.customer_get_product_items">
                                                <td>@{{$index + 1 }}</td>
                                                <td>
                                                    <img src="@{{item.image_url}}" style="height: 30px;"/>
                                                </td>
                                                <td>@{{item.name}}</td>
                                                <td>
                                                    <button type="button" class="btn btn-danger btn-sm" title="Xóa sản phẩm" ng-click="deleteApplyItem($index, 'customer_get_product');">
                                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Với giá trị giảm</label>
                                <div class="radio" ng-repeat="type in customer_get_values">
                                    <label>
                                        <input type="radio" name="customer_get_value" ng-model="discount.customer_get_value" ng-value="type.code" ng-click="chooseCustomerGetValue(type)">
                                            @{{type.text}}
                                    </label>
                                </div>
                                <div ng-show="discount.customer_get_value == 'percent'">
                                    <input type="text" ng-model="percent_get" class="form-control input-qty" id="code" placeholder="Nhập phần trăm giảm">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-5">

                <div class="box info-discount-box">
                    <div class="box-header with-border">
                        <h3 class="box-title">Thông tin tóm tắt</h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <th style="width:20%">Tên</th>
                                        <td>@{{discount.title}}</td>
                                    </tr>
                                    <tr ng-show="discount.code != ''">
                                        <th style="width:20%">Mã</th>
                                        <td><b>@{{convertUpperCase(discount.code)}}</b></td>
                                    </tr>
                                    <tr>
                                        <th style="width:20%">Trạng thái</th>
                                        <td>
                                            <span ng-show="discount.status == 'active'">Hoạt động</span>
                                            <span ng-show="discount.status == 'inactive'">Dừng hoạt động</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th style="width:20%">Hiển thị</th>
                                        <td>
                                            <span ng-show="discount.is_show_on_site == 0">Ẩn text giảm giá trên site</span>
                                            <span ng-show="discount.is_show_on_site == 1">Hiển thị text giảm giá trên site</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Loại</th>
                                        <td>
                                            <span ng-show="discount.type == 'percent'">Giảm phần trăm</span>
                                            <span ng-show="discount.type == 'fixed_amount'">Giảm số tiền</span>
                                        </td>
                                    </tr>
                                    <tr ng-show="discount.apply_type == 'all'">
                                        <th>Áp dụng</th>
                                        <td>
                                            Toàn bộ sản phẩm
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Giảm</th>
                                        <td>
                                            <span ng-show="discount.type == 'percent'">@{{discount.value}}% giá tiền cho tổng số lượng sản phẩm khách mua được áp dụng</span>
                                            <span ng-show="discount.type == 'percent' && discount.max_discount_value != null && discount.max_discount_value != ''">(tối đa @{{currencyUnit}}@{{discount.max_discount_value}})</span> 
                                            <span ng-show="discount.type == 'fixed_amount'">@{{currencyUnit}}@{{discount.value}} cho tổng số lượng sản phẩm khách mua được áp dụng</span> 
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Yêu cầu</th>
                                        <td>
                                            <span ng-show="discount.minimum_require_type == 'none'">
                                                Không yêu cầu
                                            </span>
                                            <span ng-show="discount.minimum_require_type == 'amount'">
                                                Thanh toán tối thiểu @{{currencyUnit}}@{{discount.minimum_require_value}}
                                            </span>
                                            <span ng-show="discount.minimum_require_type == 'quantity'">
                                                Mua tối thiểu @{{discount.minimum_require_value}} sản phẩm
                                            </span>
                                        </td>
                                    </tr>
                                    <tr ng-show="discount.limited_number_uses > 0 && discount.is_limit_by_user != 1">
                                        <th>Số lần dùng khả dụng</th>
                                        <th>@{{discount.limited_number_uses}} lần</th>
                                    </tr>
                                    <tr ng-show="discount.limited_number_uses >= 0">
                                        <th>Khách hàng đã dùng</th>
                                        <td><span ng-show="discount.number_uses">@{{discount.number_uses}}</span><span ng-show="!discount.number_uses">0</span> lần <span ng-show="discount.is_limit_by_user != 1 && discount.limited_number_uses != 0">(Còn lại @{{ discount.limited_number_uses - discount.number_uses}} lần)</span></th>
                                    </tr>
                                    <tr ng-show="discount.end_time != ''">
                                        <th>Kết thúc</th>
                                        <td>@{{discount.end_time}}</th>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="box-footer">
                                
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>