@extends('system.layout.main', [
'ngController' => 'DiscountController'
])

@section('title')
    <title>Giảm giá</title>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="/modules/discount/css/discount.css?v=<?= time() ?>" />
@endsection

@section('script')
    <script>
        $('#filter > button').on('click', function(event) {
            $(this).parent().toggleClass('open');
        });
        $('body').on('click', function(e) {
            if (!$('#filter').is(e.target) &&
                $('#filter').has(e.target).length === 0 &&
                $('.open').has(e.target).length === 0
            ) {
                $('#filter').removeClass('open');
            }
        });
        $('.dropdown-toggle').dropdown();
        var currencyUnit = '{{ getCurrencyUnit(true) }}';
    </script>
    <script src="/modules/discount/js/discount-controller.js?v=<?= time() ?>"></script>
@endsection

@section('content')
    <div id="product-list" ng-show="!showForm">
        <div class="content">
            <div class="row">
                <div class="col-md-12" style="margin: 15px 0px">
                    <div class="pull-left">
                        <h3 style="margin: 0">Giảm giá</h3>
                    </div>
                    <div class="pull-right">
                        <button class="btn btn-success" type="button" ng-click="openForm('create', null)">
                            <i class="fa fa-plus"></i> Thêm mới
                        </button>
                    </div>
                </div>
                <div class="col-md-12" style="min-height: 500px">
                    <div class="box no-border">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs hide-xs" style="border-bottom: 0px;">
                                <li class="all-item">
                                    <a href="javascript:void(0)" style="cursor: pointer">
                                        Tìm kiếm
                                    </a>
                                </li>
                                <li class="float-right">
                                    <a class="command-link" href="javascript:void(0)" ng-click="switchMode('narrow')" ng-show="mode == 'expand'" style=""><i class="fa fa-angle-up"></i> Thu hẹp</a>
                                    <a class="command-link" href="javascript:void(0)" ng-click="switchMode('expand')" ng-show="mode == 'narrow'" style=""><i class="fa fa-angle-down"></i> Mở rộng</a>
                                </li>
                            </ul>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            @view('discount.filters')
                            @view('discount.lists')
                            <div class="pull-right">
                                @view('discount.includes.paginator', [
                                    "accessPageId" => "filters.page_id",
                                    "accessPagesCount" => "pagesCount",
                                    "accessFind" => "find()"
                                ])
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @view('discount.form')
@endsection