@extends('system.layout.main', [
    'ngController' => 'FlashSaleController'
])

@section('title')
    <title>Flash Sale</title>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="/modules/discount/css/discount.css?v=<?= Config::get("sa.version") ?>"/>
    <link rel="stylesheet" href="/system/css/jquery.datetimepicker.css?v=<?= Config::get("sa.version") ?>" media="screen">
@endsection

@section('script')
    <script>
        const currentLocale = '<?= !empty(env('APP_LOCALE')) ? env('APP_LOCALE') : 'us' ?>';
    </script>
    <script src="/modules/discount/js/flash-sale-controller.js?v=<?= Config::get("sa.version") ?>"></script>
    <script src="/system/js/scripts/jquery.datetimepicker.js"></script>
@endsection

@section('content')
    <div id="product-list" ng-show="!showForm">
        <div class="content">
            <div class="row">
                <div class="col-md-12" style="margin: 15px 0">
                    <div class="pull-left">
                        <h3 style="margin: 0">Flash sale</h3>
                    </div>
                    <div class="pull-right">
                        <button class="btn btn-success" type="button" ng-click="openForm('create', null)">
                            <i class="fa fa-plus"></i> Thêm mới
                        </button>
                        <a href="/system/files/Flash_Sale.xlsx"
                           class="btn btn-primary"
                        >
                            File csv demo
                        </a>
                        <div class="btn-group">
                            <button class="btn btn-default" ngf-select ng-model="excelFile"
                                    accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel"
                                    ngf-max-size="20MB" ng-change="handleUploadData(excelFile)"
                                    style="height: 34px">
                                <i class="fa fa-upload"></i> <?= __s("Import data")?>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="col-md-12" style="min-height: 500px">
                    <div class="box no-border">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs hide-xs" style="border-bottom: 0;">
                                <li class="all-item">
                                    <a href="javascript:void(0)" style="cursor: pointer">
                                        Tìm kiếm
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            @view('flash-sale.filters')
                            @view('flash-sale.lists')
                            <div class="pull-right">
                                @view('discount.includes.paginator', [
                                    "accessPageId" => "filters.page_id",
                                    "accessPagesCount" => "pagesCount",
                                    "accessFind" => "find()"
                                ])
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @view('flash-sale.form')
@endsection