<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
$systemAuth = config('app.system_auth_middleware');
Route::group(['prefix' => 'discount', 'middleware' => $systemAuth], function () {
// Route::group(['prefix' => 'discount'], function () {

    Route::get('/', [
        'as' => 'discount::home',
        'uses' => 'HomeController@index',
    ]);

    Route::get('/flash-sale', 'DiscountController@flashSale')->name('discount::flash-sale');

    Route::post('/classify-data', ['uses' => 'DiscountController@classifyData'])
        ->name('discount::classify-data');
    Route::post('/store-import-data', ['uses' => 'DiscountController@storeDataImported'])
        ->name('discount::store-import-data');

    Route::get('/category', [
        'as' => 'discount::category',
        'uses' => 'HomeController@category'
    ]);

    Route::get('/product', [
        'as' => 'discount::product',
        'uses' => 'HomeController@product'
    ]); 

    Route::get('find', [
        'as' => 'discount::find',
        'uses' => 'DiscountController@find',
    ]);

    Route::post('/', [
        'as' => 'discount::create',
        'uses' => 'DiscountController@store',
    ]);

    Route::put('/{id}', [
        'as' => 'discount::update',
        'uses' => 'DiscountController@store',
    ]);
});

Route::group(['prefix' => 'discount', 'middleware' => ['frontend']], function () {
    Route::get("/info", [
        'as' => 'discount::info',
        'uses' => 'HomeController@getProductDiscountInfo'
    ]);
    Route::get("/info-by-category", [
        'as' => 'discount::info-by-category',
        'uses' => 'HomeController@getDiscountInfoByCategory'
    ]);
    Route::get("/cart/info", [
        'as' => 'discount::cart::info',
        'uses' => 'HomeController@getDiscountInfoCartItem'
    ]);
    Route::get("/total", [
        'as' => 'discount::total',
        'uses' => 'HomeController@getDiscountByCartItem'
    ]);

    Route::get("/migrate", [
        'as' => 'discount::migrate',
        'uses' => 'HomeController@generateDiscount'
    ]);

    Route::post("/apply-code", [
        'as' => 'discount::apply-code',
        'uses' => 'HomeController@checkPromotionCode'
    ]);

    Route::get("/increment", [
        'as' => 'discount::increment',
        'uses' => 'HomeController@incrementDiscount'
    ]);
    Route::post("/custom/create", [
        'as' => 'discount::custom::create',
        'uses' => 'HomeController@createCustomDiscount'
    ]);

    Route::get("/free-ship-info", [
        'as' => 'discount::free-ship-info',
        'uses' => 'HomeController@getFreeShippingInfo'
    ]);
});
