<?php 
namespace Modules\EmailMarketing\Controllers;

class BaseController extends Controller {

    const DEFAULT_STATUS = 'fail';
    const SUCCESS_STATUS = 'successful';


    protected function getDefaultStatus() {
        return ['status' => self::DEFAULT_STATUS];
    }

    protected function getSuccessStatus($data) {
        return [
            'status' => self::SUCCESS_STATUS,
            'result' => $data
        ];
    }


    /**
     * 
     * @param string endpoint
     * @param string method
     * @param array params
     * @param array headers
     * 
     * @return retval
     */
    protected function sendHttpRequest($endpoint, $method = 'GET', $params = "", $headers = []) {
        $retval = [
            'status' => false
        ];
        $method = strtoupper($method);

        $url = config('email-marketing::sa.api.url') . '' . $endpoint;

        $headers[] = 'Accept: application/json';

        if ($method == 'GET') {
            $url = $url . '?' . $params;
        }
        
        $curlOptions = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_HTTPHEADER => $headers,
        ];

        if ($method == 'POST' || $method == 'DELETE') {
            $curlOptions[CURLOPT_POST] = true;
            $curlOptions[CURLOPT_POSTFIELDS] = $params;
        }
        
        $curl = curl_init();

        curl_setopt_array($curl, $curlOptions);

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);
        
        if ($err) {
            $retval['message'] = "cURL Error #:" . $err;
        } else {
            $retval = [
                'status' => true,
                'result' => json_decode($response)
            ];
        }

        return $retval;
    }
}