<?php 
namespace Modules\EmailMarketing\Controllers;

use Illuminate\Http\Request;
use Modules\EmailMarketing\Models\Customer;

class IntegrationController extends BaseController {

    protected $apiKey = '';

    protected $memberPerList = 10000;

    protected $pageSize = 100;

    protected $totalResult = [];

    public function __construct()
    {
        $this->apiKey = config('email-marketing::sa.api.token');
    }

    /**
     * 
     */
    public function getList() {
        $response = $this->getDefaultStatus();
        $result = $this->sendHttpRequest('/lists', 'GET', http_build_query(['api_key' => $this->apiKey]));
        if (isset($result['status']) && $result['status']) {
            $response = $this->getSuccessStatus($result['result']);
        }
        return response()->json($response);
    }

    /**
     * 
     */
    public function createList(Request $request) {
        $response = $this->getDefaultStatus();
        
        if ($request->has('listName')) {
            $isListExists = $this->checkListIsExist($request->get('listName'));
            if (!$isListExists) {
                $endpoint = '/lists?api_key=' . $this->apiKey;
                $params = [
                    'list_name' => $request->get('listName'),
                ];
                $result = $this->sendHttpRequest($endpoint, 'POST', http_build_query($params), ["Content-Type: application/x-www-form-urlencoded"]);
                if (isset($result['status']) && $result['status']) {
                    $response = $this->getSuccessStatus($result['result']);
                }
            } else {
                $response['message'] = 'List is exists. Please, choose another name.';
            }
        } else {
            $response['message'] = 'Please, provide to a name of list';
        }

        return response()->json($response);
    }

    /**
     * 
     * 
     */
    public function addMemberToList(Request $request) {
        $response = $this->getDefaultStatus();
        $pageSize = 100;
        if ($request->has('list_name') || $request->has('use_locale')) {
            $listName = $request->get('list_name', null);
            if ($request->has('use_locale')) {
                $locale = env('APP_LOCALE');
                if ($locale == '') {
                    $locale = 'us';
                }
                $listName = strtoupper($locale);
            }
            if (!empty($listName)) {
                $filters = $request->all();
                $totalEmails = $this->getCustomerEmail($this->pageSize, 0, $filters, "total");
                $maxListCanBeCreate = ceil($totalEmails/ $this->memberPerList);
                if ($request->has('debug') && $maxListCanBeCreate > 1) {
                    $maxListCanBeCreate = 1;
                }
                $this->handleAddMembers($listName, $filters, $maxListCanBeCreate);
                $response = $this->getSuccessStatus($this->totalResult);
            }
        } else  {
            $response['message'] = 'Please, provide a list of name';
        }

        return response()->json($response);
    }


    /**
     * 
     * 
     */
    private function checkListIsExist($listName, $autoCreate = false) {
        $retval = [
            'listId' => false,
            'residual' => -1,
            'listName' => ''
        ];
        $listId = false;
        $foundName = '';
        $result = $this->sendHttpRequest('/lists', 'GET', http_build_query(['api_key' => $this->apiKey]));
        if (isset($result['status']) && $result['status']) {
            $data = $result['result'];
            $lists = [];
            $lastIndex = -1;
            foreach ($data as $item) {
                if (preg_match("/$listName/m", $item->list_name, $matched)) {
                    $listId = $item->list_id;
                    $nameArray = explode('-', $item->list_name);
                    $index = isset($nameArray[1]) ? (int) $nameArray[1] : 0;
                    $lists[$index] = [$item->list_id, $item->list_name];
                }
            }
            if (count($lists) > 0) {
                ksort($lists);
                $lastIndex = count($lists) - 1;
                $lastOfList = end($lists);
                $listId = $lastOfList[0];
                $foundName = $lastOfList[1];
            }
        }
    
        if (!$listId && $autoCreate) { 
            //If cannot find any listed with listName was passed in and auto-create was allowed. Create a new one.
            $retval['listId'] = $this->createNewList($listName);
            $retval['residual'] = $this->memberPerList;
            $retval['listName'] = $listName;
        } else if ($listId) {
            $total = $this->countListMembers($listId);
            //Calculate how many more members can be added.
            $residual = $this->memberPerList - $total;
            if ($residual == 0) {
                //Create a new list with the last of the index with the same name.
                $listName = strtoupper($listName) . '-' . ($lastIndex + 1);
                $retval['listId'] = false; //$this->createNewList($listName);
                $retval['listName'] = $listName;
                $retval['residual'] = $this->memberPerList;
            } else {
                $retval = [
                    'listId' => $listId,
                    'residual' => $residual,
                    'listName' => $foundName
                ];
            }
        }
        return $retval;
    }

    private function countListMembers($listId, $total = 0, $marker = NULL, $limit = 10000, $stop = false) {
        if ($total >= $limit || ($total > 0 && $marker == NULL) || $stop) {
            return $total;
        }
        $endpoint = "/group/$listId/members/all";
        $params = [
            'api_key' => $this->apiKey
        ];
        if ($marker !== NULL) {
            $params['marker'] = $marker;
        }
        $reqResult = $this->sendHttpRequest($endpoint, 'GET', http_build_query($params));
        if (isset($reqResult['status']) && $reqResult['status']) {
            $total += isset($reqResult['result']->records) ? count($reqResult['result']->records) : 0;
            $markerId = isset($reqResult['result']->marker) ? $reqResult['result']->marker : NULL;
            $stop = ($total == 0) ? true : false;
            return $this->countListMembers($listId, $total, $markerId, 10000, $stop);
        } else {
            return 0;   
        }
    }

    /**
     * @param string listName
     * 
     * @return string retval
     */
    private function createNewList($listName) {
        $retval = NULL;
        $endpoint = '/lists?api_key=' . $this->apiKey;
        $params = [
            'list_name' => $listName,
        ];
        $result = $this->sendHttpRequest($endpoint, 'POST', http_build_query($params), ["Content-Type: application/x-www-form-urlencoded"]);
        if (isset($result['status']) && $result['status']) {
            $retval = $result['result']->list_id;
        }
        return $retval;
    }


    private function requestAddMembers($listId, $customers) {
        $endpoint = '/list/' . $listId . '/members?api_key=' . $this->apiKey;
        $result = NULL;
        if (count($customers) > 0) {
            $params = [
                'profiles' => $customers
            ];
            $result = $this->sendHttpRequest($endpoint, 'POST', json_encode($params), ["Content-Type: application/json"]);
        }
        return $result;
    }
    
    private function getCustomerEmail($limit=100, $offset=0, $filters, $metric="all") {
        $query = Customer::query();
        $now = date('Y-m-d H:i:s');
        if (array_key_exists('to_time', $filters)) {
            $now = date('Y-m-d H:i:s', strtotime($filters['to_time']));
        }
        if (array_key_exists('from_time', $filters)) {
            $fromTime = date('Y-m-d H:i:s', strtotime($filters['from_time']));
        } else {
            $fromTime = date('Y-m-d H:i:s', strtotime('-2 hours', strtotime($now)));
        }
        if (!array_key_exists('all_time', $filters)) {
            $query = $query->whereBetween('created_at', [$fromTime, $now]);
        }
        if ($metric == 'total') {
            return $query->count();
        } else {
            $query->limit($limit);
            $query->offset($offset);
            return $query->get(['email'])->toArray();
        }
    }

    private function handleAddMembers($listName, $filters, $totalEmails, $lastPageIndex = 0) {
        if (($lastPageIndex + 1) > $totalEmails) {
            return false;
        }
        // $optionName = ($lastPageIndex == 0) ? "" : "-" . $lastPageIndex;
        // $listName = $baseName . $optionName;
        $findList = $this->checkListIsExist($listName, true);
        // echo json_encode($findList) . "<br />";
        if ($findList['listId']) {
            $listName = $findList['listName'];
            $reqCount = ceil($findList['residual'] / $this->pageSize);
            $totalEmails = 0;
            for ($req = 0; $req < $reqCount; $req++) {
                $offset = $req * $this->pageSize;
                $customers = $this->getCustomerEmail($this->pageSize, $offset, $filters);
                if (count($customers) > 0) {
                    $totalEmails += count($customers);
            //         echo "Request add members <br />";
                    $this->requestAddMembers($findList['listId'], $customers);
                }
            }
            $this->totalResult[] = [$findList['listName'] => $totalEmails];
            $lastPageIndex = $lastPageIndex + 1;
            // $totalEmails = $totalEmails - 1;
            $this->handleAddMembers($listName, $filters, $totalEmails, $lastPageIndex);
        } else {
            $lastPageIndex = $totalEmails;
        }
    }

}