<?php

namespace Modules\EmailMarketing\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AfterSaleDelivered extends Mailable
{
    use Queueable, SerializesModels;

    public $discount;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($order)
    {
        $this->order = $order;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $siteName = config('app.name');
        $email = config('email-marketing::sa.support_email');
        $siteUrl = config('app.url');

        return($this->subject(translate("PLEASE READ!"))
            ->view('email-marketing::mail-templates.after-sale-delivered', [
                'siteName' => $siteName,
                'siteUrl' => $siteUrl,
                'email' => $email,
                'order' => $this->order
            ]));
    }

}
