<?php

namespace Modules\EmailMarketing\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ForgetItemInCart extends Mailable
{
    use Queueable, SerializesModels;

    public $discount;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($order, $customer)
    {
        $this->order = $order;
        $this->customer = $customer;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $siteName = config('app.name');
        $email = config('email-marketing::sa.support_email');
        $siteUrl = config('app.url');
        return($this->subject(translate('Did you forget somethings?'))
                        ->view('email-marketing::home.email-item-in-cart', [
                            'siteName' => $siteName,
                            'siteUrl' => $siteUrl,
                            'email' => $email,
                            'order' => $this->order,
                            'customer' => $this->customer,
                        ]));
    }

}
