<?php

namespace Modules\EmailMarketing\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $table = "order";
    protected $fillable = [
        'code',
        'customer_id',
        'status',
        'discount',
        'shipping_fee',
        'amount',
        'delivery_address',
        'commune_id',
        'district_id',
        'province_id',
        'country_id',
        'delivery_location_id',
        'delivery_district_id',
        'delivery_note',
        'note',
        'warehouse_id',
        'shipper_id',
        'shipping_code',
        'prepaid_amount',
        'promotion_code',
        'payment_type',
        'payment_status',
        'zip_code',
        'type',
        'search',
        'product_quantity',
        'shipping_type',
        'verifier_id',
        'payment_account'
    ];

    protected $appends = [
        'items',
    ];

    public function orderItems() {
        return $this->hasMany(OrderItem::class);
    }

    public function getItemsAttribute() {
        return self::buildItems($this->id);
    }

    public static function buildItems($orderId) {
        $embeds = [
            'product' => function ($query) {
                $query->select([
                    'id', 'sku', 'name', 'image_url', 'weight', 'slug'
                ]);
                $query->with([
                    'meta' => function ($query) {
                        $query->where('key', 'is_custom_design')
                            ->where('value', 1);
                    },
                ]);
            },
            'productSku' => function ($query) {
                $query->select([
                    'id', 'sku'
                ]);
            }
        ];
        $items = OrderItem::with($embeds)
                            ->where('order_id', '=', $orderId)
                            ->get();
        $retVal = [];
        foreach ($items as $item) {
            $isCustomDesign = is_object($item->product) && is_object($item->product->meta) && $item->product->meta->count();
            $newItem = [
                'id' => $item->id,
                'product_id' => $item->product_id,
                'product_sku_id' => $item->product_sku_id,
                'quantity' => $item->quantity,
                'price' => $item->price,
                'sku' => is_object($item->product) ? $item->product->sku : '',
                'product_sku' => is_object($item->product) ? $item->product->sku : '',
                'name' => is_object($item->product) ? $item->product->name : '',
                'image_url' => $item->image_url ? $item->image_url : '/images/image-not-available.png',
                'design_url' => $isCustomDesign ? $item->design_url : null,
                'url' => is_object($item->product) ? $item->product->url : '',
                'editUrl' => is_object($item->product) ? $item->product->editUrl : '',
                'configurations' => isset($item->configurations) ? $item->configurations : '',
                'is_custom_design' => $isCustomDesign,
                'weight' => is_object($item->product) ? $item->product->weight : 0,
                'cost' => $item->cost,
                'shipping_cost' => $item->shipping_cost
            ];
            if ($item->product_sku_id != '') {
                if (is_object($item->productSku)) {
                    $newItem['sku'] = $item->productSku->sku;
                    if ($item->productSku->sku_name) {
                        $newItem['name'] .= ', ' . $item->productSku->sku_name;
                    }
                    $newItem['url'] .= '?spid=' . $item->productSku->id;
                }
            }
            $retVal[] = $newItem;
        }
        return $retVal;
    }

}
