<?php

namespace Modules\EmailMarketing\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table = "product";
    protected $appends = ["url"];
    public function meta()
    {
        return $this->hasMany(ProductMeta::class, 'product_id', 'id');
    }

    public function getUrlAttribute () {
        $retval = getPrefixUrl();
        return $retval . "/" . (!empty($this->slug) ? $this->slug : "san-pham") . "-p" . $this->id . ".html";
    }
}
