system.controller("EmailBlacklistController", EmailBlacklistController);

function EmailBlacklistController ($scope, $http) 
{
    var self = this;
    $scope.isSearching = false;
    $scope.isTextChanged = false;
    $scope.emailLists = [];
    $scope.tempLists = [];
    $scope.filters = {
        page_size: 100,
        page_id: 0
    };

    $scope.pagesCount = 0

    this.initialize = () => {
        this.getEmails();
    }

    $scope.findItem = () => {
        $http.get('/email-marketing/blacklist/lists', {params: $scope.filters})
            .then(res => {
                const data = res.data;
                $scope.isSearching = true;
                if (data.status == 'successful') {
                    $scope.emailLists = data.result;
                    $scope.filters.page_id = data.paginate.pageId;
                    $scope.pagesCount = data.paginate.pagesCount;
                }
            })
    }

    $scope.addItem = () => {
        $http.post('/email-marketing/blacklist/add', {email: $scope.filters.email})
            .then(res => {
                const data = res.data;
                if (data.status == 'successful') {
                    $scope.clearSearch(true);
                }
            })
    }

    $scope.removeItem = (email) => {
        const conf = confirm('Are you sure to remove item from blacklist?');
        if (!conf) {
            return false;
        }
        $http.delete('/email-marketing/blacklist/remove', {params: {email: email}})
            .then(res => {
                const data = res.data;
                if (data.status == 'successful') {
                    $scope.clearSearch(true);
                }
            })
    }

    $scope.clearSearch = (isRefresh) => {
        $scope.isSearching = false;
        delete $scope.filters.email;
        if (isRefresh) {
            this.getEmails();
        }
    }

    $scope.textChange = () => {
        $scope.isSearching = false;
        $scope.isTextChanged = true;
    }

    this.getEmails = () => {
        $http.get('/email-marketing/blacklist/lists', {params: $scope.filters})
            .then(res => {
                const data = res.data;
                if (data.status == 'successful') {
                    $scope.emailLists = data.result;
                    $scope.filters.page_id = data.paginate.pageId;
                    $scope.pagesCount = data.paginate.pagesCount;
                }
            })
    }

    this.buildFilters = () => {
        
    }

    this.initialize();
}
