@extends('system.layout.main', [
'ngController' => 'EmailBlacklistController'
])

@section('title')
    <title>Blacklist</title>
@endsection

@section('script')
    <script>
        $('#filter > button').on('click', function(event) {
            $(this).parent().toggleClass('open');
        });
        $('body').on('click', function(e) {
            if (!$('#filter').is(e.target) &&
                $('#filter').has(e.target).length === 0 &&
                $('.open').has(e.target).length === 0
            ) {
                $('#filter').removeClass('open');
            }
        });
        $('.dropdown-toggle').dropdown();
    </script>
    <script src="/modules/email-marketing/js/email-blacklist-controller.js?v=<?= time() ?>"></script>
@endsection

@section('content')
<div class="content" ng-cloak>
    <div class="row">
        <div class="col-md-12" style="margin: 15px 0px">
            <div class="pull-left">
                {{-- <h3 style="margin: 0">Giảm giá</h3> --}}
            </div>
        </div>
        <div class="col-md-12" style="min-height: 500px">
            <div class="box no-border">
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs hide-xs" style="border-bottom: 0px;">
                        <li class="all-item">
                            <label for="search" class="search-label">
                                Search 
                                <input type="text" id="search" 
                                ng-change="textChange()"
                                name="search-email" class="form-control search" 
                                ng-model="filters.email" placeholder="Type email want to find" />
                                <span class="btn btn-success" ng-click="findItem()"><i class="fa fa-search"></i> Find</span>
                                <span class="btn btn-success" ng-click="clearSearch(true)" ng-show="filters.email"><i class="fa fa-refresh"></i> Clear</span>
                                <span class="btn btn-primary" ng-click="addItem()" ng-show="filters.email && filters.email !== ''"><i class="fa fa-plus"></i> Add to blacklist</span>
                            </label>
                        </li>
                    </ul>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    @include('email-marketing::blacklist.list')
                    <div class="pull-right">
                        @include('email-marketing::blacklist.paginator', [
                            "accessPageId" => "filters.page_id",
                            "accessPagesCount" => "pagesCount",
                            "accessFind" => "findItem()"
                        ])
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('css')
<style>
    .action-remove {
        color: #de4f4f;
        padding-left: 5px;
        cursor: pointer;
    }
    .trash {
        color: #4ba4ea;
    }
    .trash:hover {
        text-decoration: underline;
    }
    .search {
        width: 400px;
        display: initial;
        font-weight: normal;
    }
    .search-label {
        padding: 10px 15px;
    }
    /* pagination */
    .pagination-box {
        margin: 12px auto 12px;
        padding-top: 12px;
        display: flex;
        justify-content: flex-start;
        align-content: center;
    }

    .pagination {
        margin: 0;
        padding: 0;
        list-style: none;
        display: flex;
        justify-content: flex-start;
        align-items: center;
    }

    .pagination li {
        display: flex;
        justify-content: center;
        align-items: center;
        margin-right: 6px;
        background-color: #efefef;
        border-radius: 3px;
        user-select: none;
        cursor: pointer;
        padding: calc(12px - 4px) 12px;
        line-height: 1;
    }

    .pagination li:hover {
        color: #095098;
    }

    .pagination .disable {
        display: none;
    }

    .pagination .active {
        color: #999;
        cursor: pointer;
        pointer-events: none;
    }

    .pagination .disable {
        background-color: #999;
        color:  #fff;
        cursor: default;
        pointer-events: none;
    }
</style>
@endsection
