<?php
    $locale = env('APP_LOCALE') ? env('APP_LOCALE') : '';
    $domain = \URL::to('/') . (($locale)? '/' . strtolower($locale) : '');
?>
<!DOCTYPE html>
<html dir="ltr">
<head>
    <meta charset="utf-8">
    <title><?= __('PLEASE READ!') ?></title>
</head>
<body style="background: #f1f1f1; font-family: Arial, Helvetica, sans-serif; margin: 0; padding: 0">
    <table
        style="width: 100%; border: none; text-align: center; border-collapse: collapse; line-height: 1.5; background: #f1f1f1">
        <tr style="padding: 0; border: none; vertical-align: center; text-align: center;  background: #f1f1f1">
            <td style="border: none; font-family: Arial, Helvetica, sans-serif; font-size: 15px; text-align: center">
                <table
                    style="width: 90%; max-width: 600px; margin: 0 auto; border: none; text-align: center; border-collapse: collapse; background: #fff;">
                    <tr style="padding: 0; border: none">
                        <td
                            style="padding: 0 16px; border: none; font-family: Arial, Helvetica, sans-serif; font-size: 15px; border-top: 6px solid #ff7300;">
                            <div style="width: 100%; padding: 8px 0; text-align: justify;  line-height: 1.5;">
                                <div
                                    style="width: 100%;  font-family: Arial, Helvetica, sans-serif; font-size: 15px; padding: 16px 0; color: #333">
                                    <img src="{{ asset('/images/logo.png') }}" alt="{{ getOption('general.store_name', 'Printerval') }}" width="160"
                                        height="40">
                                </div>
                                <div
                                    style="width: 100%; border-radius: 8px 8px 0 0; font-family: Arial, Helvetica, sans-serif; font-size: 15px; color: #333">
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('Hey there!') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('First of all, I would like to thank you for purchasing our products.') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('Recently, there has been a small issue with delivery men handling our packages a little recklessly, so I am personally reaching out to you to ensure that your package has arrived undamaged!') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('If there is ANY ISSUE at all with your product, please reply to this email so I can make it right.') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('I want to make sure that you are 100% happy and satisfied with your product. <br>Please feel free to send me a message anytime!') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('Thank you!') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        {{ getOption('general.store_name', 'Printerval') }}
                                    </p>
                                </div>
                                <table
                                    style="width: 100%; max-width: 600px; margin: 0 auto; border: none; text-align: center; border-collapse: collapse">
                                    <tr style="vertical-align: top; text-align: left;">
                                        <th colspan="3"
                                            style="vertical-align: top; text-align: left; padding: 6px 0 10px">
                                            <?= __('Items in this shipment') ?>
                                        </th>
                                    </tr>

                                    @if (isset($order->items))
                                        @foreach ($order->items as $item)
                                        <tr style="vertical-align: top; text-align: left;; border-top: 1px solid #e8e8e8">
                                            <td
                                                style="vertical-align: top; text-align: left; width: 80px;  padding: 16px 0;">
                                                <a href="{{ $domain }}/product-p{{ $item->product_id }}?spid={{ $item->product_sku_id }}" target="_blank"
                                                    style="display: block; width: 80px; border: none;">
                                                    <img style="border: none;" width="80"
                                                        src="{{ $item->image_url }}"
                                                        alt="{{ $item->name }} {{ $item->sku_name }}">
                                                </a>
                                            </td>
                                            <td style="width: 20px">&nbsp;</td>
                                            <td style="vertical-align: top; text-align: left; padding: 16px 0;">
                                                <div
                                                    style="display: flex; padding-bottom: 6px; font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 25px; text-align: left">
                                                    <a href="{{ $domain }}/product-p{{ $item->product_id }}?spid={{ $item->product_sku_id }}" target="_blank"
                                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; text-decoration: none; font-size: 18px;; line-height: 23px">
                                                        {{ $item->name }}
                                                    </a>
                                                    <span style="padding: 0 4px; margin-left: auto">&times;</span> {{ $item->quantity }}
                                                </div>
                                                <div style="font-family: Arial, Helvetica, sans-serif; color: #555; font-size: 15px; line-height: 18px; text-align: left">
                                                    {{ $item->sku_name }} ({{ $item->display_price }})
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    @endif
                                </table>
                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

    </table>
</body>

</html>
