<?php
    $locale = env('APP_LOCALE') ? env('APP_LOCALE') : '';
    $domain = \URL::to('/') . (($locale)? '/' . strtolower($locale) : '');
?>
<!DOCTYPE html>
<html dir="ltr">

<head>
    <meta charset="utf-8">
    <title><?= __('HELP!') ?></title>
</head>

<body style="background: #f1f1f1; font-family: Arial, Helvetica, sans-serif; margin: 0; padding: 0">
    <table
        style="width: 100%; border: none; text-align: center; border-collapse: collapse; line-height: 1.5; background: #f1f1f1">
        <tr style="padding: 0; border: none; vertical-align: center; text-align: center;  background: #f1f1f1">
            <td style="border: none; font-family: Arial, Helvetica, sans-serif; font-size: 15px; text-align: center">
                <table
                    style="width: 90%; max-width: 600px; margin: 0 auto; border: none; text-align: center; border-collapse: collapse; background: #fff;">
                    <tr style="padding: 0; border: none">
                        <td
                            style="padding: 0 16px; border: none; font-family: Arial, Helvetica, sans-serif; font-size: 15px; border-top: 6px solid #ff7300;">
                            <div style="width: 100%; padding: 8px 0; text-align: left;  line-height: 1.5;">
                                <div
                                    style="width: 100%;  font-family: Arial, Helvetica, sans-serif; font-size: 15px; padding: 16px 0; color: #333">
                                    <img src="{{ getOption('general.email_logo', 'https://printerval.com/images/logo.png') }}" alt="{{ getOption('general.store_name', 'Printerval') }}" width="160"
                                        height="40">
                                </div>
                                <div
                                    style="width: 100%; border-radius: 8px 8px 0 0; font-family: Arial, Helvetica, sans-serif; font-size: 15px; color: #333">
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('Hey Again') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('I hope you\'ve had the chance to use your products by now. I would like to personally THANK YOU for being one of our customers.') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('Nothing makes me happier than seeing close friends and family enjoy a better life. I hope our products helped to make their life better this year :)') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('If you and/or your loved ones had a wonderful experience with your products, I\'d love to hear about it!') ?>
                                    </p>
                                </div>
                                <table
                                    style="width: 100%; max-width: 600px; margin: 0 auto; border: none; text-align: center; border-collapse: collapse">
                                    <tr style="vertical-align: top; text-align: left;">
                                        <th colspan="3"
                                            style="vertical-align: top; text-align: left; padding: 6px 0 10px; font-weight: 500; color: #ff7300; font-size: 18px">
                                            <?= __('Would you please help us by leaving us a review for this product?') ?>
                                        </th>
                                    </tr>
                                    <tr style="vertical-align: top; text-align: left;">
                                        <td colspan="3" style="vertical-align: top; text-align: center; padding: 15px 0 20px; font-weight: 500; color: #ff7300; font-size: 18px">
                                            <a href="{{ $domain }}/review-order?order={{ $order->id }}&email={{ $order->email }}" style="text-decoration: none; padding: 10px 20px;border-radius: 3px; color: #f9f9f9; background-color:#ff7300"><?= __('Write a Review')?></a>
                                        </td>
                                    </tr>
                                    @if (isset($order->items))
                                        @foreach ($order->items as $item)
                                        <tr
                                            style="vertical-align: top; text-align: left;; border-top: 1px solid #e8e8e8; border-bottom: 1px solid #e8e8e8">
                                            <td
                                                style="vertical-align: top; text-align: left; width: 80px;  padding: 16px 0;">
                                                <a href="{{ $domain }}/product-p{{ $item->product_id }}?spid={{ $item->product_sku_id }}" target="_blank"
                                                    style="display: block; width: 80px; border: none;">
                                                    <img style="border: none;" width="80"
                                                        src="{{ $item->image_url }}"
                                                        alt="{{ $item->name }} {{ $item->sku_name }}">
                                                </a>
                                            </td>
                                            <td style="width: 20px">&nbsp;</td>
                                            <td style="vertical-align: top; text-align: left; padding: 16px 0;">
                                                <div
                                                    style="display: flex; padding-bottom: 6px; font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 25px; text-align: left">
                                                    <a href="{{ $domain }}/product-p{{ $item->product_id }}?spid={{ $item->product_sku_id }}" target="_blank" style="font-family: Arial, Helvetica, sans-serif; color: #333; text-decoration: none; font-size: 18px;; line-height: 23px">
                                                        {{ $item->name }} {{ $item->sku_name }}
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    @endif
                                </table>
                                <div
                                    style="padding-left: 50px; font-style: italic; font-family: Arial, Helvetica, sans-serif; text-align: justify; font-size: 15px; color: #333; position: relative; padding-right: 30px;">
                                    <img src="{{ asset('/images/quote.png') }}" width="80" alt=""
                                        style="position: absolute; top: 0; left:0; with: 80px; height: 54">
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; padding-top: 30px; font-size: 15px; line-height: 18px; position: relative; z-index: 2">
                                        <?= __('We are a small, family-run business and the 1 minute you spend to write us a product review means the world to us as it allows us to get more exposure and stand a chance against the bigger guys.') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('We want to continue to do what we love full-time, to support our family, and to create remarkable & unique products that make those special moments with friends & family even more memorable.') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= sprintf(__('From the bottom of my heart I\'d like to thank you again for ordering from %s. We truly appreciate your business. We LOVE our customers and we will always be here if you need us.'), 'your brand name') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        <?= __('Take care.') ?>
                                    </p>
                                    <p
                                        style="font-family: Arial, Helvetica, sans-serif; color: #333; font-size: 15px; line-height: 18px;">
                                        {{ getOption('general.store_name', 'Printerval') }}
                                    </p>
                                </div>

                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

    </table>
</body>

</html>
