<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::group(['prefix' => 'email-marketing'], function () {
    Route::get('/forget-item-in-cart', [
        'as' => 'email-marketing::send-forgot-item-cart',
        'uses' => 'HomeController@cronSendEmailForgetItemInCart',
    ]);

    Route::get('/build-cart-item', [
        'as' => 'email-marketing::build-cart-item',
        'uses' => 'HomeController@buildCartItem',
    ]);

    Route::get('/after-sale', [
        'as' => 'email-marketing::after-sale',
        'uses' => 'HomeController@cronSendEmailAfterSale',
    ]);

    
    Route::prefix('blacklist')->group(function () {

        Route::get('/', [
            'as' => 'email-marketing::blacklist',
            'uses' => 'BlacklistController@showBlacklist'
        ]);

        Route::post('/add', [
            'as' => 'email-marketing::api::add',
            'uses' => 'BlacklistController@addEmailToBlacklist'
        ]);

        Route::delete('/remove', [
            'as' => 'email-marketing::api::remove',
            'uses' => 'BlacklistController@removeEmailFromBlacklist'
        ]);
        
        Route::get('/lists', [
            'as' => 'email-marketing::api::get-list',
            'uses' => 'BlacklistController@lists'
        ]);

    });

    Route::group(['prefix' => 'integration'], function () {
        Route::get('/lists', 'IntegrationController@getList');
        Route::post('/lists', 'IntegrationController@createList');
        Route::post('/subscribes', 'IntegrationController@addMemberToList');
        Route::get('/subscribes', 'IntegrationController@addMemberToList');
    });
});
