<?php

namespace Modules\FinancialStatement\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function request($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($ch);
        curl_close($ch);

        return $output;
    }

    public function parseOtherSiteData($response) {
        $result = [];
        $response = $response ? json_decode($response, true) : [];
        if ($response && isset($response['status']) && $response['status'] == 'successful') {
            $result =  $response['result'];
        }
        return $result;
    }

    public function mergeReport(&$result, $otherSiteData) {
        $result['list'][] = $otherSiteData;
        $keys = ['revenue', 'payment_fee', 'refund', 'revenue_payment_gateway'];
        foreach ($keys as $key) {
            if (isset($otherSiteData[$key])) {
                $result[$key] += $otherSiteData[$key];
            }
        }
        return $result;
    }
}
