system.controller("FinancialStatementController", FinancialStatementController);
system.directive('chartFinancialStatement', function () {
    return {
        restrict: 'E',
        template: '<div></div>',
        scope: {
            date: '=',
            amount: '=',
            adscost: '=',
            profit: '=',
            cost: '=',
            rtfee: '=',
            ocost: '=',
        },
        link: function (scope, element) {
            var chart = null;
            var process = function() {
                var width = $('.highcharts-figure').width();
                var height = $('.highcharts-figure').height();
                Highcharts.setOptions({
                    lang: {
                        thousandsSep: ','
                    }
                });
                chart = Highcharts.chart(element[0], {
                    chart: {
                        type: 'spline',
                        zoomType: 'xy',
                        width: width,
                        height: height
                    },
                    title: {
                        text: 'Biểu đồ lợi nhuận theo ngày'
                    },
                
                    subtitle: {
                        text: 'Source: Printerval.com'
                    },
                    credits: {
                        enabled: false,
                    },
                    yAxis: [
                        {
                            allowDecimals: false,
                            title: {
                                text: 'Doanh thu, Giá vốn, Chi phí QC (USD)'
                            },
                            visible: true,
                        }, {
                            allowDecimals: false,
                            title: {
                                text: 'Lợi Nhuận, Tiền Hàng trả lại, Chi phí thẻ (USD)'
                            },
                            opposite: true,
                            visible: true
                        }
                    ],
                
                    xAxis: {
                        categories: scope.date,
                        accessibility: {
                            rangeDescription: 'Range: 2010 to 2017'
                        }
                    },
                
                    legend: {
                        align: 'left',
                        verticalAlign: 'top',
                        borderWidth: 0,
                    },

                    tooltip: {
                        shared: true,
                        crosshairs: true
                    },

                    plotOptions: {
                        series: {
                            cursor: 'pointer',
                            marker: {
                                lineWidth: 1
                            }
                        }
                    },

                    series: [{
                        name: 'Doanh thu',
                        data: scope.amount,
                        color: '#90ed7d',
                        yAxis: 0,
                    }, {
                        name: 'Lợi nhuận',
                        data: scope.profit,
                        color: '#f7a35c',
                        yAxis: 1,
                    }, {
                        name: 'Giá vốn',
                        data: scope.cost,
                        color: '#f45b5b',
                        yAxis: 0,
                    }, {
                        name: 'Chi phí quảng cáo',
                        data: scope.adscost,
                        color: '#434348',
                        yAxis: 0,
                    }, {
                        name: 'Hàng trả lại',
                        data: scope.rtfee,
                        color: '#0000FF',
                        yAxis: 1,
                    }, {
                        name: 'Chi phí thẻ',
                        data: scope.ocost,
                        color: '#AACCFF',
                        yAxis: 1,
                    }],
                
                    responsive: {
                        rules: [{
                            condition: {
                                maxWidth: 500
                            },
                            chartOptions: {
                                legend: {
                                    layout: 'horizontal',
                                    align: 'center',
                                    verticalAlign: 'bottom'
                                }
                            }
                        }]
                    }
                });
            }
            scope.$watch("date", function () {
                process();
            });
        }
    };
})
function FinancialStatementController($rootScope, $scope, $http, Upload) {
    $scope.filters = {};
    $scope.items = [];
    $scope.ajaxFindRequest = null;
    $scope.dataLastMonth = {};
    $scope.data = {};
    $scope.dates = [];
    $scope.amounts = [];
    $scope.profits = [];
    $scope.costs = [];
    $scope.adsCosts = [];
    $scope.returnFees = [];
    $scope.otherCost = [];
    $scope.newFinancialStatement = {};
    $scope.ratio = 0;

    $scope.currencies = [
        {
            "key": "USD",
            "value": "US Dollar",
        },
        {
            "key": "VND",
            "value": "Việt Nam Đồng"
        }
    ];

    this.initialize = async function () {
        $("#date-chart-from").datepicker({
            dateFormat: "yy-mm-dd",
        }).datepicker("setDate", "-4w");

        $("#date-chart-to").datepicker({
            dateFormat: "yy-mm-dd",
        }).datepicker("setDate", "+0");

        var today = new Date();
        var lastDayOfMonth = new Date(today.getFullYear(), today.getMonth()+1, 0);
        $("#date-to").datepicker({
            dateFormat: "yy-mm-dd",
        }).datepicker("setDate", lastDayOfMonth);

        $scope.currencyRatio = 1;
        $scope.currency = JSON.parse(localStorage.getItem("currency"));
        $scope.currencyText = "USD";
        if ($scope.currency && $scope.currency.ratio) {
            $scope.currencyRatio = $scope.currency.ratio;
            $scope.ratio = $scope.currency.ratio;
            $scope.currencyText = $scope.currency.key;
        }
        await $scope.find();
        await $scope.getProfitData();
    };

    $scope.find = function () {
        var dateTo = $("#date-to").val();
        if (!dateTo || dateTo == '') {
            toastr.error('Mời chọn ngày kết thúc Thống kê.');
            return;
        }
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);
        let filter = buildFilter(dateTo);
        $scope.currentDate = (dateTo.getMonth() + 1) + "/" + dateTo.getFullYear();
        const month = dateTo.getMonth();
        dateTo.setMonth(dateTo.getMonth() - 1);
        while (dateTo.getMonth() === month) {
            dateTo.setDate(dateTo.getDate() - 1);
        }
        $scope.lastMonthDate = (dateTo.getMonth() + 1) + "/" + dateTo.getFullYear();

        $scope.isShowHideLoading(true);
        $scope.ajaxFindRequest = $http.get("financial-statement/find" + filter).then(function (response) {
            $scope.isSaving = false;

            if (response.data.status === "successful") {
                $scope.data = response.data.data;
                $scope.data.net_revenue = (parseFloat($scope.data.revenue) - parseFloat($scope.data.return_amount)).toFixed(2);
                $scope.data.profit = ($scope.data.net_revenue - $scope.data.cost_price - $scope.data.cost).toFixed(2);
                $scope.dataLastMonth = response.data.last_month;
                $scope.dataLastMonth.net_revenue = (parseFloat($scope.dataLastMonth.revenue) - parseFloat($scope.dataLastMonth.return_amount)).toFixed(2);
                $scope.dataLastMonth.profit = ($scope.dataLastMonth.net_revenue - $scope.dataLastMonth.cost_price - $scope.dataLastMonth.cost).toFixed(2);
                $scope.isShowHideLoading(false);
            }
        });
    };

    $scope.getProfitData = () => {
        var dateFrom = $("#date-chart-from").val();
        var dateTo = $("#date-chart-to").val();
        if (!dateFrom || dateFrom == '') {
            toastr.error('Mời chọn ngày bắt đầu Thống kê.');
            return;
        }
        if (!dateTo || dateTo == '') {
            toastr.error('Mời chọn ngày kết thúc Thống kê.');
            return;
        }
        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);

        if (dateFrom.getTime() >= dateTo.getTime()) {
            toastr.error('Ngày Bắt đầu thống kê phải nhỏ hơn ngày Kết thúc.');
            return;
        }
        $scope.isShowHideLoading(true);
        $scope.ajaxFindRequest = $http.get("financial-statement/get-data-profit" + buildFilterProfit(dateFrom, dateTo)).then(function (response) {
            $scope.isSaving = false;
            if (response.data.status === "successful") {
                let dataDates = [];
                $scope.dates = [];
                $scope.amounts = [];
                $scope.profits = [];
                $scope.costs = [];
                $scope.adsCosts = [];
                $scope.returnFees = [];
                $scope.otherCost = [];
                $scope.profitData = response.data.result;
                $scope.profitData.forEach(element => {
                    dataDates.push(element.date);
                    $scope.amounts.push(Math.round(element.data.revenue * 100) / 100);
                    $scope.adsCosts.push(Math.round(element.data.ads_cost * 100) / 100);
                    $scope.costs.push(Math.round(element.data.cost_price * 100) / 100);
                    $scope.returnFees.push(Math.round(element.data.return_amount * 100) / 100);
                    $scope.otherCost.push(Math.round(element.data.other_cost * 100) / 100);
                    let profit = (element.data.revenue - element.data.return_amount - element.data.cost_price - element.data.cost).toFixed(2);
                    $scope.profits.push(parseFloat(profit));
                });
                $scope.dates = dataDates;
            }
        });
    }

    function buildFilter(dateTo) {
        let result = "";
        result += "?month=" + (dateTo.getMonth() + 1) + "&year=" + dateTo.getFullYear() + "&date=" + dateTo.getDate();
        return result;
    }

    function buildFilterProfit(dateFrom, dateTo) {
        let result = "";
        let dateToday = dateTo.getDate() + '/' + (dateTo.getMonth() + 1) + "/" + dateTo.getFullYear();
        let dateLastMonth = dateFrom.getDate() + '/' + (dateFrom.getMonth() + 1) + "/" + dateFrom.getFullYear();
        result += "?start=" + dateLastMonth + "&end=" + dateToday;
        return result;
    }

    $scope.isShowHideLoading = function (val) {
        $scope.isShowLoading = val;
    };

    $scope.moneyToString = function (price) {
        if (price == null || price.toString().match(/^\-?[0-9]+(\.[0-9]+)?$/) == null) {
            return "NA";
        }
        return price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
    };

    $scope.summarizeDate = function (dateTime, withYear) {
        if (dateTime != null) {
            var outputFormat = "$3/$2";
            if (withYear) {
                outputFormat += "/$1";
            }
            return dateTime.replace(/(\d{4})-(\d{2})-(\d{2})\s+(\d{1,2}):(\d{1,2}):.*/, outputFormat);
        }
    };

    $scope.formatCurrency = function(price, desSep = ',', groupSep = '.', number = 0) {
        if (price != parseFloat(price)) {
            price = 0;
        }
        var newstr = '';
        price = parseFloat(price);
        let isNegative = false;
        if (price < 0) {
            isNegative = true;
            price = Math.abs(price);
        }
        price = price * $scope.currencyRatio;
        var p = price.toFixed(number).split(".");
        var chars = p[0].split("").reverse();
        var count = 0;
        for (x in chars) {
            count++;
            if (count % 3 == 1 && count != 1) {
                newstr = chars[x] + groupSep + newstr;
            } else {
                newstr = chars[x] + newstr;
            }
        }

        if (p.length > 1) {
            newstr += desSep + p[1];
        } else if (number > 0) {
            newstr += desSep;
            for (let i = 0; i < number; i++) {
                newstr += '0';
            }
        }
        if (isNegative) {
            newstr = "(" + newstr + ")";
        }

        return newstr;
    }

    $scope.openForm = () => {
        $scope.newFinancialStatement = {};
        $("#date-new-data").datepicker({
            dateFormat: "yy-mm",
        }).datepicker("setDate", "+0");
        $("#modalImport").modal('toggle');
    }

    $scope.saveData = () => {
        $scope.isSaving = true;
        $scope.isShowHideLoading(true);
        var date = $("#date-new-data").val();
        date = new Date(date);
        date.setHours(0, 0, 0, 0);
        $scope.newFinancialStatement.month = date.getMonth() + 1;
        $scope.newFinancialStatement.year = date.getFullYear();
        $scope.ajaxFindRequest = $http.post("/financial-statement/save", $scope.newFinancialStatement).then(function (response) {
            $scope.isSaving = false;
            if (response.data.status === "successful") {
                toastr.success('Lưu dữ liệu thành công!');
                $scope.isShowHideLoading(false);
                $("#modalImport").modal('toggle');
            } else {
                toastr.error('Có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật!');
                $scope.isShowHideLoading(false);
            }
        });
    }

    $scope.openFormChangeCurrency = () => {
        $("#modalChangeCurrency").modal('toggle');
    }

    $scope.saveChangeCurrency = () => {
        if (!$scope.ratio || $scope.ratio < 0) {
            toastr.error('Vui lòng nhập tỉ giá!');
            return;
        }
        $scope.currency.ratio = $scope.ratio;
        $scope.currencyRatio = $scope.ratio;
        localStorage.setItem('currency', JSON.stringify($scope.currency));
        $("#modalChangeCurrency").modal('toggle');
    }

    this.initialize();
}
