system.controller("ReportBusinessController", ReportBusinessController);

function ReportBusinessController($rootScope, $scope, $http, Upload) {
    $scope.currencyText = 'VND';
    $scope.filter = {
        date: '',
        date_from: '',
        date_to: '',
        // currency: 'VND'
    };

    $scope.dataLastMonth = {
        revenue : 0,
        net_revenue : 0,
        refund : 0,
        product_cost : 0,
        additional_cost : 0,
        gross_profit : 0,
        total_cost : 0,
        ads_cost : 0,
        additional_ads_cost : 0,
        other_cost: {
            technical_costs : 0 ,
            office_costs : 0 ,
            organizational_costs : 0 ,
            officeRent_costs : 0 ,
            tools_costs : 0 ,
            salary_costs : 0 ,
            insurance_costs : 0 ,
            bonus_costs : 0 ,
            other_management_costs : 0 ,
            other_costs: 0 ,
        },
        other_profit : 0,
        profit : 0
    };
    $scope.data = {
        revenue : 0,
        net_revenue : 0,
        refund : 0,
        product_cost : 0,
        additional_cost : 0,
        gross_profit : 0,
        total_cost : 0,
        ads_cost : 0,
        additional_ads_cost : 0,
        other_cost: {
            technical_costs : 0 ,
            office_costs : 0 ,
            organizational_costs : 0 ,
            officeRent_costs : 0 ,
            tools_costs : 0 ,
            salary_costs : 0 ,
            insurance_costs : 0 ,
            bonus_costs : 0 ,
            other_management_costs : 0 ,
            other_costs: 0 ,
        },
        other_profit : 0,
        profit : 0
    };

    $scope.percentTotalCapitalCostLastMonth = 0.465;

    $scope.isLoading = false;

    this.initialize = async function () {
        $scope.isLoading = true;
        await $scope.find();
        $scope.isLoading = false;
        let loading = $scope.isLoading;
        $scope.$apply(() => { 
            $scope.isLoading = loading; 
        });

    };

    $scope.find = async function () {
        await getLastMonthDataNew();
        await getCurrentMonthDataNew();
    };

    $scope.reset = () => {
        $scope.filter = {
            date: '',
            date_from: '',
            date_to: '',
            date_from_last_month: '',
            date_to_last_month: '',
        };
        $scope.dataLastMonth = {};
        $scope.data = {};
        $scope.find();
    }

    function getLastMonthData() {
        let url = 'https://api.printerval.com/report/business?exchange_country=VND&date_from=2023-08-01&date_to=2023-08-31';
        $http.get(url).then(function (response) {
            if (response.data.status === "successful") {
                $scope.dataLastMonth = response.data.result;
                $scope.dataLastMonth.profit = $scope.dataLastMonth.gross_profit - $scope.dataLastMonth.total_cost
                $scope.dataLastMonth.month = 8;
                $scope.isShowHideLoading(false);
            }
        });
    }

    function getCurrentMonthData() {
        var today = new Date();
        let url = 'https://api.printerval.com/report/business?exchange_country=VND&date_from=2023-09-01&date_to=2023-09-' + today.getDate();
                //    https://api.printerval.com/report/business?date_from=2023-08-01&date_to=2023-08-31&exchange_country=VND
        $http.get(url).then(function (response) {
            if (response.data.status === "successful") {
                $scope.data = response.data.result;
                $scope.data.profit = $scope.data.gross_profit - $scope.data.total_cost
                $scope.data.month = 9;
            }
        });
    }

    async function getLastMonthDataNew(){
        const isLastMonth = true;
        await getRevenueAndRefundAndPaymentGatewayFeesUSRegion(isLastMonth);
        await getRevenueAndRefundAndPaymentGatewayFeesOtherRegion(isLastMonth);
        await getCost(isLastMonth);
        await getOtherCost(isLastMonth);
        
        calculateDataInput($scope.dataLastMonth);

        if($scope.dataLastMonth.additional_cost == 0) {
            $scope.calculateAdditionalCost($scope.dataLastMonth);
        }

    }

    async function getCurrentMonthDataNew(){
        $scope.data.total_cost = 0;
        const isLastMonth = false;
        await getRevenueAndRefundAndPaymentGatewayFeesUSRegion(isLastMonth);
        await getRevenueAndRefundAndPaymentGatewayFeesOtherRegion(isLastMonth);
        await getCost(isLastMonth);
        await getOtherCost(isLastMonth);
        
        $scope.data.net_revenue = calculateNetRevenue($scope.data);
        $scope.data.total_cost = calculateTotalCost($scope.data);
        $scope.calculateAdditionalCost($scope.data);
        $scope.data.profit = calculateProfit($scope.data);
        // $scope.data.gross_profit = $scope.formatCurrency(calculateGrossProfit($scope.data, ".", ",", 2));
        let data = $scope.data;
        $scope.$apply(() => { 
            $scope.data = data; 
        });
    }
    
    $scope.calculateProfit = (isLastMonth) => {
        let retVal = 0;
        if (isLastMonth) {
            retVal = calculateProfit($scope.dataLastMonth);
        } else {
            retVal = calculateProfit($scope.data);
        }

        return $scope.formatCurrency(retVal, ".", ",", 2);
    }
    
    function calculateNetRevenue(data) {
        return parseFloat(data.revenue) + parseFloat(data.refund);
    }
    function calculateGrossProfit(data) {
        return (data.revenue + data.refund) - data.product_cost - parseValue(data.additional_cost);
    }
    function calculateProfit(data) {
        return calculateGrossProfit(data) - calculateTotalCost(data) + parseValue(data.other_profit);
    }
    function calculateTotalCost(data) {
        let retVal = 0;
        if(data.other_cost && data.payment_fee) {
            retVal = parseFloat(data.ads_cost )+
                    parseFloat(data.other_cost.bonus_costs )+
                    parseFloat(data.other_cost.insurance_costs )+
                    parseFloat(data.other_cost.officeRent_costs )+
                    parseFloat(data.other_cost.office_costs )+
                    parseFloat(data.other_cost.organizational_costs )+
                    parseFloat(data.other_cost.other_management_costs )+
                    parseFloat(data.other_cost.salary_costs )+
                    parseFloat(data.other_cost.technical_costs )+
                    parseFloat(data.other_cost.tools_costs )+
                    parseValue(data.other_cost.other_costs )+
                    parseValue(data.additional_ads_cost )+
                    parseFloat(data.payment_fee);
                    
        }
        return retVal;
    }

    function formatDefaultValue (value) {
        return new Intl.NumberFormat('en-US').format(value);
    };

    $scope.calculateAdditionalCostCurrentMonth = () => {
        let totalCapitalCostLastMonth = parseValue($scope.dataLastMonth.product_cost) + parseValue($scope.dataLastMonth.additional_cost);
        totalCapitalCostLastMonth = totalCapitalCostLastMonth == 0 ? 1 : totalCapitalCostLastMonth;
        const totalCapitalCostCurrentMonth = parseValue($scope.data.revenue) * $scope.percentTotalCapitalCostLastMonth;
        $scope.data.additional_cost = formatDefaultValue((totalCapitalCostCurrentMonth - parseValue($scope.data.product_cost)).toFixed(0));
        calculateDataInput($scope.data);
    }
    
    $scope.calculateAdditionalCost = (data) => {
        const totalCapitalCostCurrentMonth = parseValue(data.revenue) * $scope.percentTotalCapitalCostLastMonth;
        data.additional_cost = formatDefaultValue((totalCapitalCostCurrentMonth - parseValue(data.product_cost)).toFixed(0));
        calculateDataInput(data);
    }

    function calculateDataInput(data) {
        data.net_revenue = calculateNetRevenue(data);
        data.gross_profit = calculateGrossProfit(data);
        data.total_cost = calculateTotalCost(data);
        data.profit = calculateProfit(data);
    }

    $scope.onAdditionalCostChange = () => {
        calculateDataInput($scope.data);
    }

    function parseValue(value){
        let retVal = 0;
        if(typeof value == 'string') {
            if(value == '' || value == undefined) {
                retVal = 0;
            }
            if(value.includes(',')) {
                retVal = parseFloat(value.replaceAll(',',''));
            } else {
                retVal = parseFloat(value);
            }
        } else if(typeof value == 'number') {
            retVal = value;
        }
        
        return isNaN(retVal) ? 0 : retVal;
    }

    $scope.updateTotalCost = (isLastMonth) => {
        let dataScope = isLastMonth ? $scope.dataLastMonth : $scope.data;

        dataScope.cost = calculateTotalCost(dataScope);
        dataScope.net_revenue = calculateNetRevenue(dataScope);
        dataScope.gross_profit = calculateGrossProfit(dataScope);
        dataScope.total_cost = calculateTotalCost(dataScope);
        dataScope.profit = calculateProfit(dataScope);
    }


    async function getRevenueAndRefundAndPaymentGatewayFeesUSRegion(isLastMonth) {
        let url = 'https://printerval.com/financial-statement/payment/stripe/get-report';
        // let url = 'http://zicbee.test/financial-statement/payment/stripe/get-report';
        url = await buildParams(url, isLastMonth);
        const response = await $http.get(url);
        if(response.data.status == 'successful') {
            const data = response.data.result;
            let dataScope = isLastMonth ? $scope.dataLastMonth : $scope.data;

            dataScope.revenue = (dataScope.revenue ?? 0) + data.revenue;
            dataScope.refund = (dataScope.refund ?? 0) + data.refund;
            dataScope.payment_fee = (dataScope.payment_fee ?? 0) + data.payment_fee;
            dataScope.revenue_payment_gateway = (dataScope.revenue_payment_gateway ?? 0) + data.revenue_payment_gateway;
        }
    }

    async function getRevenueAndRefundAndPaymentGatewayFeesOtherRegion(isLastMonth) {
        let url = 'https://printerval.com/financial-statement/payment/paypal/get-report';
        // let url = 'http://zicbee.test/financial-statement/payment/paypal/get-report';
        url = await buildParams(url, isLastMonth);
        const response = await $http.get(url)
        if(response.data.status == 'successful') {
            let dataScope = isLastMonth ? $scope.dataLastMonth : $scope.data;
            dataScope.revenue = (dataScope.revenue ?? 0) + response.data.result.revenue;
            dataScope.refund = (dataScope.refund ?? 0) + response.data.result.refund;
            dataScope.payment_fee = (dataScope.payment_fee ?? 0) + response.data.result.payment_fee;
            dataScope.revenue_payment_gateway = (dataScope.revenue_payment_gateway ?? 0) + response.data.result.revenue_payment_gateway;
        }
    }

    async function getCost(isLastMonth){
        let url = 'https://printerval.com/print-suppliers/report/cost';
        // let url = 'http://zicbee.test/print-suppliers/report/cost';
        url = await buildParams(url, isLastMonth);
        const response = await $http.get(url)
            
        if(response.data.status == 'successful' || response.data.status == 'sucessful') {
            const data = response.data.result; 
            let dataScope = isLastMonth ? $scope.dataLastMonth : $scope.data;

            dataScope.product_cost = (dataScope.product_cost ?? 0) + data.total;
            dataScope.additional_ads_cost = formatDefaultValue((dataScope.additional_ads_cost ?? 0) + data.additional_ads_cost);

            if (isLastMonth) {
                dataScope.additional_cost = formatDefaultValue((dataScope.additional_cost ?? 0) + data.additional_cost);
            }
        }
    }

    async function getOtherCost(isLastMonth) {
        let url = 'https://api.printerval.com/report/business';
        url = await buildParams(url, isLastMonth) + '&exchange_country=VND';
        const response = await $http.get(url);
        if(response.data.status == 'successful') {
            const data = response.data.result; 
            
            let dataScope = isLastMonth ? $scope.dataLastMonth : $scope.data;

            dataScope.ads_cost = (dataScope.ads_cost ?? 0) + data.ads_cost;
            dataScope.other_cost.bonus_costs = (dataScope.other_cost.bonus_costs ?? 0) + data.other_cost.bonus_costs;
            dataScope.other_cost.insurance_costs = (dataScope.other_cost.insurance_costs ?? 0) + data.other_cost.insurance_costs;
            dataScope.other_cost.officeRent_costs = (dataScope.other_cost.officeRent_costs ?? 0) + data.other_cost.officeRent_costs;
            dataScope.other_cost.office_costs = (dataScope.other_cost.office_costs ?? 0) + data.other_cost.office_costs;
            dataScope.other_cost.organizational_costs = (dataScope.other_cost.organizational_costs ?? 0) + data.other_cost.organizational_costs;
            dataScope.other_cost.other_management_costs = (dataScope.other_cost.other_management_costs ?? 0) + data.other_cost.other_management_costs;
            dataScope.other_cost.salary_costs = (dataScope.other_cost.salary_costs ?? 0) + data.other_cost.salary_costs;
            dataScope.other_cost.technical_costs = (dataScope.other_cost.technical_costs ?? 0) + data.other_cost.technical_costs;
            dataScope.other_cost.tools_costs = (dataScope.other_cost.tools_costs ?? 0) + data.other_cost.tools_costs;
            dataScope.other_cost.other_costs = 0;
            dataScope.cost = dataScope.ads_cost +
                            dataScope.other_cost.bonus_costs +
                            dataScope.other_cost.insurance_costs +
                            dataScope.other_cost.officeRent_costs +
                            dataScope.other_cost.office_costs +
                            dataScope.other_cost.organizational_costs +
                            dataScope.other_cost.other_management_costs +
                            dataScope.other_cost.salary_costs +
                            dataScope.other_cost.technical_costs +
                            dataScope.other_cost.tools_costs +
                            dataScope.other_cost.other_costs;
        }
    }

    async function buildParams(url, isLastMonth) {
        let arrayParam = [];
        await initFilterDate(isLastMonth);
        for (const key in $scope.filter) {
            if (isLastMonth) {
                if (key == 'date_from_last_month' || key == 'date_to_last_month') {
                    if(key == 'date_from_last_month') {
                        arrayParam.push(`date_from=${$scope.filter[key]}`);
                    }
                    if(key == 'date_to_last_month') {
                        arrayParam.push(`date_to=${$scope.filter[key]}`);
                    }
                }
            } else {
                if (key == 'date_from' || key == 'date_to') {
                    arrayParam.push(`${key}=${$scope.filter[key]}`);
                }
            }
        }

        return `${url}?${arrayParam.join('&')}`;
    }

    async function initFilterDate (isLastMonth) {
        let date = '';
        if($scope.filter.date == '') {
            date = new Date();
            if (isLastMonth) {
                date.setDate(1)
                date.setMonth(date.getMonth() - 1)
                date = new Date(date);
                $scope.dataLastMonth.month = (new Date(new Date(date.getFullYear(), date.getMonth(), 1))).getMonth() + 1;
                $scope.filter.date_from_last_month = formatDate(new Date(date.getFullYear(), date.getMonth(), 1));
                $scope.filter.date_to_last_month = formatDate(new Date(date.getFullYear(), date.getMonth() + 1, 0));
            } else {
                $scope.data.month = date.getMonth() + 1;
                $scope.filter.date_from = formatDate(new Date(date.getFullYear(), date.getMonth(), 1));
                $scope.filter.date_to = formatDate(new Date(date.getFullYear(), date.getMonth(), date.getDate()));
            }
        } else {
            date = getDate($scope.filter.date);
            if (isLastMonth) {
                date = new Date(date.setMonth(date.getMonth() - 1));
                $scope.dataLastMonth.month = (new Date(new Date(date.getFullYear(), date.getMonth(), 1))).getMonth() + 1;
                $scope.filter.date_from_last_month = formatDate(new Date(date.getFullYear(), date.getMonth(), 1));
                $scope.filter.date_to_last_month = formatDate(new Date(date.getFullYear(), date.getMonth() + 1, 0));
            } else {
                $scope.data.month = date.getMonth();
                $scope.filter.date_from = formatDate(new Date(date.getFullYear(), date.getMonth(), 1));
                $scope.filter.date_to = formatDate(new Date(date.getFullYear(), date.getMonth() + 1, 0));
            }
        }
    }

    function getDate(date) {
        var parts = date.split("/");
        var day = parseInt(parts[0], 10);
        var month = parseInt(parts[1], 10) - 1;
        var year = parseInt(parts[2], 10);

        return new Date(year, month, day);
    }

    function formatDate(date) {
        const originalDate = new Date(date);

        const day = originalDate.getDate();
        const month = originalDate.getMonth() + 1;
        const year = originalDate.getFullYear();

        return `${year}-${month}-${day}`;
    }

    $scope.formatCurrency = function(price, desSep = ',', groupSep = '.', number = 0) {
        if (!price && typeof price != 'number') {
            return null;
        }
        var newstr = '';
        price = parseFloat(price);
        let isNegative = false;

        var p = price.toFixed(number).split(".");
        var chars = p[0].split("").reverse();
        var count = 0;
        for (x in chars) {
            count++;
            if (count % 3 == 1 && count != 1) {
              newstr = chars[x] + (chars[x] != '-' ? groupSep : '') + newstr;
            } else {
                newstr = chars[x] + newstr;
            }
        }

        if (p.length > 1) {
            newstr += desSep + p[1];
        } else if (number > 0) {
            newstr += desSep;
            for (let i = 0; i < number; i++) {
                newstr += '0';
            }
        }
        if (isNegative) {
            newstr = "(" + newstr + ")";
        }

        return newstr;
    }



    $scope.isShowHideLoading = function (val) {
        $scope.isShowLoading = val;
    };

    this.initialize();
}

system.directive('autoFormat', function () {
    return {
        restrict: 'A',
        link: function (scope, element, attrs) {
            var formatInput = function () {
                var value = $(element).val().replace(/\D/g, '');
                if (!isNaN(value)) {
                    var formattedValue = Number(value).toLocaleString('en');
                    $(element).val(formattedValue);
                }
            };

            // Format the value when the input is rendered
            let totalComma;

            $(element).on('input', function () {
                var caretPos = $(element)[0].selectionStart;
                let sub = 0;
                formatInput();
                if(totalComma != ($(element).val().match(/,/g) || []).length) {
                    if(totalComma > ($(element).val().match(/,/g) || []).length) {
                        sub = -1;
                    } else if (totalComma < ($(element).val().match(/,/g) || []).length){
                        sub = 1;
                    }
                    totalComma = ($(element).val().match(/,/g) || []).length;
                }

                caretPos = caretPos + sub;
                // Restore caret position

                if (parseInt($(element).val()) == 0) {
                    caretPos = 1;
                }
                
                $(element)[0].setSelectionRange(caretPos, caretPos);
            });
        }
    };
});
