@extends('system.layout.main', [
    'ngController' => 'FinancialStatementController'
])
@section('title')
<title>Báo cáo tài chính</title>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="body">
        <div class="box no-border">
            <div class="box-header with-border">
                <h3 class="box-title">Báo cáo tài chính</h3>
                <form class="form-inline flex-box align-c" style="margin-top: 20px">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon">Đến <span class="hidden-xs">ngày</span></span>
                            <input type="text" class="form-control" id="date-to" placeholder="yyyy-mm-dd" />
                        </div>
                    </div>
                    
                    <div class="form-group text-center">
                        <button type="button" class="btn btn-primary" ng-click="find()">Xem thống kê</button>
                    </div>
                    <button type="button" class="btn btn-success" style="margin-left: auto;" ng-click="openFormChangeCurrency()">Quy đổi tiền tệ</button>
                    <button type="button" class="btn btn-success" style="margin-left: 5px;" ng-click="openForm()">Nhập dữ liệu</button>
                </form>
            </div>
            <div class="box-body">
                <table class="table table-hover">
                    <thead class="redirect-head">
                        <tr>
                            <th class="width: 30%">#</th>
                            <th style="width: 30%; text-align: center;">Tháng @{{ lastMonthDate }} (@{{ currencyText }})</th>
                            <th style="width: 30%; text-align: center;">Tháng @{{ currentDate }} (@{{ currencyText }})</th>
                        </tr>
                    </thead>
                    <tbody class="table-body">
                        <tr>
                            <td class="header-title">Doanh thu</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.revenue, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.revenue, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td class="header-title">Hàng trả lại (Tiền nhà in hoàn lại)</td>
                            <td class="price">
                                @{{ formatCurrency(dataLastMonth.return_amount, ".", ",", 2) }}
                                <span ng-show="dataLastMonth.print_refund > 0">
                                    (@{{ formatCurrency(dataLastMonth.print_refund, ".", ",", 2) }})
                                </span>
                            </td>
                            <td class="price">
                                @{{ formatCurrency(data.return_amount, ".", ",", 2) }}
                                <span ng-show="data.print_refund > 0">
                                    (@{{ formatCurrency(data.print_refund, ".", ",", 2) }})
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td class="header-title">Doanh thu thuần</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.net_revenue, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.net_revenue, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td class="header-title">Giá vốn</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.cost_price, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.cost_price, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td class="header-title">Lợi nhuận gộp</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.net_revenue - dataLastMonth.cost_price, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.net_revenue - data.cost_price, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td class="header-title">Chi phí</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.cost, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí quảng cáo</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.ads_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.ads_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí thuê thiết kế 3D</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.design_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.design_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí hệ thống, quảng cáo khác</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.other_ads_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.other_ads_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí bán hàng khác</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.sale_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.sale_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí văn phòng</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.office_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.office_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí tổ chức</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.organization_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.organization_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí thuê văn phòng</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.rent_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.rent_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí khấu hao dụng cụ công cụ</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.tool_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.tool_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí lương</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.salary_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.salary_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí bảo hiểm</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.insurance_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.insurance_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí quản lý khác</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.management_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.management_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí khác - Chi phí thẻ (Chi phí tranh chấp)</td>
                            <td class="price">
                                @{{ formatCurrency(dataLastMonth.other_cost, ".", ",", 2) }}
                                <span ng-show="dataLastMonth.dispute_fee > 0">
                                    (@{{ formatCurrency(dataLastMonth.dispute_fee, ".", ",", 2) }})
                                </span>
                            </td>
                            <td class="price">
                                @{{ formatCurrency(data.other_cost, ".", ",", 2) }}
                                <span ng-show="data.dispute_fee > 0">
                                    (@{{ formatCurrency(data.dispute_fee, ".", ",", 2) }})
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td class="header-title">Lợi nhuận (Chưa có chi phí amazon, chi phí kỹ thuật)</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.profit, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.profit, ".", ",", 2) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="box no-border">
            <div class="box-header with-border">
                <h3 class="box-title">Báo cáo tài chính theo ngày</h3>

                <form class="form-inline" style="margin-top: 20px">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon">Từ <span class="hidden-xs">ngày</span></span>
                            <input type="text" class="form-control" id="date-chart-from" placeholder="yyyy-mm-dd" />
                            <span class="input-group-addon">đến <span class="hidden-xs">ngày</span></span>
                            <input type="text" class="form-control" id="date-chart-to" placeholder="yyyy-mm-dd" />
                        </div>
                    </div>
                    
                    <div class="form-group text-center">
                        <button type="button" class="btn btn-primary" ng-click="getProfitData()">Xem thống kê</button>
                    </div>
                </form>
            </div>
            <div class="box-body">
                <figure class="highcharts-figure">
                    <chart-financial-statement
                        style="position: relative"
                        date="dates"
                        amount="amounts"
                        adscost="adsCosts"
                        profit="profits"
                        cost="costs"
                        rtfee="returnFees"
                        ocost="otherCost"
                    ></chart-financial-statement>
                </figure>
            </div>
        </div>
    </div>
    @include('financial-statement::financial-statement.modal-import')
    @include('financial-statement::financial-statement.modal-change-currency')
</div>
@endsection

@section('script')
<script src="/modules/financial-statement/js/financialStatement.module.controller.js?v=<?= time() ?>"></script>
<script src="//code.highcharts.com/highcharts.js"></script>
<script src="//code.highcharts.com/modules/series-label.js"></script>
<script src="//code.highcharts.com/modules/exporting.js"></script>
<script src="//code.highcharts.com/modules/export-data.js"></script>
<script src="//code.highcharts.com/modules/accessibility.js"></script>
@endsection
@section('css')
<style>
    .btn-upload-image {
        border: 1px solid #d3d3d39c;
        padding: 7px;
        display: inline-block;
        border-radius: 5px;
        font-size: 13px;
        background-color: #f0f0f08c;
        cursor: pointer;
        vertical-align: top;
    }
    .chosen-container.chosen-container-single {
        width: 100% !important; /* or any value that fits your needs */
    }
    .header-title {
        font-weight: bold;
    }
    .table-body {
        font-size: 14px;
    }
    .price {
        text-align: right;
    }
    .bold-text {
        font-weight: bold;
        font-size: 16px;
    }
</style>
@endsection