@extends('system.layout.main', [
    'ngController' => 'ReportBusinessController'
])

@section('css')
    @parent
    <link rel="stylesheet"
        href="{{ Module::asset('financial-statement/css/report-business/index.css') . '?v=' . Config::get('sa.version') }}">
@endsection

@section('title')
<title>Báo cáo kinh doanh</title>
@endsection
@section('content')
<div class="content report-business-page" ng-cloak>
    <div class="body">
        <div class="box no-border">
            <div class="box-header with-border">
                <h3 class="box-title">Báo cáo kinh doanh</h3>
                {{-- <form class="form-inline flex-box align-c" style="margin-top: 20px">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon">Chọn <span class="hidden-xs">ngày</span></span>
                            <input
                            type="text"
                            class="form-control"
                            ng-model="filter.date"
                            my-date-picker
                            placeholder="yyyy-mm-dd"
                        >
                        </div>
                    </div>
                    
                    <div class="form-group text-center ml-2">
                        <button type="button" class="btn btn-primary" ng-click="find()">Xem thống kê</button>
                        <button type="button" class="btn btn-danger" ng-click="reset()">Xóa</button>
                    </div>
                </form> --}}
            </div>
            <div class="box-body">
                <div class="loading-box" ng-if="isLoading">
                    <div class="lds-dual-ring"></div>
                </div>
                <table class="table table-hover">
                    <thead class="redirect-head">
                        <tr>
                            <th class="width: 30%">#</th>
                            <th style="width: 30%; text-align: center;">Tháng @{{  dataLastMonth.month  }} (@{{ currencyText }})</th>
                            <th style="width: 30%; text-align: center;">Tháng @{{ data.month }} (@{{ currencyText }})</th>
                        </tr>
                    </thead>
                    <tbody class="table-body">
                        <tr>
                            <td class="header-title">Doanh thu cổng thanh toán</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.revenue_payment_gateway, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.revenue_payment_gateway, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td class="header-title">Doanh thu</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.revenue, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.revenue, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td class="header-title">Hàng trả lại</td>
                            <td class="price">
                                @{{ formatCurrency(dataLastMonth.refund, ".", ",", 2) }}
                            </td>
                            <td class="price">
                                @{{ formatCurrency(data.refund, ".", ",", 2) }}
                            </td>
                        </tr>
                        <tr>
                            <td class="header-title">Doanh thu thuần</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.net_revenue, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.net_revenue, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td class="header-title">Giá vốn</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.product_cost, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.product_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td class="header-title">Giá vốn bổ sung</td>
                            <td class="price bold-text">
                                <input type="text" ng-model="dataLastMonth.additional_cost" ng-change="updateTotalCost({{ true }})" class="form-group input" auto-format>
                            </td>
                            <td class="price bold-text">
                                <input type="text" ng-model="data.additional_cost" ng-change="onAdditionalCostChange()"  class="form-group input" auto-format>
                            </td>
                        </tr>
                        <tr>
                            <td class="header-title">Lợi nhuận gộp</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.gross_profit, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.gross_profit, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td class="header-title">Chi phí</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.total_cost, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.total_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí quảng cáo (adwords, bing)</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.ads_cost, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.ads_cost, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí quảng cáo khác</td>
                            <td class="price">
                                <input type="text" ng-model="dataLastMonth.additional_ads_cost" ng-change="updateTotalCost({{ true }})" class="form-group input" auto-format>
                            </td>
                            <td class="price">
                                <input type="text" ng-model="data.additional_ads_cost" ng-change="updateTotalCost({{ false }})" class="form-group input" auto-format>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí cổng thanh toán</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.payment_fee, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.payment_fee, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí kỹ thuật</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.other_cost.technical_costs, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.other_cost.technical_costs, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí văn phòng</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.other_cost.office_costs, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.other_cost.office_costs, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí tổ chức</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.other_cost.organizational_costs, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.other_cost.organizational_costs, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí thuê văn phòng</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.other_cost.officeRent_costs, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.other_cost.officeRent_costs, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí khấu hao công cụ dụng cụ</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.other_cost.tools_costs, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.other_cost.tools_costs, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí lương</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.other_cost.salary_costs, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.other_cost.salary_costs, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí bảo hiểm</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.other_cost.insurance_costs, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.other_cost.insurance_costs, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí thưởng</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.other_cost.bonus_costs, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.other_cost.bonus_costs, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí quản lý khác</td>
                            <td class="price">@{{ formatCurrency(dataLastMonth.other_cost.other_management_costs, ".", ",", 2) }}</td>
                            <td class="price">@{{ formatCurrency(data.other_cost.other_management_costs, ".", ",", 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding-left: 40px;">Chi phí khác</td>
                            <td class="price">
                                <input type="text" ng-model="dataLastMonth.other_cost.other_costs" ng-change="updateTotalCost({{ true }})" class="form-group input" auto-format>
                            </td>
                            <td class="price">
                                <input type="text" ng-model="data.other_cost.other_costs" ng-change="updateTotalCost({{ false }})" class="form-group input" auto-format>
                            </td>
                            
                        </tr>

                        <tr>
                            <td class="header-title">Khoản thu khác</td>
                            <td class="price bold-text">
                                <input type="text" ng-model="dataLastMonth.other_profit" ng-change="updateTotalCost({{ true }})" class="form-group input" auto-format>
                            </td>
                            <td class="price bold-text">
                                <input type="text" ng-model="data.other_profit" ng-change="updateTotalCost({{ false }})" class="form-group input" auto-format>
                            </td>
                        </tr>
                        <tr>
                            <td class="header-title">Lợi nhuận</td>
                            <td class="price bold-text">@{{ formatCurrency(dataLastMonth.profit, ".", ",", 2) }}</td>
                            <td class="price bold-text">@{{ formatCurrency(data.profit, ".", ",", 2) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>
@endsection

@section('script')
<script src="/modules/financial-statement/js/reportBusiness.module.controller.js?v=<?= time() ?>"></script>
<script src="//code.highcharts.com/highcharts.js"></script>
<script src="//code.highcharts.com/modules/series-label.js"></script>
<script src="//code.highcharts.com/modules/exporting.js"></script>
<script src="//code.highcharts.com/modules/export-data.js"></script>
<script src="//code.highcharts.com/modules/accessibility.js"></script>

<script>
    $(document).ready(function() {
        $(document).on('keypress', '.input', function(event) {
            let char = event.originalEvent.key; // Lấy ký tự được nhập vào
            console.log(char);
            if (isNaN(char) && char != '.') {
                event.preventDefault();
                return; // Ngăn người dùng nhập ký tự chữ
            } else {
                // Get the input value
                // let value = $(this).val().replace(/,/g, ''); // Remove existing commas if any

                // // Format the number with commas
                // value = Number(value).toLocaleString('en-US');

                // // Update the input value
                // $(this).val(value);
            }
        });
    });
</script>
@endsection
@section('css')
<style>
    .btn-upload-image {
        border: 1px solid #d3d3d39c;
        padding: 7px;
        display: inline-block;
        border-radius: 5px;
        font-size: 13px;
        background-color: #f0f0f08c;
        cursor: pointer;
        vertical-align: top;
    }
    .chosen-container.chosen-container-single {
        width: 100% !important; /* or any value that fits your needs */
    }
    .header-title {
        font-weight: bold;
    }
    .table-body {
        font-size: 14px;
    }
    .price {
        text-align: right;
    }
    .bold-text {
        font-weight: bold;
        font-size: 16px;
    }
</style>
@endsection