<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::group(['prefix' => 'financial-statement', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/', [
        'as' => 'financial-statement::index',
        'uses' => 'HomeController@index',
    ]);
});
Route::group(['prefix' => 'financial-statement', 'middleware' => 'web'], function () {
    Route::get('find', ['uses' => 'FinancialStatementController@getDataStatistic']);
    Route::get('get-data-profit', ['uses' => 'FinancialStatementController@getDataProfit']);
    Route::get('build-new-data', ['uses' => 'FinancialStatementController@buildNewDataFinancial']);
    Route::post('save', ['uses' => 'FinancialStatementController@saveDataFinancialStatement']);
    Route::get('cron', ['uses' => 'FinancialStatementController@cronFinancialData']);


    Route::get('payment/paypal/get-report', ['uses' => 'PaypalController@getReport']);
    Route::get('payment/stripe/get-report', ['uses' => 'StripeController@getReport']);
    Route::get('payment/paypal/get-transaction', ['uses' => 'PaypalController@historyTransaction']);
    Route::get('payment/stripe/get-transaction', ['uses' => 'StripeController@historyTransaction']);
    Route::get('payment/stripe/get-charge', ['uses' => 'StripeController@historyCharge']);
    Route::get('payment/stripe/cache-revenue', ['uses' => 'StripeController@cacheRevenue']);

});




Route::group(['prefix' => 'report/business', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/index', [
        'as' => 'report-business::index',
        'uses' => 'HomeController@reportBusiness',
    ]);
});
