<?php

namespace Modules\ImageCleaner\Controllers;

use Modules\ImageCleaner\Controllers\Controller;
use Modules\Localization\Helpers\DBConnect;
use Log;
use File;
use Exception;
use Illuminate\Http\Request;


class CleanerController extends Controller
{
    // check the string $haystack if it ends with the substring $needle
    public function endsWith($haystack, $needle) {
        $length = strlen($needle);
        return ($length > 0) ? (substr($haystack, -$length) === $needle) : true;
    }

    // get all columns ending with 'image_url' 
    public function getFields($countryCode)
    {
        $retVal = [];
        $connection = DBConnect::connect($countryCode);
        $tables = $connection->select('SHOW TABLES');
                            
        foreach($tables as $table)
        {
            $tablesIn = 'Tables_in_' . $connection->getDatabaseName();
            $tableName = $table->$tablesIn;
            $columns = $connection->select('SHOW COLUMNS FROM ' . $tableName);
            $columns = array_column($columns, 'Field');
            $columns = array_filter($columns, function($column) {
                return $this->endsWith($column, 'image_url');
            });
            if (!empty($columns)) {
                $tableName = substr($tableName, 3);
                $retVal["$tableName"] = array_values($columns);
            };
        }
        return $retVal;
    }

    public function clean($basePath, $folder, $imageConnect)
    {
        $dir = "$basePath/$folder";
        $ffs = scandir($dir);
        
        foreach ($ffs as $ff) {
            if (($ff != '.') && 
                ($ff != '..') && 
                ($ff != '.DS_Store')) {
                // có thể đọc
                $path = "$dir/$ff";
                if (is_readable($path)) {
                    // là folder
                    if (is_dir($path)) {
                        // là folder product
                        $isProductFolder = (strpos($path, base_path('public/files/product')) === 0);
                        if ($isProductFolder) {
                            // đệ quy folder
                            $this->clean($dir, $ff, $imageConnect);
                        }
                    } else { // là file
                        // là file ảnh
                        if (strpos(mime_content_type($path), 'image/') === 0) {
                            $localImagePath = str_replace(public_path('/'), '', $path);
                            $imagePath = 'https://printerval.com/' . $localImagePath;
                            $uniqId = crc32($imagePath);
                            $sql = "SELECT * FROM sb_image WHERE uniq_id = " . $uniqId . " LIMIT 1";
                            $items = $imageConnect->select($sql);
                            if (count($items) == 0) {
                                $moveTo = base_path('public/file-trash/') . $localImagePath;
                                // $moveToDir = str_replace(basename($moveTo), '', $moveTo);
                                // if (!File::exists($moveToDir)) {
                                //     File::makeDirectory($moveToDir, 0777, true, true);
                                // }
                                // File::move($path, $moveTo);
                                $updatedAt = new \DateTime();
                                $updatedAtString = $updatedAt->format('Y-m-d H:i:s');
                                $dataLog = [
                                        'image_url' => $imagePath,
                                        'uniq_id' => $uniqId,
                                        'old_path' => $path,
                                        'new_path' => $moveTo,
                                        'is_restore' => 0,
                                        'created_at' => $updatedAtString,
                                        'updated_at' => $updatedAtString
                                ];
                                $data = [$dataLog];
                                $property = [
                                    'table' => 'sb_image_clean_log',
                                    'columns' => ['image_url', 'uniq_id', 'old_path', 'new_path', 'is_restore', 'created_at', 'updated_at']
                                ];
                                $this->excecuteStatement($property, $data);
                            }
                        }
                    }
                }
            }
        }
    }


    public function mainClean(Request $request) 
    {
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        $imageConnect = $this->buildImagePoolConnection();
        $this->clean(public_path(), 'files', $imageConnect);
        $response = [
            'status' => 'successful'
        ];
        return response()->json($response);
    }

    private function buildConnection() {
        $retVal = [];
        $locales = getModuleLocale();
        foreach ($locales as $locale) {
            if (!$locale['enable'] || $locale['locale'] == 'central') {
                continue;
            }
            $retVal[] = DBConnect::connect($locale['locale']);
        }
        return $retVal;
    }


    public function buildImagePool(Request $request) {
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        $begin = microtime(true);
        $bulk = $request->has('bulk') ? $request->get('bulk') : 5000;
        $connections = $this->buildConnection();
        $entities = $this->getFields('us');
        foreach($connections as $connection) {
            $this->createImagePool($connection, $entities, $bulk);
        }
        $imageConnect = $this->buildImagePoolConnection();
        $countImage = $imageConnect->table('image')->count();
        $end = microtime(true);
        $response = [
            'status' => 'successful',
            'time' => $end - $begin,
            'count_images' => $countImage
        ];
        return response()->json($response);
    }

    private function createImagePool($connection, $entities, $bulk) {
        $connectionName = $connection->getName();
        $updatedAt = new \DateTime();
        $updatedAtString = $updatedAt->format('Y-m-d H:i:s');
        foreach ($entities as $table => $fields) {
            if (\Schema::connection($connectionName)->hasTable($table)) {
                $count = $connection->table($table)->count();
                $limitSize = ceil($count / $bulk);
                for ($pageId = 0; $pageId < $limitSize; $pageId++) {
                    $query = $connection->table($table)
                                        ->forPage($pageId + 1, $bulk);
                    foreach ($fields as $field) {
                        $query->whereNotNull($field)
                            ->where($field, '!=', '');
                    }
                    $items = $query->get($fields);
                    $data = [];
                    foreach ($items as $item) {
                        foreach ($fields as $field) {
                            $newData = [
                                'image_url' => $item->{$field},
                                'uniq_id' => crc32($item->{$field}),
                                'table_use' => $table,
                                'created_at' => $updatedAtString,
                                'updated_at' => $updatedAtString
                            ];
                            $data[] = $newData;
                        }
                    }
                    if (count($data) > 0) {
                        $property = [
                            'table' => 'sb_image',
                            'columns' => ['image_url', 'uniq_id', 'table_use', 'created_at', 'updated_at']
                        ];
                        $this->excecuteStatement($property, $data);
                    }
                }
            }
        }
    }

    private function buildImagePoolConnection() {
        $connection = config('database.connections.mysql');
        $connection['database'] = 'image-pool';
        config(['database.connections.image_pool' => $connection]);
        $connection = config('database.connections');
        return \DB::connection('image_pool');
    }

    private function excecuteStatement($property, $data) {
        $condition = $this->buildCondition($property);
        $values = $this->buildValueList($property, $data);
        $sql = $this->buildSqlStatement($property, $values, $condition);
        $imageConnect = $this->buildImagePoolConnection();
        return $imageConnect->statement($sql);
    }

    private function buildSqlStatement($property, $value, $condition) {
        return 'INSERT INTO `' . $property['table'] . '` (' . implode(', ', $property['columns']) . ') VALUES '
        . $value . ' ON DUPLICATE KEY UPDATE ' . $condition . ';';
    }

    private function buildCondition($property) {
        $retVal = '';
        for ($i = 0; $i < count($property['columns']); $i++) {
            $retVal .= $property['columns'][$i] . ' = VALUES(' . $property['columns'][$i] . ')';
            if ($i < count($property['columns']) - 1) {
                $retVal .= ', ';
            }
        }
        return $retVal;
    }

    private function buildValueList($property, $data) {
        $value = '';
        for ($j = 0; $j < count($data); $j++) {
            $value .= '(';
            for ($i = 0; $i < count($property['columns']); $i++) {
                $valueTarget = $data[$j][$property['columns'][$i]];
                if (is_string($property['columns'][$i]) || empty($property['columns'][$i])) {
                    $valueTarget = '"' . $valueTarget . '"';
                }
                $value .= $valueTarget;
                if ($i < count($property['columns']) - 1) {
                    $value .= ', ';
                }
            }
            $value .= ')';
            if ($j < count($data) - 1) {
                $value .= ',';
            }
        }
        return $value;
    }

    public function restore(Request $request) {

        ini_set("memory_limit", "-1");
        set_time_limit(0);
        $bulk = $request->has('bulk') ? $request->get('bulk') : 10000;
        $imageConnect = $this->buildImagePoolConnection();
        $count = $imageConnect->table('image_clean_log')
                            ->where('is_restore', '=', 0)
                            ->count();
        $limitSize = ceil($count / $bulk);
        for ($pageId = 0; $pageId < $limitSize; $pageId++) {
            $items = $imageConnect->table('image_clean_log')
                                ->where('is_restore', '=', 0)
                                ->forPage(1, $bulk)
                                ->get();
            foreach ($items as $item) {
                try {
                    File::move($item->new_path, $item->old_path);
                    $imageConnect->table('image_clean_log')
                                ->where('id', '=', $item->id)
                                ->update(['is_restore' => 1]);
                } catch (\Exception $e) {
                    \Log::error('Restore Image Error: ' . $e->getMessage() . '. Line: ' . $e->getLine());
                }
            }
        }
        $response = [
            'status' => 'successful'
        ];
        return response()->json($response);
    }
}
