<?php

namespace Modules\PaymentStats\Controllers;

use Illuminate\Http\Request;
use Modules\PaymentStats\Models\PaymentStats;

class ListenPaymentStatsController
{
    
    public function viewPage(Request $request) {
        $id = $request->has('id') ? $request->get('id') : null;
        $response = [
            'status' => 'fail'
        ];
        if ($id != null && $this->isValid()) {
            $data = [
                'product_id' => $id,
                'type' => PaymentStats::TYPE_CLICK,
                'click' => 1
            ];
            $this->saveData($data);
            $response['status'] = 'successful';
        }
        return response()->json($response);
    }

    public function viewCheckout($params) {
        if ($this->isValid() && isset($params['items'])) {
            foreach ($params['items'] as $item) {
                $data = [
                    'product_id' => $item['product_id'],
                    'type' => PaymentStats::TYPE_CHECKOUT,
                    'checkout' => 1
                ];
                $this->saveData($data);
            }
        }
    }

    public function payment($params) {
        if ($this->isValid() && isset($params['items'])) {
            foreach ($params['items'] as $item) {
                $data = [
                    'product_id' => $item['product_id'],
                    'type' => PaymentStats::TYPE_PAYMENT,
                    'payment' => 1
                ];
                $this->saveData($data);
            }
        }
    }

    public function purchase($params) {
        if ($this->isValid() && isset($params['items'])) {
            foreach ($params['items'] as $item) {
                $dataSale = [
                    'product_id' => $item['product_id'],
                    'type' => PaymentStats::TYPE_SALE,
                    'sale' => $item['quantity']
                ];
                $this->saveData($dataSale);
                $dataEarnings = [
                    'product_id' => $item['product_id'],
                    'type' => PaymentStats::TYPE_EARNINGS,
                    'earnings' => $item['quantity'] * $item['price']
                ];
                $this->saveData($dataEarnings);
            }
        }
    }


    private function saveData($data) {
        $data['date'] = date('Y-m-d');
        $checkExists = PaymentStats::where('product_id', '=', $data['product_id'])
                                    ->where('type', '=', $data['type'])
                                    ->where('date', '=', $data['date'])
                                    ->exists();
        if (!$checkExists) {
            PaymentStats::create($data);
        } else {
            if ($data['type'] != PaymentStats::TYPE_EARNINGS && $data['type'] != PaymentStats::TYPE_SALE) {
                PaymentStats::where('product_id', '=', $data['product_id'])
                                        ->where('type', '=', $data['type'])
                                        ->where('date', '=', $data['date'])
                                        ->increment($data['type'], 1);
            } else if($data['type'] == PaymentStats::TYPE_EARNINGS) {
                PaymentStats::where('product_id', '=', $data['product_id'])
                                        ->where('type', '=', $data['type'])
                                        ->where('date', '=', $data['date'])
                                        ->increment('earnings', $data['earnings']);
            } elseif ($data['type'] == PaymentStats::TYPE_SALE) {
                PaymentStats::where('product_id', '=', $data['product_id'])
                                        ->where('type', '=', $data['type'])
                                        ->where('date', '=', $data['date'])
                                        ->increment('sale', $data['sale']);
            }
        }
        
    }

    private function isValid() {
        $isBot = $this->isBot();
        $isStaff = $this->isStaff();
        $retVal = true;
        if ($isBot || $isStaff) {
            $retVal = false;
        }
        return $retVal;
    }


    private function isBot()
    {
        return preg_match("/rambler|abacho|acoi|accona|aspseek|altavista|estyle|scrubby|lycos|geona|ia_archiver|alexa|sogou|skype|facebook|twitter|pinterest|linkedin|naver|bing|google|yahoo|duckduckgo|yandex|baidu|teoma|xing|java\/1.7.0_45|bot|crawl|slurp|spider|mediapartners|\sask\s|\saol\s/i", isset($_SERVER["HTTP_USER_AGENT"]) ? $_SERVER["HTTP_USER_AGENT"] : "");
    }

    private function isStaff() {
        try {
            return \Auth::guard('web')->check();
        } catch (\Exception $e) {
            \Log::info('Module PaymentStats error:' . $e->getMessage());
            return 0;
        }
        
    }
    
    
}
