<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbPaymentStatsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('payment_stats')) {
            Schema::create('payment_stats', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('product_id')->nullable();
                $table->integer('product_sku_id')->nullable();
                $table->string('sku', 255)->nullable();
                $table->enum('type', ['click', 'payment', 'checkout', 'sale', 'earnings'])->nullable();
                $table->integer('click')->nullable()->default(0);
                $table->tinyInteger('payment')->nullable()->default(0);
                $table->tinyInteger('checkout')->nullable()->default(0);
                $table->tinyInteger('sale')->nullable()->default(0);
                $table->double('earnings', 15, 2)->nullable()->default(0.00);
                $table->date('date')->nullable();
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->index('product_id', 'product_id');
                $table->index('date', 'date');
                $table->index('type', 'type');
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_stats');
    }
}
