<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
use Illuminate\Support\Facades\Route;
$systemAuth = config('app.system_auth_middleware');
Route::group(['prefix' => 'payment-stats', 'middleware' => $systemAuth], function () {
    Route::get('/', [
        'as' => 'payment-stats::index',
        'uses' => 'PaymentStatsController@index',
    ]);

    Route::get('/fake', [
        'as' => 'payment-stats::fake',
        'uses' => 'PaymentStatsController@fake'
    ]);

    Route::post('/find', [
        'as' => 'payment-stats::find',
        'uses' => 'PaymentStatsController@find'
    ]);

    Route::any('/export-excel', [
        'as' => 'payment-stats::export-excel',
        'uses' => 'PaymentStatsController@exportExcel'
    ]);

    Route::get('/action', [
        'as' => 'payment-stats::action',
        'uses' => 'PaymentStatsController@action'
    ]);
});

Route::group(['prefix' => 'service/payment-stats'], function () {
    Route::post('/tracking/view', [
        'as' => 'payment-stats::tracking::click',
        'uses' => 'ListenPaymentStatsController@viewPage'
    ])->middleware(['bot.default_response']);
});
