
<?php
if (auth()->check() && isset($product)){
    $replaceDomain = config('product-control::sa.replaceDomain',[]);
    $downloadUrl = route('product-control::download:image',['product_id' => $product['id']]);
    if (!empty($replaceDomain)){
        foreach ($replaceDomain as $find => $replace ){
            $downloadUrl = str_replace($find,$replace, $downloadUrl);
        }
    }
?>
<link rel="stylesheet" href="@asset('product-control/css/style.css')">
<div class="product-detail-sku">
    <div class="product-control-sku">
        SKU:
        <span style="-webkit-user-select: all; user-select: all;" class="span-product-sku">
            {{isset($product['origin_sku'])?$product['origin_sku']:$product['sku']}}
        </span>
        Created:
        <span>{{ date('d/m/Y', strtotime($product['created_at'])) }}</span>
        ADS: <span id="productcontrol_advertising_status"> ... </span>
    </div>
    <div class="product-control-sku">
        Violation: <span>{{$product['is_violation']}}</span>
        Trademark: <span>{{$product['is_trademark']}}</span>
        @if (hasPermission('view_dashboard') || hasPermission('content_product'))
            Views: <span>{{$product['view_count']}}</span>
            Sold: <span>{{$product['sold']}}</span>
            @if (isset($product["score"]))
            Score: <span>{{$product['score']}}</span>
            @endif
        @endif
        <a class="tooltip" target="_blank" href="<?= $downloadUrl ?>" style="color: #fff">
            <span class="tooltiptext">Download Image</span>
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-download" viewBox="0 0 16 16">
                <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z"/>
                <path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z"/>
            </svg>
        </a>
    </div>
</div>
<?php
}
?>

