<?php
$user = \Illuminate\Support\Facades\Auth::user();
$isAdmin = false;
if($user && isset($user->role) && in_array($user->role, ['STAFF','ADMIN']) && isset($_COOKIE["user_id"])) {
    $isAdmin = true;
}

if ($isAdmin && isset($product)) {
$isSearchPage = array_key_exists('cr', $product) || Route::currentRouteName() == 'search';
?>
<input type="hidden" class="product-item-id" value="<?= $product['id'] ?>">
<div class="flex-b align-c flex-s product-title user-filter-report js-product-id-<?= $product['id'] ?>">
    @if(hasPermission('view_dashboard') || hasPermission('content_product'))
    <span class="js-view-item">Views: {{$product['view_count']}}</span>
    <span class="js-sold-item">Sold: {{$product['sold']}}</span>
    @endif
</div>
@if ($isSearchPage)
    <div class="flex-b align-c flex-s product-title user-filter-report js-conversion-product-<?= $product['id'] ?>">
          <span class="js-click-item">Click: {{0}}</span>
         <span class="js-conversion-item">Conversion: {{0}}</span>
    </div>
@endif
<div class="flex-b align-c flex-s product-title user-filter-report">
<span>SKU: <span style="-webkit-user-select: all; user-select: all;">{{$product['sku']}}</span></span>
</div>
<div class="product-title flex-b align-c flex-s user-filter-order">
    <span>Violation: {{isset($product['is_violation']) ? $product['is_violation'] : ''}}</span>
    <span>Trademark: {{isset($product['is_trademark']) ? $product['is_trademark'] : ''}}</span>
</div>
@if (isset($filterCategory['id']) && isset($product['horder']) && isset($product['pivot_id']))
    <div class="product-title flex-b align-c flex-s user-filter-order">
            <span>Thứ tự: </span>
            <input type="number" style="width: 40%; max-width: 40%"
                   class="input-position form-control"
                   value="{{$product['horder']}}" data-id="{{ $product['pivot_id'] }}">
    </div>
@endif

@if ($isSearchPage && isset($product['porder']))
    <div class="product-title flex-b align-c flex-s user-filter-order">
        <span>Thứ tự:&nbsp;</span>
        <input type="number" class="js-search-position form-control" value="{{isset($product['position']) ? $product['position'] : 0}}" data-id="{{ $product['id'] }}">
        @if(isset($product['porder']) && $product['porder'] > 0)
            PINED
        @endif
    </div>
@endif

<?php
}
?>

