<?php 
$user = \Illuminate\Support\Facades\Auth::user();
$isAdmin = false;
if($user && isset($user->role) && in_array($user->role, ['STAFF','ADMIN']) ) {
    $isAdmin = true;
}

?>
@if (false && $isAdmin && isset($products) && count($products) > 0)
<?php
    $productIds = [];
    foreach ($products as $product) {
        $productIds[] = $product['id'];
    }
?>
<script src="https://code.highcharts.com/highcharts.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function(event) {
        function getProductItemChartData () {
            $.ajax({
                url: '/product-control/products/statistics?product_ids=<?= implode(",", $productIds) ?>',
                type: 'get',
                dataType: 'json',
                success: function (data) {
                    if (data.status == 'successful' && data.result) {
                        for (var k in data.result) {
                            var xcategories = [];
                            var item = data.result[k];
                            var clicks = [];
                            var quantity = [];
                            for (var date in item) {
                                xcategories.push(date);
                                clicks.push(item[date].clicks);
                                quantity.push(item[date].quantity);
                            }
                            var idHtml = 'product-item-chart-container-' + k;
                            if($('#' + idHtml).length ) {
                                Highcharts.chart(idHtml, {
                                    chart: {
                                        type: 'spline',
                                    },
                                    legend: {
                                        enabled: false
                                    },
                                    credits: {
                                        enabled: false
                                    },
                                    xAxis: {
                                        categories: xcategories.reverse(),
                                        minorGridLineWidth: 0,
                                        gridLineWidth: 0,
                                        crosshair: true,
                                        labels: {
                                            overflow: 'justify'
                                        },
                                        title: {
                                            text: null
                                        },
                                        labels:
                                            {
                                                enabled: false
                                            },
                                    },
                                    yAxis: [{
                                        minorGridLineWidth: 0,
                                        gridLineWidth: 0,
                                        title: {
                                            text: null
                                        },
                                        labels: {
                                            enabled: false
                                        }
                                    }, {
                                        minorGridLineWidth: 0,
                                        gridLineWidth: 0,
                                        title: {
                                            text: null
                                        },
                                        labels: {
                                            enabled: false
                                        }
                                    }, {
                                        minorGridLineWidth: 0,
                                        gridLineWidth: 0,
                                        title: {
                                            text: null
                                        },
                                        labels: {
                                            enabled: false
                                        }
                                    }],
                                    tooltip: {
                                        valueSuffix: '',
                                        enabled: true,
                                        shared: true
                                    },
                                    plotOptions: {
                                        spline: {
                                            lineWidth: 3,
                                            states: {
                                                hover: {
                                                    lineWidth: 3
                                                }
                                            },
                                            marker: {
                                                enabled: false
                                            },
                                        }
                                    },
                                    series: [{
                                        name: "View",
                                        data: clicks.reverse(),
                                        yAxis: 0,
                                    }, {
                                        name: "Order count",
                                        data: quantity.reverse(),
                                        yAxis: 1,
                                        color: 'red'
                                    }],
                                    title: {
                                        text: null
                                    },
                                });
                            }
                        }

                    }
                }
            });

        }
        getProductItemChartData();
    });

</script>
@endif
