<?php 
$user = \Illuminate\Support\Facades\Auth::user();
$isAdmin = false;
if($user && isset($user->role) && in_array($user->role, ['STAFF','ADMIN']) ) {
    $isAdmin = true;
}

?>
@if ($isAdmin && isset($product))
<script>
    function getOrderChartData () {
        let isClearCache = window.location.href.indexOf('clear_cache') > 0;
        $.ajax({
            url: '/product-control/product/statistics?product_id=<?= $product["id"] ?>' + (isClearCache ? '&clear_cache=1' : ''),
            type: 'get',
            dataType: 'json',
            success: function (data) {
                if (data.status == 'successful' && data.result != null) {
                    var xcategories = [];
                    if (data.result) {
                        let quantity = [];
                        let clicks = [];
                        let price = [];

                        for (var i = 0; i < data.result.length; i++) {
                            if (i == data.result.length - 1) {
                                xcategories.push("{{ __('This week') }}");
                            } else {
                                xcategories.push((data.result.length - i - 1) + " {{ __('week ago') }}");
                            }
                        }
                        for (var i = 0; i < data.result.length; i++) {
                            quantity.push(parseInt(data.result[i]["quantity"]));
                            clicks.push(parseInt(data.result[i]["clicks"]));
                            price.push(parseFloat(data.result[i]["price"]))
                        }
                        if($('#order-chart-container').length ) {
                            Highcharts.chart('order-chart-container', {
                                chart: {
                                    type: 'spline',
                                },
                                legend: {
                                    enabled: false
                                },
                                credits: {
                                    enabled: false
                                },
                                xAxis: {
                                    categories: xcategories,
                                    minorGridLineWidth: 0,
                                    gridLineWidth: 0,
                                    crosshair: true,
                                    labels: {
                                        overflow: 'justify'
                                    },
                                    title: {
                                        text: null
                                    },
                                    labels:
                                            {
                                                enabled: false
                                            },
                                },
                                yAxis: [{
                                        minorGridLineWidth: 0,
                                        gridLineWidth: 0,
                                        title: {
                                            text: null
                                        },
                                        labels: {
                                            enabled: false
                                        }
                                    }, {
                                        minorGridLineWidth: 0,
                                        gridLineWidth: 0,
                                        title: {
                                            text: null
                                        },
                                        labels: {
                                            enabled: false
                                        }
                                    }, {
                                        minorGridLineWidth: 0,
                                        gridLineWidth: 0,
                                        title: {
                                            text: null
                                        },
                                        labels: {
                                            enabled: false
                                        }
                                    }],
                                tooltip: {
                                    valueSuffix: '',
                                    enabled: true,
                                    shared: true
                                },
                                plotOptions: {
                                    spline: {
                                        lineWidth: 3,
                                        states: {
                                            hover: {
                                                lineWidth: 3
                                            }
                                        },
                                        marker: {
                                            enabled: false
                                        },
                                    }
                                },
                                series: [{
                                        name: "Sold",
                                        data: quantity.reverse(),
                                        yAxis: 0,
                                    }, {
                                        name: "Clicks",
                                        data: clicks.reverse(),
                                        yAxis: 1,
                                    }, {
                                        name: "Price",
                                        data: price.reverse(),
                                        yAxis: 2,
                                    }],
                                title: {
                                    text: null
                                },
                            });
                        }
                        
                    }

                    const statusElement = document.getElementById('productcontrol_advertising_status');
                    let advertisingStatus = "<span style='color: red'>OFF</span>";
                    
                    if (data.advertising_status && data.advertising_status == 1) {
                        advertisingStatus = "<span style='color: #45ff45'>ON</span>";
                    } 

                    if (statusElement) {
                        statusElement.innerHTML = advertisingStatus;
                    }   
                    
                }
            }
        });

    }
    getOrderChartData();
</script>
@endif
