@if(auth()->check())
<script src="@asset('product-control/js/jquery-ui.js')"></script>
<script>
    $( function() {
        $( "#filter-date-from" ).datepicker({
            dateFormat: "yy-mm-dd",
        }).datepicker( "setDate", "-1m" );
        $( "#filter-date-to" ).datepicker({
            dateFormat: "yy-mm-dd",
        }).datepicker( "setDate", "+0");
        getStatistic();
        getSearchReact();
    });
    $(".datepicker").change(function(){
        getStatistic();
        getSearchReact();

    });

    function getSearchReact() {
        let urlObj = new URL(window.location.href);
        let keyword = urlObj.searchParams.get("q");
        if (!keyword) {
            keyword = $('#js-tag-value').val();
        }
        if (!keyword) {
            console.log('Keyword is empty');
            return;
        }
        let fromDate = $( "#filter-date-from" ).val();
        let toDate = $( "#filter-date-to" ).val();
        let params = new URLSearchParams({
            from_date: fromDate,
            to_date: toDate,
            keyword: keyword,
        });
        let url = '/z-search/react/find?' + params.toString();
        $.ajax({
            url: url,
            type: 'GET',
            success: function (res) {
                let items = res.data;
                for (let item of items) {
                    let elm = '.js-conversion-product-' + item.product_id;
                    $(elm + ' .js-click-item').text('Click: ' + item.total_click);
                    $(elm + ' .js-conversion-item').text('Conversion: ' + item.total_conversion);
                }
            }
        })

    }



    function getStatistic(){
        let fromDate = $( "#filter-date-from" ).val();
        let toDate = $( "#filter-date-to" ).val();
        let apiUrl = '<?= env("API_URL","https://api.printerval.com")?>';
        let ids = "";
        let inputTags = document.getElementsByClassName("product-item-id");
        for (let i of inputTags) {
            ids += i.value + ";"
        }
        ids = ids.slice(0,-1);
        let url = apiUrl + '/payment_stats?fields=product_id,sum(click) as views,sum(sale) as sold&groups=product_id&filters=product_id={' + ids + '},created_at>=' + fromDate +' 00:00:00,created_at<=' + toDate +' 23:59:59&page_size=-1';
        if (ids){
            $.ajax({
                url: url,
                type: 'GET',
                success: function (data) {
                    $('.js-view-item').text("Views: 0");
                    $('.js-sold-item').text("Sold: 0");
                    if (data.result.length > 0) {
                        let paymentStats = data.result;
                        for (let index in paymentStats){
                            let item = paymentStats[index];
                            $('.js-product-id-'+item.product_id+ ' .js-view-item').text("Views: " + item.views);
                            $('.js-product-id-'+item.product_id+ ' .js-sold-item').text("Sold: " + item.sold);
                        }
                    } else {
                        //@todo 1 so sp k co stats
                    }
                }
            });

        }
    }
    $(".input-position").change(function () {
        let apiUrl = '<?= env("API_URL","https://api.printerval.com")?>';
        let pivotId = $(this).attr('data-id');
        let horder = $(this).val();
        if ($.isNumeric(horder)) {
            let data = {
                sorder: horder,
                horder: horder,
            };
            let url = apiUrl + "/product_n_category_top/" + pivotId;
            $.ajax({
                url: url,
                headers: {
                    "token":"{{ Auth::user()?Auth::user()->token:'' }}"
                },
                type: 'PATCH',
                dataType: 'json',
                data: data,
                success: function (data) {
                    if (data.result.sorder == horder) {
                        //window.location.reload()
                    } else {
                        alert("Có lỗi xảy ra! Vui lòng thử lại hoặc liên hệ với đội kỹ thuật để được hỗ trợ!");
                    }
                }
            });
        } else {
            alert("Yêu cầu nhập vào phải là số.");
        }
    });

    $(".js-search-position").change(function () {
        let pId = $(this).attr('data-id');
        let position = $(this).val();
        if (!$.isNumeric(position)) {
            alert('Yêu cầu nhập vào phải là số.');
            return;
        }

        let urlObj = new URL(window.location.href);
        let keyword = urlObj.searchParams.get("q");
        if (!keyword) {
            keyword = $('#js-tag-value').val();
        }
        let data = {
            product_id: pId,
            position: position,
            keyword: keyword,
        }
        $.ajax({
            url: '/z-search/position',
            type: 'POST',
            dataType: 'json',
            data: data,
            success: function (data) {
                if (data.status == 'successful') {
                    //window.location.reload();
                } else {
                    alert("Có lỗi xảy ra! Vui lòng thử lại hoặc liên hệ với đội kỹ thuật để được hỗ trợ!");
                }
            }
        });
    });

</script>
@endif