<?php

namespace Modules\Reports\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use GuzzleHttp\Client;
class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected  function checkAuth($request)
    {
        $retVal = false;
        $token  = $request->header('token');
        if (DB::table('users')->where('token', $token)->exists()) {
            $retVal = true;
        }
        return $retVal;
    }

    protected function checkToken($request) {
        $retVal = false;
        $token  = $request->get('token');
        if ($token === 'megaads@123') {
            $retVal = true;
        }
        return $retVal;
    }

    protected function triggerSyncRequest($url, $method = 'GET', $params = [], $headers = []) {
        $ch = curl_init();
        $timeout = 30;
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        if ($headers) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        if ($method != 'GET') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        }

        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        $data = curl_exec($ch);
        curl_close($ch);
        return json_decode($data);
    }

    protected function fetchCost($productSkuId, $countryId, $warehouseId = -1, $locale = null)
    {
        $cost = 0;
        $apiUrl = config('sa.api_url');
        if (!$locale) {
            $locale = env('APP_LOCALE', '');
        }
        if ($locale != '' && $locale != 'us') {
            $apiUrl = str_replace('https://' . $locale . '.api','https://api', $apiUrl);
            $apiUrl = str_replace('https://glob.api', 'https://' . $locale . '.api', $apiUrl);
            $apiUrl = str_replace('https://api', 'https://' . $locale . '.api', $apiUrl);
        }
        $url = $apiUrl . '/api/get-cost?productSkuId=' . $productSkuId . '&version=2&countryId=' . $countryId . '&warehouseId=' . $warehouseId;
        $res = $this->triggerSyncRequest($url, 'GET', []);
        if ($res && isset($res->status) && $res->status === 'successful') {
            $cost = $res->result;
        }
        return (float) $cost;
    }

    protected function fetchProfitInfo($orderCode, $locale = null)
    {
        $cost = 0;
        $apiUrl = config('sa.api_url');
        if (!$locale) {
            $locale = env('APP_LOCALE', '');
        }
        if ($locale != '' && $locale != 'us') {
            $apiUrl = str_replace('https://' . $locale . '.api','https://api', $apiUrl);
            $apiUrl = str_replace('https://glob.api', 'https://' . $locale . '.api', $apiUrl);
            $apiUrl = str_replace('https://api', 'https://' . $locale . '.api', $apiUrl);
        }
        $url = $apiUrl . '/api/get-profit-info?code=' . $orderCode;
        $client = new Client(['verify' => false]);
        $response = $client->get($url);
        $body = $response->getBody() ;
        $string = $body->getContents();
        $res = json_decode($string, true);
        return $res;
    }

    protected function getWarehouseId ($orderItemId, $shippingConfigurations)
    {
        $shippingConfigs = [];
        if (!empty($shippingConfigurations)) {
            $shippingConfigs = json_decode($shippingConfigurations, true);
        }
        $warehouseId = -1;
        if (!empty($orderItemId) && !empty($shippingConfigs[$orderItemId])) {
            $warehouseId = $shippingConfigs[$orderItemId];
        }
        return $warehouseId;
    }
}
