<?php

namespace Modules\Reports\Controllers;


use Illuminate\Http\Request;
use App\Helpers\DBConnect;
use Illuminate\Support\Facades\Auth;
use DateTime;
use DB;
use Maatwebsite\Excel\Facades\Excel;

class CreatorController extends Controller
{
    protected $pageSize = 40;
    protected $locales = [];
    protected $ignoreEmails = ['mactrantung@gmail.com'];
    static $connection;
    protected  $creatorIds = [];
    protected  $locale = '';
    protected $currencyRatio = 1;

    private function buildFilter(Request $request)
    {
        $params = ['actor_id', 'category_id', 'type_product'];
        $retVal = [];
        foreach ($params as $param) {
            if ($request->has($param)) {
                $retVal[$param] = $request->input($param);
            }
        }
        $sort = $request->has('sort') ? $request->input('sort') : '';
        if ($sort != '') {
            $retVal['sort'] = $sort;
            $arrOrders = explode('-', $retVal['sort']);
            $retVal['orders'] = [$arrOrders[0] => $arrOrders[1]];
        }
        $currentDate = new \DateTime();
        $retVal['from_date'] = $request->has('dateFrom') ?  $request->input('dateFrom') : $currentDate;
        $retVal['to_date'] = $request->has('dateTo') ?  $request->input('dateTo') : $currentDate;
        $retVal['query_from'] = $request->has('dateFrom') ?  $request->input('dateFrom') : $currentDate;
        $retVal['query_to'] = $request->has('dateTo') ?  $request->input('dateTo') : $currentDate;

        $retVal['date_old_product_from'] = $request->has('date_old_product_from') ? $request->input('date_old_product_from') : $currentDate;
        $retVal['date_old_product_to'] = $request->has('date_old_product_to') ?  $request->input('date_old_product_to') : $currentDate;
        // dd($request->input('date_old_product_from'), $request->input('date_old_product_to'));
        $retVal['page_id'] = $request->has('page_id') ? $request->input('page_id') : 0;
        $retVal['page_size'] = $this->pageSize;
        return $retVal;
    }

    public static function table($table) {
        if (self::$connection) {
            return self::$connection->table($table);
        } else {
            return DB::table($table);
        }
    }

    public static function setConnection($locale) {
        $connection = DBconnect::connect($locale);
        self::$connection = $connection;
    }

    public function indexCreatorCategory(){
        return view('reports::creator-category.index');
    }
    public function findCreatorCategory(Request $request)
    {
        $retVal = [
            'status' => 'fail',
            'result' => []
        ];
        $this->getCreator();
        self::setConnection($request->get('locale', 'us'));
        $filter = $this->buildFilter($request);
        $ignoreUserIds = self::table('users')
            ->whereIn('email', $this->ignoreEmails)
            ->pluck('id')
            ->toArray();
        $filter['ignore_user_ids'] = $ignoreUserIds;
        $query = self::table('order as o')
            ->from(DB::raw("`sb_order` FORCE INDEX(`sa_inoutput_created_at`)"))
            ->join('order_item as oi', 'oi.order_id', '=', 'order.id')
            ->join('product as p', 'p.id', '=', 'oi.product_id')
            ->join('product_n_category as pnc', 'pnc.product_id', '=', 'p.id')
            ->where('pnc.is_parent', 0)
            ->whereNotIn('actor_id', $ignoreUserIds)
            ->whereNotIn('order.status', ['CANCELED','RETURNED','REQUEST_RETURN'])
            ->where('p.status', 'ACTIVE')
            ->whereIn('p.actor_id', $this->creatorIds)
            ->where('order.payment_status', 'PAID');

        if (isset($filter['query_from'])) {
            $query->where('order.created_at', '>=', $filter['query_from'])
                ->where('p.created_at', '>=', $filter['query_from']);
        }
        if (isset($filter['query_to'])) {
            $query->where('order.created_at', '<=', $filter['query_to'])
                ->where('p.created_at', '<=', $filter['query_to']);
        }
        if (isset($filter['actor_id'])) {
            $query->where('p.actor_id', $filter['actor_id']);
        }
        if (isset($filter['category_id'])) {
            $query->where('pnc.category_id', $filter['category_id']);
        }
        $query->select(
            DB::raw('SUM(sb_oi.quantity * sb_oi.price) as sales'),
            'pnc.category_id',
            'p.actor_id',
            DB::raw('SUM(sb_oi.quantity) as quantity')
        )
            ->groupBy('pnc.category_id')
            ->groupBy('p.actor_id')
            ->orderBy('actor_id')
            ->orderBy('sales', 'desc');
//        if (isset($filter['page_size']) && isset($filter['page_id'])) {
//            $query->forPage($filter['page_id'] + 1, $filter['page_size']);
//        }
        $data = $query
            ->get()
            ->toArray();
        $actorKeyById = self::table('users')->pluck('name', 'id')
            ->toArray();
        $listCategoryIds = array_unique(array_column($data, 'category_id'));
        $categoryByKey = self::table('category')->whereIn('id', $listCategoryIds)
            ->pluck('name', 'id')->toArray();
        $countProductKeyByActorId = $this->countProductCategoryKeyByActorId($filter);
        foreach ($data as $key => $product) {
            if (isset($categoryByKey[$product->category_id])) {
                $product->category_name = $categoryByKey[$product->category_id];
            } else {
                $product->category_name = null;
            }
            if (isset($actorKeyById[$product->actor_id])) {
                $product->actor_name = $actorKeyById[$product->actor_id];
            } else {
                $product->actor_name = null;
            }
            if($product->actor_id && isset($countProductKeyByActorId[$product->actor_id][$product->category_id])) {
                $product->countProucts = $countProductKeyByActorId[$product->actor_id][$product->category_id];
            } else {
                $product->countProucts = 0;
            }
        }

        if (count($data)) {
            $retVal['status'] = 'successful';
            $retVal['result'] = $data;
        }

        return $retVal;
    }


    private function countProductCategoryKeyByActorId ($filter)
    {
        $products = self::table('summary_product_date as spd')
            ->where('spd.date', '>=', $filter['from_date'])
            ->where('spd.date', '<=', $filter['to_date'])
            ->whereIn('spd.actor_id', $this->creatorIds)
            ->groupBy('spd.actor_id')
            ->groupBy('spd.category_id')
            ->select(DB::raw('SUM(count_products) as count'), 'actor_id', 'category_id')
            ->get();
        $data = [];
        foreach ($products as $product) {
            if(!array_key_exists($product->actor_id, $data)) {
                $data[$product->actor_id] = [];
            }
            if (!array_key_exists($product->category_id, $data[$product->actor_id])) {
                $data[$product->actor_id][$product->category_id] = $product->count;
            }
        }
        return $data;
    }

    public function indexCreatorRevenue (Request $request) {
        $users = self::table('users')->where('role', 'STAFF')->pluck('name', 'id');
        $locates = getModuleLocale();
        $marketEnableds = [];

        foreach ($locates as $locale) {
            if ($locale['enable'] && $locale['locale'] != 'central') {
                $this->locales[$locale['locale']] = $locale['name'];
            }
        }

        return view('reports::creator-revenue.index', ['users' => $users, 'locates' => $this->locales]);
    }

    public function findReportCreatorRevenue(Request $request)
    {
        set_time_limit(60 * 60);
        $retVal = [
            'status' => 'fail',
            'result' => []
        ];
        if (!$this->checkToken($request)) {
            return $retVal;
        }
        $this->locale = $request->get('locate', 'us');
        self::setConnection($this->locale);
        $this->getCreator();
        $this->getCurrencyByLocale();
        $filter = $this->buildFilter($request);
        $countProducts = $this->countProductKeyByActorId($filter);
        if ($filter['type_product'] == 'new_product') {
            $revenueQuantities = $this->calculateCreatorRevenueAndCostNewProduct($filter);
        } else {
            $revenueQuantities = $this->calculateCreatorRevenueAndCostAllProduct($filter);
        }
        $actorKeyById = self::table('users')
            ->pluck('name', 'id')
            ->toArray();
        $data = [];
        foreach ($countProducts as $actorId => $countProduct) {
            if (isset($revenueQuantities[$actorId])) {
                $data[$actorId] = $revenueQuantities[$actorId];
                $data[$actorId]['count_products'] = $countProduct;
                $data[$actorId]['profit'] = $revenueQuantities[$actorId]['revenue']
                    - $revenueQuantities[$actorId]['cost'] - $revenueQuantities[$actorId]['ads_cost'] - $revenueQuantities[$actorId]['return_fee'] ;
            } else {
                $data[$actorId] = [
                    'revenue' => 0,
                    'cost' => 0,
                    'quantity' => 0,
                    'ads_cost' => 0,
                    'return_fee' => 0,
                    'actor_id' => $actorId,
                    'count_products' => $countProduct,
                    'actor_name' => null,
                    'profit' => 0,
                ];
            }
            if (isset($actorKeyById[$actorId])) {
                $data[$actorId]['actor_name'] = $actorKeyById[$actorId];
            } else {
                $data[$actorId]['actor_name'] = null;
            }


        }
        if ($data) {
            $retVal['result'] = $data;
        }
        $retVal['status'] = 'successful';
        return $retVal;
    }

    private function countProductKeyByActorId ($filter)
    {

        if ($filter['type_product'] == 'new_product') {
            $minDate = $filter['query_from'];
            $maxDate = $filter['query_to'];
        } else {
            $minDate = $filter['date_old_product_from'];
            $maxDate = $filter['date_old_product_to'];
            // dd($minDate, $maxDate );
        }
        $data = [];
        foreach ($this->creatorIds as $creatorId) {
            $creator = self::table('count_content_product_date as p')
           ->where('p.date', '>=', $minDate)
           ->where('p.date', '<=', $maxDate)
           ->where('p.actor_id', $creatorId)
           ->select(
               DB::raw('SUM(count_products) as count')
           )
           ->first();
            if (isset($data[$creatorId])) {
                $data[$creatorId] = 0;
            }
            $data[$creatorId] = $creator->count;
        }
        return $data;
    }

    private function getCreatorQuantityAndRevenueAndCost($filter)
    {
        $query = self::table('summary_actor_revenue_date')
            ->where('date', '>=', $filter['from_date'])
            ->where('date', '<=', $filter['to_date'])
            ->whereIn('actor_id', $this->creatorIds)
            ->select(
                'date',
                'actor_id',
                DB::raw('SUM(revenue) as revenue'),
                DB::raw('SUM(cost) as cost'),
                DB::raw('SUM(quantity) as quantity'),
                DB::raw('SUM(return_fee) as return_fee'),
                DB::raw('SUM(ads_cost) as ads_cost')
            )
            ->groupBy('actor_id');
        if (isset($filter['orders']) && count($filter['orders']) > 0) {
            foreach ($filter['orders'] as $key => $value) {
                $query->orderBy($key, $value);
            }
        }

        return $query->get();
    }

    private function calculateCreatorRevenueAndCostNewProduct($filter)
    {
        $orders = self::table('order as o')
            ->from(DB::raw("`sb_order` FORCE INDEX(`sa_inoutput_created_at`)"))
            ->join('order_item as oi', 'oi.order_id', '=', 'order.id')
            ->join('product as p', 'p.id', '=', 'oi.product_id')
            ->where('order.created_at', '>=', $filter['query_from'])
            ->where('order.created_at', '<=', $filter['query_to'])
            ->where('p.created_at', '>=', $filter['query_from'])
            ->where('p.created_at', '<=', $filter['query_to'])
            ->whereNotIn('order.status', ['CANCELED','RETURNED','REQUEST_RETURN'])
            ->where('order.payment_status', 'PAID')
            ->whereIn('p.actor_id', $this->creatorIds)
            ->select(
                'order.id',
                'oi.price',
                'p.actor_id',
                'oi.shipping_cost',
                'oi.cost',
                'oi.quantity',
                'oi.product_id',
                'order.return_fee',
                'order.country_id',
                'order.shipping_configurations',
                'oi.product_sku_id',
                'oi.id as order_item_id'
            )
            ->get();
        return $this->buildCreatorRevenueAndCostData($orders, $filter);
    }

    private function calculateCreatorRevenueAndCostAllProduct($filter)
    {
        $minDate = $filter['date_old_product_from'];
        $maxDate = $filter['date_old_product_to'];
        $orders = self::table('order as o')
            ->from(DB::raw("`sb_order` FORCE INDEX(`sa_inoutput_created_at`)"))
            ->join('order_item as oi', 'oi.order_id', '=', 'order.id')
            ->join('product as p', 'p.id', '=', 'oi.product_id')
            ->where('order.created_at', '>=', $filter['query_from'])
            ->where('order.created_at', '<=', $filter['query_to'])
            ->whereNotIn('order.status', ['CANCELED','RETURNED','REQUEST_RETURN'])
            ->where('order.payment_status', 'PAID')
            ->whereIn('p.actor_id', $this->creatorIds)
            ->where('p.created_at', '>=', $minDate)
            ->where('p.created_at', '<=', $maxDate)
            ->select(
                'order.id',
                'oi.price',
                'p.actor_id',
                'oi.shipping_cost',
                'oi.cost',
                'oi.quantity',
                'oi.product_id',
                'order.return_fee',
                'order.country_id',
                'order.shipping_configurations',
                'oi.product_sku_id',
                'oi.id as order_item_id'
            )
            ->get();
        return $this->buildCreatorRevenueAndCostData($orders, $filter);
    }

    private function buildCreatorRevenueAndCostData ($orders, $filter) {
        $data = [];
        $orderIds = [];
        $productIds = [];
        foreach ($orders as $order) {
            $actorId = $order->actor_id ? $order->actor_id : 1;
            if (!in_array($actorId, $this->creatorIds)) {
                continue;
            }
            $productId = $order->product_id;
            if(!array_key_exists($actorId, $data)) {
                $data[$actorId] = [
                    'revenue' => 0,
                    'cost' => 0,
                    'quantity' => 0,
                    'ads_cost' => 0,
                    'return_fee' => 0,
                    'actor_id' => $actorId,
                    'count_products' => 0,
                    'actor_name' => null
                ];
                $orderIds[$actorId] = [];
                $productIds[$actorId] = [];
            }
            if (!in_array($productId, $productIds[$actorId])) {
                $data[$actorId]['ads_cost'] += $this->getProductAdsCost($filter, $productId);
                $productIds[$actorId][] = $productId;
            }

            if (!in_array($order->id, $orderIds[$actorId])) {
                $data[$actorId]['return_fee'] += $order->return_fee;
                $orderIds[$actorId][] = $order->id;
            }
            if (!$order->cost) {
                $warehouseId = $this->getWarehouseId($order->order_item_id, $order->shipping_configurations);
                if ($order->product_sku_id) {
                    $order->cost = $this->fetchCost($order->product_sku_id, $order->country_id, $warehouseId, $this->locale) * $order->quantity;
                }
            }
            
            $data[$actorId]['revenue'] += $order->quantity * $order->price;
            $data[$actorId]['cost'] += $order->shipping_cost + $order->cost;
            $data[$actorId]['quantity'] += $order->quantity;
        }

        if ($this->locale != 'us') {
            foreach ($data as $actorId => $dataActor) {
                $data[$actorId]['revenue'] = $data[$actorId]['revenue'] ? round($data[$actorId]['revenue'] / $this->currencyRatio, 2) : $data[$actorId]['revenue'];
                $data[$actorId]['cost'] = $data[$actorId]['cost'] ? round($data[$actorId]['cost'] / $this->currencyRatio, 2) : $data[$actorId]['cost'];
                $data[$actorId]['return_fee'] = $data[$actorId]['return_fee'] ? round($data[$actorId]['return_fee'] / $this->currencyRatio, 2) : $data[$actorId]['return_fee'];
            }
        }

        return json_decode(json_encode($data), true);
    }

    private function getProductAdsCost($filter, $productId)
    {
        $cost = 0;
        $adsCost = self::table('product_cost_ads as pca')
            ->where('date', '>=', $filter['from_date'])
            ->where('date', '<=', $filter['to_date'])
            ->where('product_id', $productId)
            ->select(DB::raw('SUM(sb_pca.cost) as cost'))
            ->first();
        if ($adsCost) {
            $cost = $adsCost->cost;
        }
        return $cost;
    }

    private function getCreator($email = null)
    {
        $roleNPermissions = self::table('role_n_permission as rnp')
            ->leftJoin('permission as p', 'p.id', '=', 'rnp.permission_id')
            ->where('p.value', '=', 'content_product')
            ->get(['rnp.role_id', 'rnp.permission_id']);
        $roleIds = [];
        foreach ($roleNPermissions as $item) {
            $roleIds[] = $item->role_id;
        }

        if (!empty($roleIds)) {
            if (isset($email)) {
                $roleNUsers = self::table('role_n_user as rnu')
                    ->leftJoin('users as u', 'u.id', '=', 'rnu.user_id')
                    ->whereIn('rnu.role_id', $roleIds)
                    ->where('u.id', $email)
                    ->where('status', '=', 'ACTIVE')
                    ->get(['u.email', 'u.name', 'u.id']);
            } else {
                $roleNUsers = self::table('role_n_user as rnu')
                    ->leftJoin('users as u', 'u.id', '=', 'rnu.user_id')
                    ->whereIn('rnu.role_id', $roleIds)
                    ->whereNotIn('u.email', $this->ignoreEmails)
                    ->where('status', '=', 'ACTIVE')
                    ->get(['u.email', 'u.name', 'u.id']);
            }

            foreach ($roleNUsers as $user) {
                if ($user->email != null) {
                    $this->creatorIds[] = $user->id;
                }
            }
        }
    }

    private function getCurrencyByLocale ()
    {
        if (function_exists('getModuleLocale')) {
            $locales = getModuleLocale();
            $locale = current(array_filter($locales, function($config) {
                return $config['locale'] == $this->locale;
            }));
            if (!empty($locale['currencyRatio'])) {
                $this->currencyRatio = $locale['currencyRatio'];
            }
        }
    }

    private function buildFilterV2(Request $request) {
        $params = ['actor_id'];
        $retVal = [];
        foreach ($params as $param) {
            if ($request->has($param)) {
                $retVal[$param] = $request->input($param);
            }
        }
        $sort = $request->has('sort') ? $request->input('sort') : '';
        if ($sort != '') {
            $retVal['sort'] = $sort;
            $arrOrders = explode('-', $retVal['sort']);
            $retVal['orders'] = [$arrOrders[0] => $arrOrders[1]];
        }
        $currentDate = new \DateTime();
        $retVal['from_date'] = $request->has('dateFrom') ?  $request->input('dateFrom') : $currentDate;
        $retVal['to_date'] = $request->has('dateTo') ?  $request->input('dateTo') : $currentDate;
        $retVal['query_from'] = $request->has('dateFrom') ?  $request->input('dateFrom') : $currentDate;
        $retVal['query_to'] = $request->has('dateTo') ?  $request->input('dateTo') : $currentDate;
        if ($request->has("date_new_product_from")) {
            $retVal["date_new_product_from"] = $request->input("date_new_product_from");
        }
        if ($request->has("date_new_product_to")) {
            $retVal["date_new_product_to"] = $request->input("date_new_product_to");
        }
        if ($request->has("date_old_product_from")) {
            $retVal["date_old_product_from"] = $request->input("date_old_product_from");
        }
        if ($request->has("date_old_product_to")) {
            $retVal["date_old_product_to"] = $request->input("date_old_product_to");
        }
        $retVal['page_id'] = $request->has('page_id') ? $request->input('page_id') : 0;
        $retVal['page_size'] = $this->pageSize;
        return $retVal;
    }

    public function indexCreatorRevenueV2 (Request $request) {
        $users = self::table('users')->where('role', 'STAFF')->pluck('name', 'id');
        $locates = getModuleLocale();
        $marketEnableds = [];

        foreach ($locates as $locale) {
            if ($locale['enable'] && $locale['locale'] != 'central') {
                $this->locales[$locale['locale']] = $locale['name'];
            }
        }

        return view('reports::creator-revenue-v2.index', ['users' => $users, 'locates' => $this->locales]);
    }

    private function calculateCreatorRevenueAndCostAllProductV2($filter)
    {
        $query = self::table('order as o')
            ->from(DB::raw("`sb_order` FORCE INDEX(`sa_inoutput_created_at`)"))
            ->join('order_item as oi', 'oi.order_id', '=', 'order.id')
            ->join('product as p', 'p.id', '=', 'oi.product_id')
            ->where('order.created_at', '>=', $filter['query_from'])
            ->where('order.created_at', '<=', $filter['query_to'])
            ->whereNotIn('order.status', ['CANCELED', 'RETURNED', 'REQUEST_RETURN'])
            ->where('order.payment_status', 'PAID')
            ->whereIn('p.actor_id', $this->creatorIds)
            ->select(
                'order.id',
                'order.amount',
                'order.shipping_fee',
                'order.discount',
                'order.other_fee',
                'order.tips',
                'order.tax',
                'order.used_rewards',
                'p.actor_id',
                'oi.quantity',
                'oi.price',
                'oi.product_id',
                'order.code',
                'order.cost',
                'order.country_id',
                'oi.product_sku_id',
                'oi.id as order_item_id',
                'p.note as product_note'
            );
        if (isset($filter["date_new_product_from"])) {
            $query->where('p.created_at', '>=', $filter["date_new_product_from"]);
        }
        if (isset($filter["date_new_product_to"])) {
            $query->where('p.created_at', '<=', $filter["date_new_product_to"]);
        }

        if (isset($filter['date_old_product_to'])) {
            $query->where('p.created_at', '<=', $filter['date_old_product_to']);
        }
        $orders = $query->get();
        $dataOrders = [];
        foreach ($orders as $order) {
            if (
                !$order->product_note 
                || (
                    $order->product_note && (str_contains($order->product_note, 'url:'))
                )
            ) {
                $dataOrders[] = $order;
            }
        }

        return $this->buildCreatorRevenueAndCostDataV2($dataOrders, $filter);
    }

    private function buildCreatorRevenueAndCostDataV2 ($orders, $filter) {
        $data = [];
        $orderIds = [];
        $productIds = [];
        $orderProfitByCode = [];
        $orderItemsByCode = [];
        $test = [];
        foreach ($orders as $order) {
            $test[$order->code] = [];
            $actorId = $order->actor_id ? $order->actor_id : 1;
            if (!in_array($actorId, $this->creatorIds)) {
                continue;
            }
            $productId = $order->product_id;
            if(!array_key_exists($actorId, $data)) {
                $data[$actorId] = [
                    'revenue' => 0,
                    'cost' => 0,
                    'quantity' => 0,
                    'actor_id' => $actorId,
                    'count_products' => 0,
                    'actor_name' => null
                ];
                $orderIds[$actorId] = [];
                $productIds[$actorId] = [];
            }
            if (!in_array($productId, $productIds[$actorId])) {
                $productIds[$actorId][] = $productId;
            }

            if (!in_array($order->id, $orderIds[$actorId])) {
                $orderIds[$actorId][] = $order->id;
            }
            if (!array_key_exists($order->code, $orderProfitByCode)) {
                $profitInfo = $this->fetchProfitInfo($order->code, $this->locale);
            } else {
                $profitInfo = $orderProfitByCode[$order->code];
            }
            $orderProfitByCode[$order->code] = $profitInfo;
            $orderItemsByCode = [];
            if (!array_key_exists($order->code, $orderItemsByCode)) {
                $items = self::table('order_item as o')->where("order_id", $order->id)->get();
            } else {
                $items = $orderItemsByCode[$order->code];
            }
            $orderItemsByCode[$order->code] = $items;
            $subTotal = 0;
            foreach ($items as $item) {
                $subTotal += $item->price * $item->quantity;
            }
            $orderAmountByItem = $order->price * $order->quantity;
            $order->shipping_cost = isset($order->shipping_cost) && $order->shipping_cost ? $order->shipping_cost : 0;
            $order->payment_gate_fee = isset($order->payment_gate_fee) && $order->payment_gate_fee ? $order->payment_gate_fee : 0;
            if (isset($profitInfo['products'])) {
                $totalCost = 0;
                foreach ($profitInfo['products'] as $key => $product) {
                    if (isset($product["product_sku_id"])) {
                        if ($product["product_sku_id"] == $order->product_sku_id) {
                            $order->cost = $product["costAfter"] * $product["quantity"];
                        }
                    } else {
                        if ($product["product_id"] == $order->product_id) {
                            $order->cost = $product["costAfter"] * $product["quantity"];
                        }
                    }
                    $totalCost += $product["costAfter"] * $product["quantity"];
                }
                $order->shipping_cost = $totalCost != 0 ? ($order->cost / $totalCost) * $profitInfo['shipping_fee_cost'] : 0;
                $order->payment_gate_fee = $totalCost != 0 ? ($order->cost / $totalCost) * $profitInfo['payment_gate_fee'] : 0;
                $order->tax_cost = $totalCost != 0 ? ($order->cost / $totalCost) * $profitInfo['tax'] : 0;
                $order->shipping_fee = ($orderAmountByItem / $subTotal) * $order->shipping_fee;
                $order->discount = ($orderAmountByItem / $subTotal) * $order->discount;
                $order->other_fee = ($orderAmountByItem / $subTotal) * $order->other_fee;
                $order->tips = ($orderAmountByItem / $subTotal) * $order->tips;
                $order->tax = ($orderAmountByItem / $subTotal) * $order->tax;
                $order->used_rewards = ($orderAmountByItem / $subTotal) * $order->used_rewards;
            } else {
                $order->cost = $order->cost / count($items);
            }
            $test[$order->code][] = [
                'shipping_cost' => $order->shipping_cost,
                'order_cost' => $order->cost,
            ];
            
            $data[$actorId]['revenue'] += $orderAmountByItem + $order->shipping_fee + $order->discount + $order->other_fee + $order->tips + $order->tax + $order->used_rewards;
            $data[$actorId]['cost'] += $order->shipping_cost + $order->cost + $order->payment_gate_fee + $order->tax;
            $data[$actorId]['quantity'] += $order->quantity;
        }
        if (isset($_GET['debug'])) {
            dd($test);
        }

        if ($this->locale != 'us') {
            foreach ($data as $actorId => $dataActor) {
                $data[$actorId]['revenue'] = $data[$actorId]['revenue'] ? round($data[$actorId]['revenue'] / $this->currencyRatio, 2) : $data[$actorId]['revenue'];
                $data[$actorId]['cost'] = $data[$actorId]['cost'] ? round($data[$actorId]['cost'] / $this->currencyRatio, 2) : $data[$actorId]['cost'];
            }
        }

        return json_decode(json_encode($data), true);
    }

    private function countProductKeyByActorIdV2 ($filter) {
        $data = [];
        foreach ($this->creatorIds as $creatorId) {
            $query = self::table('count_content_product_date as p')
                ->where('p.actor_id', $creatorId)
                ->select(
                    DB::raw('SUM(count_products) as count')
                );
        
            if (isset($filter['date_old_product_from'])) {
                $query->where('date', '<=', $filter['date_old_product_from']);
            }
            if (isset($filter['date_new_product_from'])) {
                $query->where('date', '>=', $filter['date_new_product_from']);
            }
            if (isset($filter['date_old_product_to'])) {
                $query->where('date', '<=', $filter['date_old_product_to']);
            }
            $creator = $query->first();
            if (isset($data[$creatorId])) {
                $data[$creatorId] = 0;
            }
            $data[$creatorId] = $creator->count;
        }
        return $data;
    }


    public function findReportCreatorRevenueV2(Request $request) {
        set_time_limit(60 * 60 * 5);
        $retVal = [
            'status' => 'fail',
            'result' => []
        ];
        if (!$this->checkToken($request)) {
            return $retVal;
        }
        $this->locale = $request->get('locate', 'us');
        self::setConnection($this->locale);
        $this->getCreator($request->input("email", null));
        $this->getCurrencyByLocale();
        $filter = $this->buildFilterV2($request);
        $countProducts = $this->countProductKeyByActorIdV2($filter);
        $revenueQuantities = $this->calculateCreatorRevenueAndCostAllProductV2($filter);
        $actorKeyById = self::table('users')
            ->where('role', 'STAFF')
            ->pluck('name', 'id')
            ->toArray();
        $data = [];
        foreach ($countProducts as $actorId => $countProduct) {
            if (isset($revenueQuantities[$actorId])) {
                $data[$actorId] = $revenueQuantities[$actorId];
                $data[$actorId]['count_products'] = $countProduct;
            } else {
                $data[$actorId] = [
                    'revenue' => 0,
                    'cost' => 0,
                    'quantity' => 0,
                    'actor_id' => $actorId,
                    'count_products' => $countProduct,
                    'actor_name' => null,
                ];
            }
            if (isset($actorKeyById[$actorId])) {
                $data[$actorId]['actor_name'] = $actorKeyById[$actorId];
            } else {
                $data[$actorId]['actor_name'] = null;
            }

        }
        $urlDownload = $this->sendEmailRevenue($data);
        if ($urlDownload) {
            $retVal['result'] = $urlDownload;
        }
        $retVal['status'] = 'successful';
        return $retVal;
    }

    private function sendEmailRevenue($products = [])
    {
        $urlDownload = null;
        if (!empty($products)) {
            $exportData = [];
            $columns = ['actor_id', 'actor_name', 'count_products', 'quantity', 'revenue', 'cost', 'profit', 'conversion_rate'];

            foreach ($products as &$item) {
                $data = [];
                $item['profit'] = $item['revenue'] - $item['cost'];
                $item['conversion_rate'] = $item['count_products'] ? round($item['quantity'] / $item['count_products'] * 100, 2) : 0;

                foreach ($columns as $column) {
                    if (isset($item[$column])) {
                        $data[] = strval($item[$column]);
                    }
                }
                $exportData[] = $data;
            }
            ob_end_clean();
            $retVal = Excel::create('creator-revenue-' . time(), function($excel) use ($exportData) {
                $excel->setTitle('export_creator_revenue')->setCreator('Megaads')->setCompany('Megaads');
                $excel->sheet('Danh sách', function($sheet) use ($exportData) {
                    $sheet->row(1, [
                        '#', 'Nhân viên', 'Sản phẩm', 'SL bán', 'Doanh thu', 'Giá vốn', 'Lợi nhuận', 'Tỉ lệ chuyển đổi'
                    ]);

                    foreach ($exportData as $value) {
                        $sheet->appendRow($value);
                    }
                });

            })->store('xlsx', false, true);
            $urlDownload = route('system::download', ['fileName' => $retVal['file'], 'type' => 'exports', 'time' => time()]);
        }
         // get current user's email
        $user = auth()->user();
        if ($user) {
            $email = $user->email;
            $this->triggerSyncRequest(env('API_URL') . '/api/send-email-manual', 'POST', [
                'email' => $email,
                'subject' => 'Export Creator Report Successful',
                'content' => 'Download: <a href="' . $urlDownload . '" target="_blank">' . $urlDownload . '</a>'
            ], [
                'Content-Type: application/json'
            ]);
        }
        return $urlDownload;
    }
}