<?php

namespace Modules\Reports\Controllers;


use Illuminate\Http\Request;
use Modules\Reports\Controllers\Controller;
use App\Helpers\DBConnect;
use DateTime;
use DB;
class DesignController extends Controller
{
    protected $pageSize = 40;
    protected $locales = [];
    protected $users = [];
    protected $userByLocates = [];
    protected $market = 'us';
    protected $configName = 'market_us';
    public function __construct() {
        $this->initCl();
        $locate = env('APP_LOCALE');
        if ($locate && $locate != '' && $locate != null && $locate != 'central') {
            $this->market = $locate;
            $this->configName = 'market_' . $locate;
        }
    }

    private function initCl() {
        $locates = getModuleLocale();
        $marketEnableds = [];
        foreach ($locates as $locale) {
            if ($locale['enable'] && $locale['locale'] != 'central') {
                $marketEnableds[] = $locale['locale'];
                $this->locales[$locale['locale']] = $locale['name'];
            }
        }
    }

    public function index (Request $request) {
        $connect = DBconnect::connect($this->market);
        $sources = $connect->table('source')
                            ->pluck('name', 'id');
        return view('reports::design.index', ['locates' => $this->locales, 'sources' => $sources]);
    }

    public function find(Request $request) {
        set_time_limit(3600);
        ini_set('memory_limit','4096M');
        $filter = $this->buildFilter($request);
        $connect = DBconnect::connect($filter['locate']);
        if ($filter['classify'] == 'source') {
            $result = $this->getDataSource($filter, $connect);
        } else {
            $result = $this->getResult($filter, $connect);
        }
        $pageId = $filter['page_id'];
        unset($filter['page_size']);
        unset($filter['page_id']);
        $filter['metric'] = 'count';
        $itemCount = $this->getResult($filter, $connect);
        $pagesCount = $this->recordsCountToPagesCount($itemCount, $this->pageSize);
        $this->decorResultSource($result, $connect);
        $response = [
            'status' => 'successful',
            'pagesCount' => $pagesCount,
            'result' => $result
        ];
        
        return response()->json($response);
    }

    private function decorResultSource(&$items, $connect) {
        $sourceIds = [];
        $staffIds = [];
        $productAuthorIds = [];
        $categoryIds = [];
        foreach ($items as $item) {
            if (isset($item->source_id)) {
                $sourceIds[] = $item->source_id;
            }
            if (isset($item->design_author_id)) {
                if ($item->design_author_id != null) {
                    $staffIds[] = $item->design_author_id;
                }
            }
            if (isset($item->product_author_id)) {
                if ($item->product_author_id != null) {
                    $productAuthorIds[] = $item->product_author_id;
                }
            }
            if (isset($item->category_id)) {
                $categoryIds[] = $item->category_id;
            }
        }
        if (!empty($sourceIds)) {
            $sources = $connect->table('report_product_sourcing')
                            ->whereIn('id', $sourceIds)
                            ->pluck('name', 'id');
            foreach ($items as $item) {
                $item->source = $sources[$item->source_id];
            }
        }
        if (!empty($staffIds)) {
            $connectCentral = DBconnect::connect();
            $staffs = $connectCentral->table('users')
                            ->whereIn('id', $staffIds)
                            ->pluck('name', 'id');
            foreach ($items as $item) {
                if (isset($staffs[$item->design_author_id])) {
                    $item->staff = $staffs[$item->design_author_id];
                }
                
            }
        }
        if (!empty($productAuthorIds)) {
            $productStaffs = $connect->table('users')
                            ->whereIn('id', $productAuthorIds)
                            ->pluck('name', 'id');
            foreach ($items as $item) {
                if (isset($productStaffs[$item->product_author_id])) {
                    $item->staff = $productStaffs[$item->product_author_id];
                }
            }
        }
        if (!empty($categoryIds)) {
            $categories = $connect->table('category')
                            ->whereIn('id', $categoryIds)
                            ->pluck('name', 'id');
            foreach ($items as $item) {
                $item->category = $categories[$item->category_id];
            }
        }
    }

    private function buildSources($connect) {
        return $connect->table('report_product_sourcing')
                        ->pluck('name', 'id');
    }

    
    private function getResult($filter, $connect) {
        $query = $connect->table('report_product_sale as rps');
        $query->join('report_product_author as rpa', 'rpa.product_id', '=', 'rps.product_id');
        $query->join('product as p', 'p.id', '=', 'rps.product_id');
        $query->where('p.status', '=', 'ACTIVE');
        $query->where('rpa.type', '=', 'create');
        if (isset($filter['query_from']) && $filter['query_from'] != '') {
            $query->where('rps.date', '>=', $filter['query_from']);
        }
        if (isset($filter['query_to']) && $filter['query_to'] != '') {
            $query->where('rps.date', '<=', $filter['query_to']);
        }
        if (isset($filter['source']) && $filter['source'] != '') {
            $query->where('rpa.source_id', '=', $filter['source']);
        }
        if (isset($filter['classify'])) {
            if ($filter['classify'] == 'category') {
                $query->join('product_n_category as pnc', 'pnc.product_id', '=', 'rps.product_id');
                $query->where('pnc.is_parent', '=', 0);
                $query->groupBy('pnc.category_id');
                $query->select('pnc.category_id', 
                                \DB::raw("sum(sale) as sale"), 
                                \DB::raw("sum(quantity) as quantity"),
                                \DB::raw("sum(revenue) as revenue"),
                                \DB::raw("sum(cost) as cost"),
                                \DB::raw("sum(revenue) - sum(cost) as profit"));
                $keyClassify = 'category_id';
                $query->distinct();
            } else if ($filter['classify'] == 'staff') {
                $query->groupBy('rpa.design_author_id');
                $query->select('rpa.design_author_id',
                                \DB::raw("sum(sale) as sale"), 
                                \DB::raw("sum(quantity) as quantity"),
                                \DB::raw("sum(revenue) as revenue"),
                                \DB::raw("sum(cost) as cost"));
                $keyClassify = 'design_author_id';
            } else if ($filter['classify'] == 'product') {
                $query->groupBy('rpa.product_author_id');
                $query->select('rpa.product_author_id',
                                \DB::raw("sum(sale) as sale"), 
                                \DB::raw("sum(quantity) as quantity"),
                                \DB::raw("sum(revenue) as revenue"),
                                \DB::raw("sum(cost) as cost"));
                $keyClassify = 'product_author_id';
            } else if ($filter['classify'] == 'source') {
                $query->groupBy('rpa.source_id');
                $query->select('rpa.source_id', 
                                    \DB::raw("sum(sale) as sale"), 
                                    \DB::raw("sum(quantity) as quantity"),
                                    \DB::raw("sum(revenue) as revenue"),
                                    \DB::raw("sum(cost) as cost"));
                $keyClassify = 'source_id';
            }
        }
        
        if (isset($filter['metric']) && $filter['metric'] == 'count') {
            return count($query->get());
        } else {
            if (isset($filter['orders']) && count($filter['orders']) > 0) {
                foreach ($filter['orders'] as $key => $value) {
                    $query->orderBy($key, $value);
                }
            }
            if (isset($filter['page_size']) && isset($filter['page_id'])) {
                $query->forPage($filter['page_id'] + 1, $filter['page_size']);
            }
            $countProductsByClassifyKey = $this->countProduct($keyClassify, $filter, $connect);
            $dataResult = $query->get();
            foreach ($dataResult as $value) {
                if (isset($countProductsByClassifyKey[$value->$keyClassify])) {
                    $value->countProducts = $countProductsByClassifyKey[$value->$keyClassify]; 
                } else {
                    $value->countProducts = 0;
                }
            }
            return $dataResult;
        }
    }

    private function getMinMaxId($type, $date, $connect)
    {
        if ($type == 1) {
            $minMaxId = $connect->table('product')->where('created_at', '>=', $date)->orderBy('id', 'ASC')->first();
        } else {
            $minMaxId = $connect->table('product')->where('created_at', '<', $date)->orderBy('id', 'DESC')->first();
        }

        return $minMaxId ? $minMaxId->id : 0;
    }
    private function getDataSource($filter, $connect) {
        $minId = $this->getMinMaxId(1, $filter['query_from'], $connect);
        $maxId = $this->getMinMaxId(2, $filter['query_to'], $connect);
//        $minId = 1;
//        $maxId = 1000000;

        $query = $connect->table('product_actor_source as ps')
            ->join('order_item as oi', 'oi.product_id', '=', 'ps.product_id')
            ->join('order', 'order.id', '=', 'oi.order_id')
            ->join('source', 'source.id', '=', 'ps.source_id')
            ->select('ps.product_id', 'oi.quantity', 'oi.price', 'order.id as order_id', 'source.name as source_name')
            ->where('order.payment_status', 'PAID');
        if (isset($filter['source'])) {
            $query->where('ps.source_id', $filter['source']);
        }

        $query->whereBetween('ps.product_id', array($minId, $maxId));
        $result = $query->get();
        $data = [];
        foreach ($result as $val) {
            if(isset($data[$val->source_name])) {
                $data[$val->source_name]['sale'] += $val->quantity;
                $data[$val->source_name]['revenue'] += ($val->quantity * $val->price);
                if (!in_array($val->product_id, $data[$val->source_name]['arrayProducts'])) {
                    array_push($data[$val->source_name]['arrayProducts'], $val->product_id);
                }
            } else {
                $data[$val->source_name]['sale'] = $val->quantity;
                $data[$val->source_name]['arrayProducts'] = [];
                array_push($data[$val->source_name]['arrayProducts'], $val->product_id);
                $data[$val->source_name]['revenue'] = ($val->quantity * $val->price);
                $data[$val->source_name]['source'] = $val->source_name;
            }
        }
        foreach ($data as $key => $item) {
            $data[$key]['countProducts'] = count($item['arrayProducts']);
        }
        return $data;
    }

    private function countProduct($key, $filter, $connect)
    {
        $query = $connect->table('report_product_author');
        $query->where('type', '=', 'create');
        if (isset($filter['query_from']) && $filter['query_from'] != '') {
            $query->where('product_change_log', '>=', $filter['query_from']);
        }
        if (isset($filter['query_to']) && $filter['query_to'] != '') {
            $query->where('product_change_log', '<=', $filter['query_to']);
        }
        if($key == 'category_id') {
            return $query->join('product_n_category as pnc', 'pnc.product_id', '=', 'report_product_author.product_id')
                ->where('pnc.is_parent', '=', 0)
                ->groupBy('pnc.category_id')
                ->pluck(\DB::raw("count(*)"), $key);
        } else {
            return $query->groupBy($key)
                ->pluck(\DB::raw("count(*)"), $key);
        }
         
    }

    private function buildFilter($request) {
        $params = ['source', 'locate', 'classify'];
        $retVal = [];
        foreach ($params as $param) {
            if ($request->has($param)) {
                $retVal[$param] = $request->input($param);
            }
        }
        $sort = $request->has('sort') ? $request->input('sort') : '';
        if ($sort != '') {
            $retVal['sort'] = $sort;
            $arrOrders = explode('-', $retVal['sort']);
            $retVal['orders'] = [$arrOrders[0] => $arrOrders[1]];
        }
        $currentDate = new \DateTime();
        $fromDate = $request->has('dateFrom') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateFrom')) : $currentDate;
        $toDate = $request->has('dateTo') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateTo')) : $currentDate;
        $retVal['query_from'] = $fromDate->setTime(0, 0, 0);
        $retVal['query_to'] = $toDate->setTime(23,59,59);
        $retVal['page_id'] = $request->has('page_id') ? $request->input('page_id') : 0;
        $retVal['page_size'] = $this->pageSize;
        return $retVal;
    }

    private function recordsCountToPagesCount($recordsCount, $pageSize)
    {
        $retVal = (int)($recordsCount / $pageSize);
        if ($recordsCount % $pageSize > 0) {
            $retVal++;
        }
        //return
        return $retVal;
    }
    private function getMinMaxIdOfProducts ($fromDate, $toDate, $type)
    {
        if ($type == 'max') {
            $result = DB::table('product as p')
                ->whereBetween('created_at', [$fromDate, $toDate])
                    ->orderBy('id', 'desc')
                    ->limit(1)
                    ->first(['id']);

        } else {
            $result = DB::table('product as p')
                ->whereBetween('created_at', [$fromDate, $toDate])
                ->orderBy('id', 'asc')
                ->limit(1)
                ->first(['id']);
        }
        return $result->id;
    }

    public function buildReportProductDesign(Request $request)
    {
        set_time_limit(3 * 3600);
        ini_set('memory_limit', '2048M');
        $date = new DateTime();
        
        $sources = $this->getSources();
        $type = $request->get('type');
        $yesterday = $date->sub(new \DateInterval('P1D'));
        $fromDate = $request->get('from_date', $yesterday->format('Y-m-d 00:00:00'));
        $toDate = $request->get('to_date', $yesterday->format('Y-m-d 23:59:59'));

        $maxId = $this->getMinMaxIdOfProducts($fromDate, $toDate, 'max');
        $minId = $this->getMinMaxIdOfProducts($fromDate, $toDate, 'min');
        for ($i = $minId; $i < $maxId ; $i+= 5000) {
            $fromId = $i;
            $toId = $i + 4999 > $maxId ? $maxId : $i + 4999;
            $dataCreate = [];
            $dataNewestProducts = $this->getDataNewestProductBuildReport($type, $fromId, $toId); 
            $productsHasDesign = DB::table('product_n_design as pnd')
                ->whereIn('product_id', array_column($dataNewestProducts, 'id'))
                ->where('is_primary', 1)
                ->orderBy('design_id')
                ->get()
                ->groupBy('product_id')
                ->toArray();
            $designIds = [];
            foreach ($productsHasDesign as $product) {
                $designIds[] = $product[0]->design_id;
            }
            $productDesignIds = DB::table('product_n_design as pnd')
            ->join('product as p', 'p.id', '=', 'pnd.product_id')
            ->whereIn('design_id', $designIds)
            ->orderBy('product_id')
            ->get()
            ->groupBy('design_id')
            ->toArray();
            foreach ($dataNewestProducts as $product) {
                $product->design_id = isset($productsHasDesign[$product->id]) ? $productsHasDesign[$product->id][0]->design_id : null;
                if ($product->design_id) {
                    $product->base_id = $productDesignIds[$product->design_id][0]->product_id;
                } else {
                    $product->base_id = $product->id;
                }
                $dataCreate[] = $this->buildDataInsertToReportProductDesignAuthor($product, 'create', $sources);
            }
            DB::table('report_product_author')->insert($dataCreate);
        }
        if($type !== 'create_old') {
            $this->buildReportDataUpdatedProduct($fromDate, $toDate);
            $this->buildReportProductHasNewDesign($fromDate, $toDate);
        }

        return [
            'status' => 'successful',
            'result' => $minId . '-' . $maxId,
        ];
    }
    private function buildDataInsertToReportProductDesignAuthor($product, $type, &$sources)
    {
        $retVal = [];

        $skipSource = config('reports::sa.skip-source', []);
        $source = 'design';
        $productAuthorId = null;

        $idProductBase = $product->base_id;
        $productMetas = DB::table('product_meta')->where('product_id', $idProductBase)->get();
        foreach ($productMetas as $productMeta) {
            if (
                isset($productMeta->key)
                && str_contains($productMeta->key, '_crawl_code')
                && $productMeta->key != 'design_crawl_code'
            ) {
                if (in_array($productMeta->key, $skipSource)) {
                    return $retVal;
                }
                $source = str_replace('_crawl_code', '', $productMeta->key);
            }
        }
        if ($type == 'create') {
            $productBase =  DB::table('product')->where('id', $idProductBase)->first();
            $productAuthorId = $productBase->actor_id;
        } else {
            $productAuthorId = $product->updator_id;
        }
        if (!$productAuthorId) {
            foreach ($productMetas as $productMeta) {
                if (isset($productMeta->key) && str_contains($productMeta->key, 'user_id')) {
                    $productAuthorId = $productMeta->value;
                }
            }
        }

        $date = new Datetime();
        $locale = env("APP_LOCALE");
        if ($locale == "") {
            $locale = "us";
        }

        $connectionCentral = DBconnect::connect();
        $designJob = $connectionCentral->table('design_job')
        ->where('product_id', $idProductBase)
            ->where('local_code',  $locale)
            ->where('status', 'done')
            ->whereNotNull('designer_id')
            ->orderBy('id')
            ->first();
        $desingerId = $designJob ? $designJob->designer_id : null;
        $designChangeLog = $designJob ? new DateTime($designJob->finished_at) : null;
        $dateChangeLog = new DateTime($product->product_change_log);
        if (!isset($sources[$source])) {
            $sources = $this->getSources($source);
        }
        $sourceId =  $sources[$source][0]->id;

        $retVal =
            [
                'type' => $type,
                'product_id' => $product->id,
                'design_id' => $product->design_id,
                'product_author_id' => $productAuthorId,
                'design_author_id' => (!$desingerId && $product->design_id) ? $productAuthorId : $desingerId,
                'design_change_log' => $designChangeLog ? $designChangeLog->format('Y-m-d') : null,
                'source_id' => $sourceId,
                'created_at' => $date,
                'updated_at' => $date,
                'product_change_log' => $dateChangeLog->format('Y-m-d'),
            ];

        return $retVal;
    }

    private function getDataNewestProductBuildReport ($type, $fromId, $toId)
    {
        $retVal = [];
        $date = new DateTime();
        $retVal = DB::table('product as p')
            ->where('p.id', '>=' ,$fromId)
            ->where('p.id', '<=' , $toId)
            ->whereNull('deleted_at')
            ->get(['p.id', 'p.created_at as product_change_log'])
            ->toArray();
        return $retVal;
    }

    private function buildReportProductHasNewDesign($dateFrom, $dateTo)
    {
        $retVal['dataProductsHasNewDesign'] = DB::table('product_n_design as pnd')
        ->whereBetween(
            'pnd.created_at',
            [$dateFrom, $dateTo]
        )
            ->where('pnd.is_primary', 1)
            ->groupBy('pnd.product_id')
            ->get(['pnd.product_id as id', 'pnd.design_id', 'pnd.created_at as design_change_log'])
            ->toArray();

        if (isset($dataProductsHasNewDesign)) {
            $locale = env("APP_LOCALE");
            if ($locale == "") {
                $locale = "us";
            }
            $connectionCentral = DBconnect::connect();
            foreach ($dataProductsHasNewDesign as $product) {
                $designJob = $connectionCentral->table('design_job')
                    ->where('product_id', $product->id)
                    ->where('local_code',  $locale)
                    ->where('status', 'done')
                    ->orderBy('id')
                    ->first();
                $desingerId = $designJob ? $designJob->designer_id : null;
                $dateChangeLog = new DateTime($product->design_change_log);
                DB::table('report_product_author')
                ->where('product_id', $product->id)
                    ->where('type', 'create')
                    ->update([
                        'design_id' => $product->design_id,
                        'design_author_id' => $desingerId,
                        'design_change_log' => $dateChangeLog->format('Y-m-d'),
                        'updated_at' => new DateTime()
                    ]);
            }
        }
    }

    private function getSources($sourceName = null)
    {
        if ($sourceName) {
            $data = [
                'name' => $sourceName,
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ];
            DB::table('report_product_sourcing')->insert($data);
        }
        return DB::table('report_product_sourcing')
        ->get()
            ->groupBy('name')
            ->toArray();
    }

    private function buildReportDataUpdatedProduct ($fromDate, $toDate)
    {
        $sources = $this->getSources();
        $dataUpdatedProducts = DB::table('product_meta as pm')
        ->where('pm.key', 'update_content')
        ->whereBetween(
            'pm.updated_at',
            [$fromDate, $toDate]
        )
            ->get(['pm.product_id as id', 'pm.updated_at as product_change_log', 'pm.value as updator_id'])
            ->toArray();
        $pagination = 1000;
        $count = 0;
        if (isset($dataUpdatedProducts)) {
            $productsHasDesign = DB::table('product_n_design as pnd')
            ->whereIn('product_id', array_column($dataUpdatedProducts, 'id'))
                ->where('is_primary', 1)
                ->orderBy('design_id')
                ->get()
                ->groupBy('product_id')
                ->toArray();
            $designIds = [];
            foreach ($productsHasDesign as $product) {
                $designIds[] = $product[0]->design_id;
            }
            $productDesignIds = DB::table('product_n_design as pnd')
            ->join('product as p', 'p.id', '=', 'pnd.product_id')
            ->whereIn('design_id', $designIds)
                ->orderBy('product_id')
                ->get()
                ->groupBy('design_id')
                ->toArray();
            $dataUpdate = [];
            foreach ($dataUpdatedProducts as $product) {
                $count++;
                $product->design_id = isset($productsHasDesign[$product->id]) ? $productsHasDesign[$product->id][0]->design_id : null;
                if ($product->design_id) {
                    $product->base_id = $productDesignIds[$product->design_id][0]->product_id;
                } else {
                    $product->base_id = $product->id;
                }
                $dataUpdate[] = $this->buildDataInsertToReportProductDesignAuthor($product, 'update', $sources);
                if ($count == $pagination) {
                    DB::table('report_product_author')->insert($dataUpdate);
                    $dataUpdate = [];
                    $count = 0;
                }
            }
            DB::table('report_product_author')->insert($dataUpdate);
        }
    }

    public function reportCategory(Request $request)
    {
        $filter = $this->buildFilter($request);
        $countProductsOfCategory = $this->countProductsOfCategoryByCreateTime($filter);
        $countOrdersOfCategory = $this->countOrdersOfCategoryByCreateTime($filter);
        $orderProducts = DB::table('order')
            ->join('order_item as oi', 'oi.order_id', '=', 'order.id')
            ->join('product_n_category as pnc', 'pnc.product_id', '=', 'oi.product_id')
            ->join('category as c', 'c.id', '=', 'pnc.category_id')
            ->where('order.payment_status', 'PAID')
            ->whereNotIn('order.status', ['CANCELED', 'RETURNED'])
            ->where('order.created_at', '>=', $filter['query_from'])
            ->where('order.created_at', '<=', $filter['query_to'])
            ->where('pnc.is_parent', 0)
            ->select(
                'pnc.category_id',
                'c.name',
                \DB::raw("sum(sb_oi.cost) as cost"),
                \DB::raw("sum(quantity)")
            )
            ->groupBy('pnc.category_id')
            ->get();
        foreach ($orderProducts as $orderProduct) {
            if (isset($countProductsOfCategory[$orderProduct->category_id])) {
                $orderProduct->countProducts = $countProductsOfCategory[$orderProduct->category_id];
            } else {
                $orderProduct->countProducts = 0;
            }
            if (isset($countOrdersOfCategory[$orderProduct->category_id])) {
                $orderProduct->sale = $countOrdersOfCategory[$orderProduct->category_id]['sale'];
            } else {
                $orderProduct->sale = 0;
            }
            $orderProduct->profit = $orderProduct->revenue - $orderProduct->cost;
        }

        return
        [
            'status' => 'successful',
            'pagesCount' => count($orderProducts),
            'result' => $orderProducts
        ];
    }

    private function countProductsOfCategoryByCreateTime($filter)
    {
        $categories = DB::table('product_n_category as pnc')
            ->join('product as p', 'p.id', '=', 'pnc.product_id')
            ->where('p.status', 'ACTIVE')
            ->where('p.created_at', '>=', $filter['query_from'])
            ->where('p.created_at', '<=', $filter['query_to'])
            ->where('pnc.is_parent', 0)
            ->groupBy('pnc.category_id')
            ->pluck(DB::raw('count(product_id) as countProducts'), 'pnc.category_id' )
            ->toArray();
        return $categories;
    }

    private function countOrdersOfCategoryByCreateTime($filter)
    {
        $categories = DB::table('product_n_category as pnc')
            ->join('order_item as oi', 'oi.product_id', '=', 'pnc.product_id')
            ->join('order as o', 'o.id', '=', 'oi.order_id')
            ->where('o.created_at', '>=', $filter['query_from'])
            ->where('o.created_at', '<=', $filter['query_to'])
            ->where('o.payment_status', 'PAID')
            ->whereNotIn('o.status', ['CANCELED', 'RETURNED'])
            ->where('pnc.is_parent', 0)
            ->get(['o.id as order_id', 'pnc.category_id']);
        $data = [];
        foreach ($categories as $category) {
            if (!array_key_exists($category->category_id, $data)) {
                $data[$category->category_id] = [];
                $data[$category->category_id]['sale'] = 0;
                $data[$category->category_id]['order_ids'] = [];
            }
            if (!in_array($category->order_id, $data[$category->category_id]['order_ids'])) {
                $data[$category->category_id]['sale'] += 1;
            }
            $data[$category->category_id]['order_ids'][] = $category->order_id;
        }
        return $data;
    }
}
