<?php

namespace Modules\Reports\Controllers;


use Illuminate\Http\Request;
use Modules\Reports\Controllers\Controller;
use App\Helpers\DBConnect;
use Modules\Reports\Models\Role;
use Modules\Reports\Models\DesignJob;
use DateTime;
use DB;
class DesignerController extends Controller
{
    protected $locales = [];

    public function __construct () {
        $this->locales = getModuleLocale();
    }
    public function index ()
    {

        $connection = DBconnect::connect('central');
        $designers = $connection->table('role')->where('role.name', 'designer')
                ->join('role_n_user', 'role_n_user.role_id', '=', 'role.id')
                ->join('users', 'users.id', 'role_n_user.user_id')
                ->pluck('users.name', 'users.id');

        return view('reports::designer.index', [
                'designers' => $designers, 
                'locates' => $this->locales
            ]);

    }

    public function find (Request $request)
    {
        $retVal = [
            'status' => 'fail',
            'result' => []
        ];
        $filter = $request->all();

        $query = DesignJob::whereNotNull('designer_id')
            ->where('status', 'done');
        if(isset($filter['date_from']) && $filter['date_from']) {
            $time = \DateTime::createFromFormat('d/m/Y', $filter['date_from']);
            $query->where('created_at', '>=' , $time->setTime(0, 0, 0));
        }
        if(isset($filter['date_to']) && $filter['date_to']) {
            $time = \DateTime::createFromFormat('d/m/Y', $filter['date_to']);
            $query->where('created_at', '<=', $time->setTime(23, 59, 59));
        }

        if(isset($filter['local_code']) && $filter['local_code']) {
            $query->where('local_code', '=', $filter['local_code']);
        }

        if(isset($filter['email']) && $filter['email']) {
            $connection = DBconnect::connect('central');
            $designer = $connection->table('users')->where('email', $filter['email'])->first();
            $query->where('designer_id', '=', $designer->id);
        }
        
        $designJobs = $query->get();
        $result = [];
        foreach ($designJobs as $designJob) {
            if (!array_key_exists($designJob->designer_id, $result)) {
                $result[$designJob->designer_id] = [
                    'total_rate' => 0,
                    'total_kpi' => 0,
                    'total_designs' => 0,
                    'total_finish_time' => 0,
                    'designer_id' => $designJob->designer_id
                ];
            }
            $result[$designJob->designer_id]['total_designs']++;
            $result[$designJob->designer_id]['total_kpi'] += $designJob['kpi_point'];
            $result[$designJob->designer_id]['total_rate'] += $designJob['rate'];
            $diff_time = (strtotime($designJob['finished_at']) - strtotime($designJob['assigned_at'])) / 60;
            $result[$designJob->designer_id]['total_finish_time'] += $diff_time;
        }
        $retVal['status'] = 'successful';
        $retVal['result'] = $result;
        return $retVal;
    }

    private function getReportByLocale($locale)
    {
        $connection = DBconnect::connect($locale['locale']);

    }
    

    
}