<?php

namespace Modules\Reports\Controllers;


use Illuminate\Http\Request;
use Modules\Reports\Controllers\Controller;
use App\Helpers\DBConnect;

class HelpCentralController extends Controller
{
    protected $pageSize = 100;
    
    public function index (Request $request) {
        $connection = DBconnect::connect();
        $users = $connection->table('users')->leftJoin('role_n_user', 'role_n_user.user_id', '=', 'users.id')
                        ->where('role_n_user.role_id', '=', 17)
                        ->where('users.status', '=', 'ACTIVE')
                        ->pluck('users.name', 'users.id');
        $locates = getModuleLocale();
        $locales = [];
        foreach ($locates as $locale) {
            if ($locale['enable'] && $locale['enable'] != 'central') {
                $locales[$locale['locale']] = $locale['name'];
            }
        }
        return view('reports::help-central.index', ['users' => $users->toArray(), 'locates' => $locales]);
    }

    public function find(Request $request) {
        $filter = $this->buildFilter($request);
        $response = $this->getData($filter);
        return response()->json($response);
    }

    private function getData($filter) {
        $result = $this->getResult($filter);
        $lastTicket = $this->getLastTicket($filter, $result);
        $this->decorResult($result);
        $pageId = $filter['page_id'];
        unset($filter['page_size']);
        unset($filter['page_id']);
        $filter['metric'] = 'count';
        $itemCount = $this->getResult($filter);
        $pagesCount = $this->recordsCountToPagesCount($itemCount, $this->pageSize);
        if (isset($filter['is_export']) && $filter['is_export']) {
            return $result;
        } else {
            $response = array(
                "status" => 'successful',
                "result" => $result,
                'pagesCount' => $pagesCount,
                'pageId' => $pageId
            );
            return $response;
        }
    }

    protected function getLastTicket($filter, &$result) {
        $connection = DBconnect::connect();
        $query = $connection->table('ticket_report');
        $latestDate = $query->max('date');
        $query = $connection->table('ticket_report');
        if (isset($filter['user_id']) && $filter['user_id'] != '') {
            $query->where('user_id', '=', $filter['user_id']);
        } else {
            $connection = DBconnect::connect();
            $users = $connection->table('users')->leftJoin('role_n_user', 'role_n_user.user_id', '=', 'users.id')
                        ->where('role_n_user.role_id', '=', 17)
                        ->where('users.status', '=', 'ACTIVE')
                        ->pluck('users.id')->toArray();
            $query->whereIn('user_id', $users);
        }
        if (isset($filter['type']) && $filter['type'] != '') {
            $query->where('type', '=', $filter['type']);
        }
        $query->where('date', '=', $latestDate);
        if (isset($filter['type']) && $filter['type'] != '') {
            $query->select("user_id", "type",
                \DB::raw("(SUM(number_inprocess) - SUM(number_not_solved)) as number_inprocess"), 
                \DB::raw("SUM(number_not_solved) as number_not_solved")
            )
            ->groupBy('user_id', 'type');
        } else {
            $query->select("user_id",
                \DB::raw("(SUM(number_inprocess) - SUM(number_not_solved)) as number_inprocess"), 
                \DB::raw("SUM(number_not_solved) as number_not_solved")
            )
            ->groupBy('user_id');
        }
        $items = $query->get();
        $dataByKey = [];
        foreach($items as $item) {
            $key = $item->user_id;
            if (isset($filter['type']) && !empty($filter['type'])) {
                $key .= '-' . $item->type;
            }
            if (!isset($dataByKey[$key])) {
                $dataByKey[$key] = $item;
            }
        }
        foreach($result as &$item) {
            $key = $item->user_id;
            if (isset($filter['type']) && !empty($filter['type'])) {
                $key .= '-' . $item->type;
            }
            if (isset($dataByKey[$key])) {
                $item->number_inprocess = $dataByKey[$key]->number_inprocess;
                $item->number_not_solved = $dataByKey[$key]->number_not_solved;
            }
        }
    }

    private function decorResult(&$items) {
        foreach ($items as $item) {
            if ($item->time_reply > 0) {
                $item->time_reply = $this->seconds2human(round($item->time_reply, 0));
            }
            if ($item->time_close > 0) {
                $item->time_close = $this->seconds2human(round($item->time_close, 0));
            }
            if ($item->time_confirm_closed > 0) {
                $item->time_confirm_closed = $this->seconds2human(round($item->time_confirm_closed, 0));
            }
        }
    }

    private function seconds2human($ss) {
        $s = $ss%60;
        $m = floor(($ss%3600)/60);
        $h = floor(($ss%86400)/3600);
        $d = floor(($ss%2592000)/86400);
        $M = floor($ss/2592000);
        $retVal = '';
        if ($M > 0) {
            $retVal .= "$M tháng, ";
        }

        if ($d > 0) {
            $retVal .= "$d ngày, ";
        }
        if ($h > 0) {
            $retVal .= "$h giờ, ";
        }
        if ($m > 0) {
            $retVal .= "$m phút";
        }
        return $retVal;
    }

    private function getResult($filter) {
        $connection = DBconnect::connect();
        $query = $connection->table('ticket_report')
                            ->where('report_type', '=', 'ticket');
        if (isset($filter['user_id']) && $filter['user_id'] != '') {
            $query->where('user_id', '=', $filter['user_id']);
        } else {
            $connection = DBconnect::connect();
            $users = $connection->table('users')->leftJoin('role_n_user', 'role_n_user.user_id', '=', 'users.id')
                        ->where('role_n_user.role_id', '=', 17)
                        ->where('users.status', '=', 'ACTIVE')
                        ->pluck('users.id')->toArray();
            $query->whereIn('user_id', $users);
        }
        if (isset($filter['type']) && $filter['type'] != '') {
            $query->where('type', '=', $filter['type']);
        }
        if (isset($filter['query_from']) && $filter['query_from'] != '') {
            $query->where('date', '>=', $filter['query_from']);
        }
        if (isset($filter['query_to']) && $filter['query_to'] != '') {
            $query->where('date', '<=', $filter['query_to']);
        }
        if (isset($filter['type']) && $filter['type'] != '') {
            $query->select("user_id", "type",
                \DB::raw("SUM(number_closed) as number_closed"), 
                \DB::raw("SUM(number_confirm_closed) as number_confirm_closed"), 
                \DB::raw("SUM(number_message) as number_message"),
                \DB::raw("SUM(number_assigned) as number_assigned"),
                \DB::raw("AVG(avrg_time_reply) as time_reply"),
                \DB::raw("AVG(avrg_time_close) as time_close"),
                \DB::raw("AVG(avrg_time_confirm_closed) as time_confirm_closed"),
                \DB::raw("SUM(number_solved) as number_solved")
            )
            ->groupBy('user_id', 'type');
        } else {
            $query->select("user_id",
                \DB::raw("SUM(number_closed) as number_closed"), 
                \DB::raw("SUM(number_confirm_closed) as number_confirm_closed"),
                \DB::raw("SUM(number_message) as number_message"),
                \DB::raw("SUM(number_assigned) as number_assigned"),
                \DB::raw("AVG(avrg_time_reply) as time_reply"),
                \DB::raw("AVG(avrg_time_close) as time_close"),
                \DB::raw("AVG(avrg_time_confirm_closed) as time_confirm_closed"),
                \DB::raw("SUM(number_solved) as number_solved")
            )
            ->groupBy('user_id');
        }
        
        if (isset($filter['metric']) && $filter['metric'] == 'count') {
            return $query->count();
        } else {
            if (isset($filter['orders']) && count($filter['orders']) > 0) {
                foreach ($filter['orders'] as $key => $value) {
                    $query->orderBy($key, $value);
                }
            }
            if (isset($filter['page_size']) && isset($filter['page_id'])) {
                $query->forPage($filter['page_id'] + 1, $filter['page_size']);
            }
            return $query->get();
        }
        
    }

    private function buildFilter($request) {
        $params = ['user_id', 'type', 'is_export'];
        $retVal = [];
        foreach ($params as $param) {
            if ($request->has($param)) {
                $retVal[$param] = $request->input($param);
            }
        }
        $currentDate = new \DateTime();
        $fromDate = $request->has('dateFrom') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateFrom')) : $currentDate;
        $toDate = $request->has('dateTo') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateTo')) : $currentDate;
        $retVal['query_from'] = $fromDate->setTime(0, 0, 0);
        $retVal['query_to'] = $toDate->setTime(23,59,59);
        $sort = $request->has('sort') ? $request->input('sort') : '';
        if ($sort != '') {
            $retVal['sort'] = $sort;
            $arrOrders = explode('-', $retVal['sort']);
            $retVal['orders'] = [$arrOrders[0] => $arrOrders[1]];
        } else {
            $retVal['orders'] = ['number_assigned' => 'desc'];
        }
        $isExport = (isset($retVal['is_export']) &&  $retVal['is_export']) ? $retVal['is_export'] : null;
        if ($isExport != null && $isExport) {
            $retVal['page_size'] = 40000;
        } else {
            $retVal['page_size'] = $this->pageSize;
        }
        $retVal['page_id'] = $request->has('page_id') ? $request->input('page_id') : 0;
        return $retVal;
    }

    private function recordsCountToPagesCount($recordsCount, $pageSize)
    {
        $retVal = (int)($recordsCount / $pageSize);
        if ($recordsCount % $pageSize > 0) {
            $retVal++;
        }
        //return
        return $retVal;
    }

    public function buildChart(Request $request) {
        $currentDate = new \DateTime();
        $fromDate = $request->has('dateFrom') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateFrom')) : $currentDate;
        $toDate = $request->has('dateTo') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateTo')) : $currentDate;
        $queryFrom = $fromDate->setTime(0, 0, 0);
        $queryTo = $toDate->setTime(23,59,59);
        $connection = DBconnect::connect();
        $query = $connection->table('ticket_report');
        $query->where('date', '>=', $queryFrom);
        $query->where('date', '<=', $queryTo);
        if ($request->has('user_id')) {
            $query->where('user_id', '=', $request->get('user_id'));
        }
        if ($request->has('type')) {
            $query->where('type', '=', $request->get('type'));
        }
        $query->select("date",
                \DB::raw("SUM(number_closed) as number_closed"), 
                \DB::raw("(SUM(number_inprocess) - SUM(number_not_solved)) as number_inprocess"),
                \DB::raw("SUM(number_assigned) as number_assigned"),
                \DB::raw("SUM(number_not_solved) as number_not_solved"),
                \DB::raw("SUM(number_auto) as number_auto")
            )
            ->groupBy('date');

        $items = $query->get();

        $orderQuery = $connection->table('ticket_report')
                                 ->where('report_type', 'order');
        $orderQuery->where('date', '>=', $queryFrom);
        $orderQuery->where('date', '<=', $queryTo);
        $orders = $orderQuery->get(['number_order', 'date']);
        $orderByDate = [];
        foreach($orders as $order) {
            $orderByDate[$order->date] = $order->number_order;
        }
        foreach($items as $item) {
            $item->number_order = 0;
            if (isset($orderByDate[$item->date])) {
                $item->number_order = $orderByDate[$item->date];
            }
        }
        $response = [
            'status' => 'successful',
            'result' => $items
        ];
        return response()->json($response);
    }
}
